/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.nodevalue.XSDFuncOp;
import org.apache.jena.sparql.function.FunctionEnv;

public class E_If
extends ExprFunction3 {
    private static final String functionName = "if";
    private final Expr condition;
    private final Expr thenExpr;
    private final Expr elseExpr;

    public E_If(Expr condition, Expr thenExpr, Expr elseExpr) {
        super(condition, thenExpr, elseExpr, functionName);
        this.condition = condition;
        this.thenExpr = thenExpr;
        this.elseExpr = elseExpr;
    }

    @Override
    public Expr copy(Expr arg1, Expr arg2, Expr arg3) {
        return new E_If(arg1, arg2, arg3);
    }

    @Override
    protected NodeValue evalSpecial(Binding binding, FunctionEnv env) {
        NodeValue nv = this.condition.eval(binding, env);
        boolean ebv = XSDFuncOp.effectiveBooleanValue(nv);
        if (ebv) {
            return this.thenExpr.eval(binding, env);
        }
        return this.elseExpr.eval(binding, env);
    }

    @Override
    public NodeValue eval(NodeValue x, NodeValue y, NodeValue z) {
        throw new ARQInternalErrorException();
    }
}

