/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;

public class PrefixMapStd
extends PrefixMapBase {
    final Map<String, String> prefixes = new ConcurrentHashMap<String, String>();
    private final Map<String, String> prefixes2 = Collections.unmodifiableMap(this.prefixes);
    private final Map<String, String> uriToPrefix = new ConcurrentHashMap<String, String>();

    public PrefixMapStd() {
    }

    public PrefixMapStd(PrefixMap prefixMap) {
        Objects.requireNonNull(prefixMap);
        this.prefixes.putAll(prefixMap.getMapping());
    }

    @Override
    public Map<String, String> getMapping() {
        return this.prefixes2;
    }

    @Override
    public String get(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.prefixes.get(prefix);
    }

    @Override
    public void add(String prefix, String iri2) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(iri2);
        prefix = PrefixLib.canonicalPrefix(prefix);
        String oldURI = this.prefixes.get(prefix);
        if (oldURI != null) {
            this.uriToPrefix.remove(oldURI);
        }
        this.prefixes.put(prefix, iri2);
        this.uriToPrefix.put(iri2.toString(), prefix);
    }

    @Override
    public void delete(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix(prefix);
        this.prefixes.remove(prefix);
        this.uriToPrefix.values().remove(prefix);
    }

    @Override
    public void clear() {
        this.prefixes.clear();
    }

    @Override
    public boolean containsPrefix(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix(prefix);
        return this.prefixes.containsKey(prefix);
    }

    @Override
    public String abbreviate(String uriStr) {
        Objects.requireNonNull(uriStr);
        Pair<String, String> p = this.abbrev(uriStr);
        if (p == null) {
            return null;
        }
        return p.getLeft() + ":" + p.getRight();
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        String ln2;
        String uriForPrefix;
        Objects.requireNonNull(uriStr);
        String candidate = PrefixMapStd.getPossibleKey(uriStr);
        if (candidate != null && (uriForPrefix = this.uriToPrefix.get(candidate)) != null && PrefixLib.isSafeLocalPart(ln2 = uriStr.substring(candidate.length()))) {
            return Pair.create(uriForPrefix, ln2);
        }
        return PrefixLib.abbrev(this.prefixes, uriStr, true);
    }

    protected static String getPossibleKey(String iriString) {
        int index = iriString.lastIndexOf(35);
        if (index > -1) {
            return iriString.substring(0, index + 1);
        }
        index = iriString.lastIndexOf(47);
        if (index > -1) {
            return iriString.substring(0, index + 1);
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.prefixes.isEmpty();
    }

    @Override
    public int size() {
        return this.prefixes.size();
    }
}

