/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.function.Function;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.NodeFmtLib;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFWrapper;
import org.apache.jena.sparql.core.Quad;

public class StreamTriplesOnly
extends StreamRDFWrapper {
    private static Function<Quad, QuadPolicy> actionException = q -> {
        throw new RiotException("Quad in Triple output: " + NodeFmtLib.str(q));
    };
    private QuadPolicy quadAction = QuadPolicy.CALL;
    private final Function<Quad, QuadPolicy> action;

    public static StreamRDF setActionIfQuads(StreamRDF stream, Function<Quad, QuadPolicy> action) {
        while (stream instanceof StreamTriplesOnly) {
            StreamTriplesOnly stream2 = (StreamTriplesOnly)stream;
            stream = stream2.get();
        }
        return StreamTriplesOnly.addActionIfQuads(stream, action);
    }

    public static StreamRDF addActionIfQuads(StreamRDF stream, Function<Quad, QuadPolicy> action) {
        return new StreamTriplesOnly(stream, action);
    }

    public static StreamRDF exceptionOnQuads(StreamRDF stream) {
        return new StreamTriplesOnly(stream, actionException);
    }

    private StreamTriplesOnly(StreamRDF sink, Function<Quad, QuadPolicy> action) {
        super(sink);
        this.action = action;
    }

    @Override
    public void quad(Quad quad) {
        if (quad.getGraph() == null || quad.isTriple() || quad.isDefaultGraph()) {
            this.triple(quad.asTriple());
            return;
        }
        if (this.quadAction == QuadPolicy.CALL) {
            this.quadAction = this.action.apply(quad);
        }
    }

    public static enum QuadPolicy {
        CALL,
        IGNORE;

    }
}

