/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIterConvert;

public class QueryIterCommonParent
extends QueryIterConvert {
    public QueryIterCommonParent(QueryIterator input, Binding binding, ExecutionContext execCxt) {
        super(input, new ConverterExtend(binding), execCxt);
    }

    static class ConverterExtend
    implements QueryIterConvert.Converter {
        private Binding parentBinding;

        ConverterExtend(Binding parent) {
            this.parentBinding = parent;
        }

        @Override
        public Binding convert(Binding b) {
            if (this.parentBinding == null || this.parentBinding.isEmpty()) {
                return b;
            }
            BindingBuilder b2 = Binding.builder(this.parentBinding);
            Iterator<Var> iter = b.vars();
            while (iter.hasNext()) {
                Var v = iter.next();
                Node n = b.get(v);
                if (b2.contains(v)) {
                    Node n2 = b2.get(v);
                    if (n2.equals((Object)n)) {
                        Log.warn((Object)this, (String)("Binding already for " + String.valueOf((Object)v) + " (same value)"));
                    } else {
                        Log.error((Object)this, (String)("Binding already for " + String.valueOf((Object)v) + " (different values)"));
                        throw new ARQInternalErrorException("Incompatible bindings for " + String.valueOf((Object)v));
                    }
                }
                b2.add(v, n);
            }
            return b2.build();
        }
    }
}

