/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.stream;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.james.mime4j.MimeException;
import org.apache.james.mime4j.io.BufferedLineReaderInputStream;
import org.apache.james.mime4j.io.LineNumberInputStream;
import org.apache.james.mime4j.io.LineNumberSource;
import org.apache.james.mime4j.io.MaxHeaderLengthLimitException;
import org.apache.james.mime4j.io.MaxHeaderLimitException;
import org.apache.james.mime4j.io.MaxLineLimitException;
import org.apache.james.mime4j.stream.BodyDescriptorBuilder;
import org.apache.james.mime4j.stream.DefaultFieldBuilder;
import org.apache.james.mime4j.stream.EntityState;
import org.apache.james.mime4j.stream.EntityStateMachine;
import org.apache.james.mime4j.stream.FallbackBodyDescriptorBuilder;
import org.apache.james.mime4j.stream.FieldBuilder;
import org.apache.james.mime4j.stream.MimeConfig;
import org.apache.james.mime4j.stream.MimeEntity;
import org.apache.james.mime4j.stream.RawField;
import org.apache.james.mime4j.stream.RecursionMode;

public class MimeEntityTest
extends TestCase {
    public void testSimpleEntity() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12);
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"To", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Road Runner <runner@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"From", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Wile E. Cayote <wile@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Date", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Tue, 12 Feb 2008 17:34:09 +0000 (GMT)", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Subject", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Mail", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"text/plain", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
        try {
            entity.getField().getName();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            entity.getField().getBody();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_BODY, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"a very important message", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MESSAGE, (Object)entity.getState());
        try {
            entity.getContentStream();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)entity.getState());
        try {
            entity.advance();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testObsoleteSyntaxEntity() throws Exception {
        String message = "To \t: Road Runner <runner@example.org>\r\nFrom\t: Wile E. Cayote <wile@example.org>\r\nDate  \t:Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject\t:Mail\r\n     \r\n with a folded subject \r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12);
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"To", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Road Runner <runner@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"From", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Wile E. Cayote <wile@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Date", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Tue, 12 Feb 2008 17:34:09 +0000 (GMT)", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Subject", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Mail      with a folded subject ", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"text/plain", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
        try {
            entity.getField().getName();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            entity.getField().getBody();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_BODY, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"a very important message", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MESSAGE, (Object)entity.getState());
        try {
            entity.getContentStream();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)entity.getState());
        try {
            entity.advance();
            MimeEntityTest.fail((String)"IllegalStateException should have been thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testMultipartEntity() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nHello!\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nblah blah blah\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nyada yada yada\r\n--1729--\r\nGoodbye!";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 24);
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"To", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Road Runner <runner@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"From", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Wile E. Cayote <wile@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Date", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Tue, 12 Feb 2008 17:34:09 +0000 (GMT)", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Subject", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Mail", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"multipart/mixed;boundary=1729", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MULTIPART, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_PREAMBLE, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Hello!", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        EntityStateMachine p1 = entity.advance();
        MimeEntityTest.assertNotNull((Object)p1);
        MimeEntityTest.assertEquals((Object)EntityState.T_START_BODYPART, (Object)p1.getState());
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)p1.getState());
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)p1.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)p1.getField().getName());
        MimeEntityTest.assertEquals((String)"text/plain; charset=US-ASCII", (String)p1.getField().getBody());
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)p1.getState());
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_BODY, (Object)p1.getState());
        MimeEntityTest.assertEquals((String)"blah blah blah", (String)IOUtils.toString((InputStream)p1.getContentStream()));
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_BODYPART, (Object)p1.getState());
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)p1.getState());
        EntityStateMachine p2 = entity.advance();
        MimeEntityTest.assertNotNull((Object)p2);
        MimeEntityTest.assertEquals((Object)EntityState.T_START_BODYPART, (Object)p2.getState());
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)p2.getState());
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)p2.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)p2.getField().getName());
        MimeEntityTest.assertEquals((String)"text/plain; charset=US-ASCII", (String)p2.getField().getBody());
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)p2.getState());
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_BODY, (Object)p2.getState());
        MimeEntityTest.assertEquals((String)"yada yada yada", (String)IOUtils.toString((InputStream)p2.getContentStream()));
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_BODYPART, (Object)p2.getState());
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)p2.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_EPILOGUE, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Goodbye!", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MULTIPART, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)entity.getState());
    }

    public void testRawEntity() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: multipart/mixed;boundary=1729\r\n\r\nHello!\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nblah blah blah\r\n--1729\r\nContent-Type: text/plain; charset=US-ASCII\r\n\r\nyada yada yada\r\n--1729--\r\nGoodbye!";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 24);
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        entity.setRecursionMode(RecursionMode.M_RAW);
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"To", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Road Runner <runner@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"From", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Wile E. Cayote <wile@example.org>", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Date", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Tue, 12 Feb 2008 17:34:09 +0000 (GMT)", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Subject", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Mail", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"multipart/mixed;boundary=1729", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MULTIPART, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_PREAMBLE, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Hello!", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        EntityStateMachine p1 = entity.advance();
        MimeEntityTest.assertNotNull((Object)p1);
        MimeEntityTest.assertEquals((Object)EntityState.T_RAW_ENTITY, (Object)p1.getState());
        MimeEntityTest.assertNull((Object)p1.getBodyDescriptor());
        MimeEntityTest.assertNull((Object)p1.getField());
        MimeEntityTest.assertEquals((String)"Content-Type: text/plain; charset=US-ASCII\r\n\r\nblah blah blah", (String)IOUtils.toString((InputStream)p1.getContentStream()));
        p1.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)p1.getState());
        EntityStateMachine p2 = entity.advance();
        MimeEntityTest.assertNotNull((Object)p2);
        MimeEntityTest.assertEquals((Object)EntityState.T_RAW_ENTITY, (Object)p2.getState());
        MimeEntityTest.assertNull((Object)p2.getBodyDescriptor());
        MimeEntityTest.assertNull((Object)p2.getField());
        MimeEntityTest.assertEquals((String)"Content-Type: text/plain; charset=US-ASCII\r\n\r\nyada yada yada", (String)IOUtils.toString((InputStream)p2.getContentStream()));
        p2.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)p2.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_EPILOGUE, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Goodbye!", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MULTIPART, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_OF_STREAM, (Object)entity.getState());
    }

    public void testMaxLineLimitCheck() throws Exception {
        MimeConfig config = MimeConfig.custom().setMaxLineLen(50).build();
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nDoS: xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12, config.getMaxLineLen());
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, config, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        try {
            entity.advance();
            MimeEntityTest.fail((String)"MimeException caused by MaxLineLimitException should have been thrown");
        }
        catch (MimeException expected) {
            MimeEntityTest.assertTrue((boolean)(expected.getCause() instanceof MaxLineLimitException));
            MimeEntityTest.assertTrue((boolean)expected.getMessage().contains("" + config.getMaxLineLen()));
        }
    }

    public void testMaxHeaderLimitCheckFoldedLines() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxx\r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12);
        MimeConfig config = MimeConfig.custom().setMaxLineLen(100).setMaxHeaderLen(200).build();
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, config, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        try {
            entity.advance();
            MimeEntityTest.fail((String)"MimeException caused by MaxLineLimitException should have been thrown");
        }
        catch (MaxHeaderLengthLimitException expected) {
            MimeEntityTest.assertTrue((boolean)expected.getMessage().contains("" + config.getMaxHeaderLen()));
        }
    }

    public void testMaxHeaderLengthMayExceedMaxLineLength() throws Exception {
        MimeConfig config = MimeConfig.custom().setMaxLineLen(50).setMaxHeaderLen(130).build();
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nX-LongHeader: xxxxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxxxx\r\n    xxxxxxxxxxxxxxxxxxxxxxx\r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12, config.getMaxLineLen());
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, config, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        for (int i = 0; i < 6; ++i) {
            entity.advance();
            MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        }
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
    }

    public void testMaxHeaderCount() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nDoS: xxxxxxxxxxxxxxxxxxxxx\r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12);
        MimeConfig config = MimeConfig.custom().setMaxHeaderCount(20).build();
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, config, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        for (int i = 0; i < 20; ++i) {
            entity.advance();
            MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        }
        try {
            entity.advance();
            MimeEntityTest.fail((String)"MaxHeaderLimitException should have been thrown");
        }
        catch (MaxHeaderLimitException expected) {
            MimeEntityTest.assertTrue((boolean)expected.getMessage().contains("" + config.getMaxHeaderCount()));
        }
    }

    public void testMaxContentLimitCheck() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: text/plain\r\n\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\nDoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS DoS\r\n";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12);
        MimeConfig config = MimeConfig.custom().setMaxContentLen(100L).build();
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, config, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_BODY, (Object)entity.getState());
        try {
            IOUtils.toByteArray((InputStream)entity.getContentStream());
            MimeEntityTest.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testSkipFields() throws Exception {
        String message = "To: Road Runner <runner@example.org>\r\nFrom: Wile E. Cayote <wile@example.org>\r\nDate: Tue, 12 Feb 2008 17:34:09 +0000 (GMT)\r\nSubject: Mail\r\nContent-Type: text/plain\r\n\r\na very important message";
        byte[] raw = message.getBytes("US-ASCII");
        ByteArrayInputStream instream = new ByteArrayInputStream(raw);
        LineNumberInputStream lineInput = new LineNumberInputStream((InputStream)instream);
        BufferedLineReaderInputStream rawstream = new BufferedLineReaderInputStream((InputStream)lineInput, 12);
        DefaultFieldBuilder fieldBuilder = new DefaultFieldBuilder(-1){

            public RawField build() throws MimeException {
                RawField raw = super.build();
                String name = raw.getName().toLowerCase(Locale.US);
                if (name.equals("content-type") || name.equals("subject")) {
                    return raw;
                }
                return null;
            }
        };
        MimeEntity entity = new MimeEntity((LineNumberSource)lineInput, (InputStream)rawstream, (FieldBuilder)fieldBuilder, (BodyDescriptorBuilder)new FallbackBodyDescriptorBuilder());
        MimeEntityTest.assertEquals((Object)EntityState.T_START_MESSAGE, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_START_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Subject", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"Mail", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_FIELD, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"Content-Type", (String)entity.getField().getName());
        MimeEntityTest.assertEquals((String)"text/plain", (String)entity.getField().getBody());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_HEADER, (Object)entity.getState());
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_BODY, (Object)entity.getState());
        MimeEntityTest.assertEquals((String)"a very important message", (String)IOUtils.toString((InputStream)entity.getContentStream()));
        entity.advance();
        MimeEntityTest.assertEquals((Object)EntityState.T_END_MESSAGE, (Object)entity.getState());
    }
}

