/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.impl.EmptyIterator;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.AdaptObjectIntProcedureToProcedure;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.Iterate;

public class FlatCollectIntToObjectIterable<V>
extends AbstractLazyIterable<V> {
    private final IntIterable iterable;
    private final IntToObjectFunction<? extends Iterable<V>> function;

    public FlatCollectIntToObjectIterable(IntIterable iterable, IntToObjectFunction<? extends Iterable<V>> function) {
        this.iterable = iterable;
        this.function = function;
    }

    @Override
    public void each(Procedure<? super V> procedure) {
        this.iterable.forEach((int each) -> Iterate.forEach(this.function.valueOf(each), procedure));
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        AdaptObjectIntProcedureToProcedure<? super V> innerProcedure = new AdaptObjectIntProcedureToProcedure<V>(objectIntProcedure);
        this.iterable.forEach((int each) -> {
            Iterable<V> iterable = this.function.valueOf(each);
            Iterate.forEach(iterable, innerProcedure);
        });
    }

    @Override
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        this.iterable.forEach((int each) -> Iterate.forEachWith(this.function.valueOf(each), procedure, parameter));
    }

    @Override
    public Iterator<V> iterator() {
        return new FlatCollectIntIterator(this.iterable, this.function);
    }

    @Override
    public V detect(Predicate<? super V> predicate) {
        Object[] result = new Object[1];
        this.iterable.anySatisfy((int each) -> {
            Iterable<V> it = this.function.valueOf(each);
            return Iterate.anySatisfy(it, each1 -> {
                if (predicate.accept((Object)each1)) {
                    result[0] = each1;
                    return true;
                }
                return false;
            });
        });
        return (V)result[0];
    }

    @Override
    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        Object[] result = new Object[1];
        this.iterable.anySatisfy((int each) -> {
            Iterable<V> it = this.function.valueOf(each);
            if (this.iterable == null) {
                throw new NullPointerException();
            }
            return Iterate.anySatisfy(it, each1 -> {
                if (predicate.accept((Object)each1)) {
                    if (each1 == null) {
                        throw new NullPointerException();
                    }
                    result[0] = each1;
                    return true;
                }
                return false;
            });
        });
        return Optional.ofNullable(result[0]);
    }

    @Override
    public boolean anySatisfy(Predicate<? super V> predicate) {
        return this.iterable.anySatisfy((int each) -> Iterate.anySatisfy(this.function.valueOf(each), predicate));
    }

    @Override
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.anySatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean allSatisfy(Predicate<? super V> predicate) {
        return this.iterable.allSatisfy((int each) -> Iterate.allSatisfy(this.function.valueOf(each), predicate));
    }

    @Override
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.allSatisfy(Predicates.bind(predicate, parameter));
    }

    @Override
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        return this.iterable.noneSatisfy((int each) -> Iterate.anySatisfy(this.function.valueOf(each), predicate));
    }

    @Override
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        return this.noneSatisfy(Predicates.bind(predicate, parameter));
    }

    private final class FlatCollectIntIterator<V>
    implements Iterator<V> {
        private final IntIterator iterator;
        private final IntToObjectFunction<? extends Iterable<V>> function;
        private Iterator<V> innerIterator = EmptyIterator.getInstance();

        public FlatCollectIntIterator(IntIterable iterable, IntToObjectFunction<? extends Iterable<V>> newFunction) {
            this(iterable.intIterator(), newFunction);
        }

        public FlatCollectIntIterator(IntIterator newIterator, IntToObjectFunction<? extends Iterable<V>> newFunction) {
            this.iterator = newIterator;
            this.function = newFunction;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from a flatCollectInt iterator");
        }

        @Override
        public boolean hasNext() {
            while (!this.innerIterator.hasNext()) {
                if (!this.iterator.hasNext()) {
                    return false;
                }
                this.innerIterator = this.function.valueOf(this.iterator.next()).iterator();
            }
            return true;
        }

        @Override
        public V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.innerIterator.next();
        }
    }
}

