/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools.validate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileResourcePipeStatisticsSetTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TsFileResourcePipeStatisticsSetTool.class);
    private static final String USAGE = "Usage: [--isGeneratedByPipe true|false] [--resetProgressIndex] --dirs <dir1> <dir2> ...\n  --isGeneratedByPipe: whether the TsFileResource is isGeneratedByPipe to be generated by pipe\n  --resetProgressIndex: whether to reset the TsFileResources' progressIndexes\n  --dirs: list of data directories to validate and repair";
    private static final Set<File> dataDirs = new ConcurrentSkipListSet<File>();
    private static AtomicBoolean isGeneratedByPipeMark = null;
    private static boolean resetProgressIndex = false;
    private static final AtomicLong runtime = new AtomicLong(System.currentTimeMillis());
    private static final AtomicInteger totalTsFileNum = new AtomicInteger(0);
    private static final AtomicInteger toResetFlagNum = new AtomicInteger(0);
    private static final AtomicInteger toResetProgressIndexNum = new AtomicInteger(0);
    private static final AtomicInteger changedNum = new AtomicInteger(0);

    public static void main(String[] args) throws IOException {
        TsFileResourcePipeStatisticsSetTool.parseCommandLineArgs(args);
        List<File> partitionDirs = TsFileResourcePipeStatisticsSetTool.findAllPartitionDirs();
        partitionDirs.parallelStream().forEach(TsFileResourcePipeStatisticsSetTool::validateAndRepairTsFileResourcesInPartition);
        TsFileResourcePipeStatisticsSetTool.printStatistics();
    }

    private static void parseCommandLineArgs(String[] args) {
        ConcurrentSkipListSet argSet = new ConcurrentSkipListSet(args.length > 0 ? Arrays.asList(args) : Collections.emptyList());
        if (args.length == 0 || argSet.contains("--help") || argSet.contains("-h") || !argSet.contains("--isGeneratedByPipe") && !argSet.contains("--resetProgressIndex") || !argSet.contains("--dirs")) {
            LOGGER.info(USAGE);
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            if ("--isGeneratedByPipe".equals(args[i]) && i + 1 < args.length) {
                isGeneratedByPipeMark = new AtomicBoolean(Boolean.parseBoolean(args[++i]));
                continue;
            }
            if ("--resetProgressIndex".equals(args[i])) {
                resetProgressIndex = true;
                continue;
            }
            if ("--dirs".equals(args[i]) && i + 1 < args.length) {
                ++i;
                while (i < args.length && !args[i].startsWith("--")) {
                    dataDirs.add(new File(args[i++]));
                }
                --i;
                continue;
            }
            LOGGER.info("Unknown argument: {}", (Object)args[i]);
            LOGGER.info(USAGE);
            System.exit(1);
        }
        if (dataDirs.isEmpty()) {
            LOGGER.info("No data directories provided. Please specify with --dirs <dir1> <dir2> ...");
            System.exit(1);
        }
        LOGGER.info("------------------------------------------------------");
        LOGGER.info("isGeneratedByPipe mark: {}", (Object)isGeneratedByPipeMark);
        LOGGER.info("resetProgressIndex: {}", (Object)resetProgressIndex);
        LOGGER.info("Data directories: ");
        for (File dir : dataDirs) {
            LOGGER.info("  {}", (Object)dir.getAbsolutePath());
        }
        LOGGER.info("------------------------------------------------------");
    }

    private static List<File> findAllPartitionDirs() {
        ArrayList<File> partitionDirs = new ArrayList<File>();
        for (File dataDir : dataDirs) {
            if (!dataDir.exists() || !dataDir.isDirectory()) continue;
            partitionDirs.addAll(TsFileResourcePipeStatisticsSetTool.findLeafDirectories(dataDir));
        }
        return partitionDirs;
    }

    public static List<File> findLeafDirectories(File dir) {
        ArrayList<File> leafDirectories = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            leafDirectories.add(dir);
            return leafDirectories;
        }
        for (File file : files) {
            if (!file.isDirectory()) continue;
            leafDirectories.addAll(TsFileResourcePipeStatisticsSetTool.findLeafDirectories(file));
        }
        if (leafDirectories.isEmpty()) {
            leafDirectories.add(dir);
        }
        return leafDirectories;
    }

    private static void validateAndRepairTsFileResourcesInPartition(File partitionDir) {
        AtomicInteger totalTsFileResource = new AtomicInteger(0);
        AtomicInteger toResetFlagResource = new AtomicInteger(0);
        AtomicInteger toResetProgressIndexResource = new AtomicInteger(0);
        AtomicInteger changedResource = new AtomicInteger(0);
        try {
            List<TsFileResource> resources = TsFileResourcePipeStatisticsSetTool.loadAllTsFileResources(Collections.singletonList(partitionDir));
            totalTsFileResource.addAndGet(resources.size());
            for (TsFileResource resource : resources) {
                try {
                    TsFileResourcePipeStatisticsSetTool.validateAndRepairSingleTsFileResource(resource, toResetFlagResource, toResetProgressIndexResource, changedResource);
                }
                catch (Exception e) {
                    LOGGER.warn("Error validating or repairing resource {}: {}", new Object[]{resource.getTsFile().getAbsolutePath(), e.getMessage(), e});
                }
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error loading resources from partition {}: {}", new Object[]{partitionDir.getAbsolutePath(), e.getMessage(), e});
        }
        totalTsFileNum.addAndGet(totalTsFileResource.get());
        toResetFlagNum.addAndGet(toResetFlagResource.get());
        toResetProgressIndexNum.addAndGet(toResetProgressIndexResource.get());
        changedNum.addAndGet(changedResource.get());
        LOGGER.info("TimePartition {} has {} total resources, {} to set isGeneratedByPipe resources, {} to reset progressIndex resources, {} changed resources. Process completed.", new Object[]{partitionDir, totalTsFileResource.get(), toResetFlagResource.get(), toResetProgressIndexResource.get(), changedResource.get()});
    }

    private static List<TsFileResource> loadAllTsFileResources(List<File> timePartitionDirs) throws IOException {
        ArrayList<TsFileResource> resources = new ArrayList<TsFileResource>();
        for (File timePartitionDir : timePartitionDirs) {
            for (File tsfile : Objects.requireNonNull(timePartitionDir.listFiles())) {
                String filePath = tsfile.getAbsolutePath();
                if (!filePath.endsWith(".tsfile") || !tsfile.isFile()) continue;
                String resourcePath = tsfile.getAbsolutePath() + ".resource";
                if (!new File(resourcePath).exists()) {
                    LOGGER.info("{} is skipped because resource file is not exist.", (Object)tsfile.getAbsolutePath());
                    continue;
                }
                TsFileResource resource = new TsFileResource(tsfile);
                resource.deserialize();
                resource.close();
                resources.add(resource);
            }
        }
        return resources;
    }

    private static void validateAndRepairSingleTsFileResource(TsFileResource resource, AtomicInteger toResetFlagResource, AtomicInteger toResetProgressIndexResource, AtomicInteger changedResource) {
        boolean skip = true;
        if (Objects.nonNull(isGeneratedByPipeMark) && resource.isGeneratedByPipe() != isGeneratedByPipeMark.get()) {
            LOGGER.info("Repairing TsFileResource: {}, isGeneratedByPipe mark: {}, actual mark: {}", new Object[]{resource.getTsFile().getAbsolutePath(), isGeneratedByPipeMark.get(), resource.isGeneratedByPipe()});
            toResetFlagResource.getAndIncrement();
            skip = false;
        }
        if (resetProgressIndex && resource.getMaxProgressIndex() != MinimumProgressIndex.INSTANCE) {
            LOGGER.info("Resetting TsFileResource:{} 's progressIndex to minimum, original progressIndex: {}", (Object)resource.getTsFile().getAbsolutePath(), (Object)resource.getMaxProgressIndex());
            toResetProgressIndexResource.getAndIncrement();
            skip = false;
        }
        if (skip) {
            return;
        }
        changedResource.getAndIncrement();
        try {
            TsFileResourcePipeStatisticsSetTool.repairSingleTsFileResource(resource);
            LOGGER.info("Marked TsFileResource as {} in resource: {}", (Object)isGeneratedByPipeMark.get(), (Object)resource.getTsFile().getAbsolutePath());
            LOGGER.info("Reset TsFileResource:{} 's progressIndex to minimum.", (Object)resource.getTsFile().getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.warn("ERROR: Failed to repair TsFileResource: {}", (Object)resource.getTsFile().getAbsolutePath(), (Object)e);
        }
    }

    private static void repairSingleTsFileResource(TsFileResource resource) throws IOException {
        if (Objects.nonNull(isGeneratedByPipeMark)) {
            resource.setGeneratedByPipe(isGeneratedByPipeMark.get());
        }
        if (resetProgressIndex) {
            resource.setProgressIndex((ProgressIndex)MinimumProgressIndex.INSTANCE);
        }
        resource.serialize();
    }

    private static void printStatistics() {
        LOGGER.info("------------------------------------------------------");
        LOGGER.info("Validation and repair completed. Statistics:");
        LOGGER.info("Total time taken: {} ms, total TsFile resources: {}, set isGeneratedByPipe resources: {}, reset progressIndex resources: {}, changed resources: {}", new Object[]{System.currentTimeMillis() - runtime.get(), totalTsFileNum.get(), toResetFlagNum.get(), toResetProgressIndexNum.get(), changedNum.get()});
    }
}

