/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.iggy.client.blocking.http;

import org.apache.iggy.message.HeaderEntry;
import org.apache.iggy.message.HeaderKey;
import org.apache.iggy.message.HeaderValue;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;

import java.util.Map;

class UserHeadersSerializer extends ValueSerializer<Map<HeaderKey, HeaderValue>> {

    @Override
    public void serialize(Map<HeaderKey, HeaderValue> headers, JsonGenerator gen, SerializationContext ctxt)
            throws JacksonException {
        gen.writeStartArray();
        for (Map.Entry<HeaderKey, HeaderValue> entry : headers.entrySet()) {
            ctxt.findValueSerializer(HeaderEntry.class)
                    .serialize(new HeaderEntry(entry.getKey(), entry.getValue()), gen, ctxt);
        }
        gen.writeEndArray();
    }
}
