/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecluster.transport;

import com.google.protobuf.InvalidProtocolBufferException;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.DatagramPacketEncoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.compression.FastLzFrameDecoder;
import io.netty.handler.codec.compression.FastLzFrameEncoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.subjects.CompletableSubject;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.bifromq.basecluster.transport.AbstractTransport;
import org.apache.bifromq.basecluster.transport.proto.Packet;
import org.apache.bifromq.baseenv.NettyEnv;
import org.apache.bifromq.baseenv.ZeroCopyParser;
import org.apache.bifromq.basehlc.HLC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UDPTransport
extends AbstractTransport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UDPTransport.class);
    private final Counter sendBytes;
    private final Counter recvBytes;
    private final DistributionSummary transportLatency;
    private final EventLoopGroup elg;
    private final Channel channel;
    private final Bridger bridger;
    private final InetSocketAddress localAddress;

    UDPTransport(@NonNull String env, InetSocketAddress bindAddr) {
        super(env);
        if (env == null) {
            throw new NullPointerException("env is marked non-null but is null");
        }
        try {
            this.bridger = new Bridger();
            this.elg = NettyEnv.createEventLoopGroup((int)4, (String)"cluster-udp-transport");
            Bootstrap bootstrap = new Bootstrap();
            this.channel = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.elg)).channel(NettyEnv.getDatagramChannelClass())).localAddress((SocketAddress)bindAddr)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel channel) {
                    channel.pipeline().addLast("compressor", (ChannelHandler)new FastLzFrameDecoder()).addLast("decompressor", (ChannelHandler)new FastLzFrameEncoder()).addLast("udpEncoder", (ChannelHandler)new DatagramPacketEncoder((MessageToMessageEncoder)new ProtobufEncoder())).addLast("Bridger", (ChannelHandler)UDPTransport.this.bridger);
                }
            })).bind().sync().channel();
            this.localAddress = (InetSocketAddress)this.channel.localAddress();
            Tags tags = Tags.of((String)"proto", (String)"udp").and("local", this.localAddress.getAddress().getHostAddress() + ":" + this.localAddress.getPort());
            this.sendBytes = Counter.builder((String)"basecluster.send.bytes").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.recvBytes = Counter.builder((String)"basecluster.recv.bytes").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            this.transportLatency = DistributionSummary.builder((String)"basecluster.transport.latency").tags((Iterable)tags).register((MeterRegistry)Metrics.globalRegistry);
            log.debug("Creating udp transport: bindAddr={}", (Object)this.localAddress);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize udp transport", e);
        }
    }

    @Override
    public InetSocketAddress bindAddress() {
        return this.localAddress;
    }

    @Override
    protected CompletableFuture<Void> doSend(Packet packet, InetSocketAddress recipient) {
        log.trace("Sending packet via udp: size={}, packet#={}, recipient={}", new Object[]{packet.getSerializedSize(), packet.hashCode(), recipient});
        this.sendBytes.increment((double)packet.getSerializedSize());
        CompletableFuture<Void> ret = new CompletableFuture<Void>();
        this.channel.writeAndFlush((Object)new DefaultAddressedEnvelope((Object)packet, (SocketAddress)recipient)).addListener(future -> {
            if (!future.isSuccess()) {
                log.warn("failed to send packet via udp, recipient={}", (Object)recipient, (Object)future.cause());
            }
            ret.complete(null);
        });
        return ret;
    }

    @Override
    protected Completable doShutdown() {
        log.debug("Closing udp transport");
        CompletableSubject doneSignal = CompletableSubject.create();
        Completable.concatArrayDelayError((CompletableSource[])new CompletableSource[]{Completable.fromFuture((Future)this.channel.close()), Completable.fromFuture((Future)this.elg.shutdownGracefully(0L, 5L, TimeUnit.SECONDS)), Completable.fromRunnable(() -> {
            Metrics.globalRegistry.remove((Meter)this.sendBytes);
            Metrics.globalRegistry.remove((Meter)this.recvBytes);
            Metrics.globalRegistry.remove((Meter)this.transportLatency);
        })}).onErrorComplete().subscribe(() -> ((CompletableSubject)doneSignal).onComplete());
        return doneSignal;
    }

    @Generated
    public static UDPTransportBuilder builder() {
        return new UDPTransportBuilder();
    }

    @ChannelHandler.Sharable
    private class Bridger
    extends SimpleChannelInboundHandler<DatagramPacket> {
        private Bridger() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket dp) {
            UDPTransport.this.recvBytes.increment((double)((ByteBuf)dp.content()).readableBytes());
            try {
                byte[] data = new byte[((ByteBuf)dp.content()).readableBytes()];
                ((ByteBuf)dp.content()).readBytes(data);
                Packet packet = (Packet)ZeroCopyParser.parse((byte[])data, Packet.parser());
                UDPTransport.this.transportLatency.record((double)HLC.INST.getPhysical(packet.getHlc() - HLC.INST.get()));
                UDPTransport.this.doReceive(packet, (InetSocketAddress)dp.sender(), (InetSocketAddress)dp.recipient());
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Unable to decode packet, just ignore");
            }
        }
    }

    @Generated
    public static class UDPTransportBuilder {
        @Generated
        private String env;
        @Generated
        private InetSocketAddress bindAddr;

        @Generated
        UDPTransportBuilder() {
        }

        @Generated
        public UDPTransportBuilder env(@NonNull String env) {
            if (env == null) {
                throw new NullPointerException("env is marked non-null but is null");
            }
            this.env = env;
            return this;
        }

        @Generated
        public UDPTransportBuilder bindAddr(InetSocketAddress bindAddr) {
            this.bindAddr = bindAddr;
            return this;
        }

        @Generated
        public UDPTransport build() {
            return new UDPTransport(this.env, this.bindAddr);
        }

        @Generated
        public String toString() {
            return "UDPTransport.UDPTransportBuilder(env=" + this.env + ", bindAddr=" + String.valueOf(this.bindAddr) + ")";
        }
    }
}

