/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.session;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import io.micrometer.core.instrument.Meter;
import io.netty.util.concurrent.FastThreadLocal;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;

public class TenantGauge {
    private final TenantMetric metric;
    private final FastThreadLocal<LoadingCache<String, AtomicLong>> threadLocalTenantMemGauge;
    private final Map<String, WeakHashMap<AtomicLong, Object>> tenantMemGauge = new ConcurrentHashMap<String, WeakHashMap<AtomicLong, Object>>();

    public TenantGauge(TenantMetric gaugeMetric) {
        assert (gaugeMetric.meterType == Meter.Type.GAUGE);
        this.metric = gaugeMetric;
        this.threadLocalTenantMemGauge = new FastThreadLocal<LoadingCache<String, AtomicLong>>(){

            protected LoadingCache<String, AtomicLong> initialValue() {
                return Caffeine.newBuilder().weakValues().build(key -> {
                    AtomicLong gauge = new AtomicLong();
                    TenantGauge.this.register((String)key, gauge);
                    return gauge;
                });
            }
        };
    }

    public AtomicLong get(String tenant) {
        return (AtomicLong)((LoadingCache)this.threadLocalTenantMemGauge.get()).get((Object)tenant);
    }

    private void register(String tenantId, AtomicLong gauge) {
        this.tenantMemGauge.compute(tenantId, (k, v) -> {
            if (v == null) {
                WeakHashMap<AtomicLong, Object> threadLocalGauges;
                v = threadLocalGauges = new WeakHashMap<AtomicLong, Object>();
                v.put(gauge, new Object());
                ITenantMeter.gauging((String)k, (TenantMetric)this.metric, () -> {
                    if (threadLocalGauges.isEmpty()) {
                        this.tenantMemGauge.remove(k, threadLocalGauges);
                        ITenantMeter.stopGauging((String)tenantId, (TenantMetric)this.metric, (String[])new String[0]);
                        return 0;
                    }
                    return threadLocalGauges.keySet().stream().mapToLong(AtomicLong::get).sum();
                }, (String[])new String[0]);
            } else {
                v.put(gauge, new Object());
            }
            return v;
        });
    }
}

