/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.client.type.HgStoreClientException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamKvIterator<E>
implements HgKvIterator<E> {
    private static final Logger log = LoggerFactory.getLogger(StreamKvIterator.class);
    private final Consumer<Boolean> closeOp;
    private String address;
    private Iterator<E> iterator = null;
    private final Supplier<Iterator<E>> iteratorSupplier;

    public StreamKvIterator(Consumer<Boolean> closeOp, Supplier<Iterator<E>> supplier) {
        this.closeOp = closeOp;
        this.iteratorSupplier = supplier;
    }

    @Override
    public byte[] key() {
        throw new HgStoreClientException("position function not supported");
    }

    @Override
    public byte[] value() {
        throw new HgStoreClientException("position function not supported");
    }

    @Override
    public void close() {
        this.closeOp.accept(true);
    }

    @Override
    public byte[] position() {
        throw new HgStoreClientException("position function not supported");
    }

    @Override
    public void seek(byte[] position) {
        throw new HgStoreClientException("seek function not supported");
    }

    @Override
    public boolean hasNext() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            this.iterator = this.iteratorSupplier.get();
        }
        return this.iterator != null && this.iterator.hasNext();
    }

    @Override
    public E next() {
        return this.iterator.next();
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }
}

