/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.AbstractGrpcClient;
import org.apache.hugegraph.store.client.grpc.GrpcUtil;
import org.apache.hugegraph.store.grpc.common.GraphMethod;
import org.apache.hugegraph.store.grpc.common.TableMethod;
import org.apache.hugegraph.store.grpc.session.BatchEntry;
import org.apache.hugegraph.store.grpc.session.BatchGetReq;
import org.apache.hugegraph.store.grpc.session.BatchReq;
import org.apache.hugegraph.store.grpc.session.BatchWriteReq;
import org.apache.hugegraph.store.grpc.session.CleanReq;
import org.apache.hugegraph.store.grpc.session.FeedbackRes;
import org.apache.hugegraph.store.grpc.session.GetReq;
import org.apache.hugegraph.store.grpc.session.GraphReq;
import org.apache.hugegraph.store.grpc.session.HgStoreSessionGrpc;
import org.apache.hugegraph.store.grpc.session.TableReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class GrpcStoreSessionClient
extends AbstractGrpcClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcStoreSessionClient.class);

    GrpcStoreSessionClient() {
    }

    public HgStoreSessionGrpc.HgStoreSessionBlockingStub getBlockingStub(ManagedChannel channel) {
        return HgStoreSessionGrpc.newBlockingStub((Channel)channel);
    }

    private HgStoreSessionGrpc.HgStoreSessionBlockingStub getBlockingStub(HgStoreNodeSession nodeSession) {
        return (HgStoreSessionGrpc.HgStoreSessionBlockingStub)this.getBlockingStub(nodeSession.getStoreNode().getAddress());
    }

    FeedbackRes doGet(HgStoreNodeSession nodeSession, String table, HgOwnerKey ownerKey) {
        return this.getBlockingStub(nodeSession).get2(GetReq.newBuilder().setHeader(GrpcUtil.getHeader(nodeSession)).setTk(GrpcUtil.toTk(table, ownerKey)).build());
    }

    FeedbackRes doClean(HgStoreNodeSession nodeSession, int partId) {
        return this.getBlockingStub(nodeSession).clean(CleanReq.newBuilder().setHeader(GrpcUtil.getHeader(nodeSession)).setPartition(partId).build());
    }

    FeedbackRes doBatchGet(HgStoreNodeSession nodeSession, String table, List<HgOwnerKey> keyList) {
        BatchGetReq.Builder builder = BatchGetReq.newBuilder();
        builder.setHeader(GrpcUtil.getHeader(nodeSession)).setTable(table);
        for (HgOwnerKey key : keyList) {
            builder.addKey(GrpcUtil.toKey(key));
        }
        if (log.isDebugEnabled()) {
            log.debug("batchGet2: {}-{}-{}-{}", new Object[]{nodeSession, table, keyList, builder.build()});
        }
        return this.getBlockingStub(nodeSession).batchGet2(builder.build());
    }

    FeedbackRes doBatch(HgStoreNodeSession nodeSession, String batchId, List<BatchEntry> entries) {
        BatchWriteReq.Builder writeReq = BatchWriteReq.newBuilder();
        writeReq.addAllEntry(entries);
        return this.getBlockingStub(nodeSession).batch(BatchReq.newBuilder().setHeader(GrpcUtil.getHeader(nodeSession)).setWriteReq(writeReq).setBatchId(batchId).build());
    }

    FeedbackRes doTable(HgStoreNodeSession nodeSession, String table, TableMethod method) {
        return this.getBlockingStub(nodeSession).table(TableReq.newBuilder().setHeader(GrpcUtil.getHeader(nodeSession)).setTableName(table).setMethod(method).build());
    }

    FeedbackRes doGraph(HgStoreNodeSession nodeSession, String graph, GraphMethod method) {
        return this.getBlockingStub(nodeSession).graph(GraphReq.newBuilder().setHeader(GrpcUtil.getHeader(nodeSession)).setGraphName(graph).setMethod(method).build());
    }
}

