/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.client.util.HgAssert;
import org.apache.hugegraph.store.grpc.common.ScanOrderType;

public interface HgScanQuery {
    public static HgScanQuery tableOf(String table) {
        return ScanBuilder.tableOf(table).build();
    }

    public static HgScanQuery rangeOf(String table, List<HgOwnerKey> startList, List<HgOwnerKey> endList) {
        return ScanBuilder.rangeOf(table, startList, endList).build();
    }

    public static HgScanQuery prefixOf(String table, List<HgOwnerKey> prefixList) {
        return ScanBuilder.prefixOf(table, prefixList).build();
    }

    public static HgScanQuery prefixOf(String table, List<HgOwnerKey> prefixList, ScanOrderType orderType) {
        return ScanBuilder.prefixOf(table, prefixList).setOrderType(orderType).build();
    }

    public static HgScanQuery prefixIteratorOf(String table, Iterator<HgOwnerKey> prefixItr) {
        return ScanBuilder.prefixIteratorOf(table, prefixItr).build();
    }

    public static HgScanQuery prefixIteratorOf(String table, Iterator<HgOwnerKey> prefixItr, ScanOrderType orderType) {
        return ScanBuilder.prefixIteratorOf(table, prefixItr).setOrderType(orderType).build();
    }

    public String getTable();

    public ScanMethod getScanMethod();

    public List<HgOwnerKey> getPrefixList();

    public Iterator<HgOwnerKey> getPrefixItr();

    public List<HgOwnerKey> getStartList();

    public List<HgOwnerKey> getEndList();

    public long getLimit();

    public long getPerKeyLimit();

    public long getPerKeyMax();

    public long getSkipDegree();

    public int getScanType();

    public ScanOrderType getOrderType();

    public boolean isOnlyKey();

    public byte[] getQuery();

    public ScanBuilder builder();

    public static class ScanBuilder {
        private final String table;
        private final ScanMethod sanMethod;
        private long limit = Integer.MAX_VALUE;
        private long perKeyLimit = Integer.MAX_VALUE;
        private long perKeyMax = Integer.MAX_VALUE;
        private int scanType;
        private ScanOrderType orderType;
        private long skipDegree;
        private boolean onlyKey;
        private byte[] query;
        private List<HgOwnerKey> prefixList;
        private List<HgOwnerKey> startList;
        private List<HgOwnerKey> endList;
        private Iterator<HgOwnerKey> prefixItr;

        ScanBuilder(ScanMethod sanMethod, String table) {
            this.table = table;
            this.sanMethod = sanMethod;
            this.orderType = ScanOrderType.ORDER_NONE;
        }

        public static ScanBuilder rangeOf(String table, List<HgOwnerKey> startList, List<HgOwnerKey> endList) {
            HgAssert.isArgumentValid(table, "table");
            HgAssert.isArgumentValid(startList, "startList");
            HgAssert.isArgumentValid(endList, "endList");
            HgAssert.isTrue(startList.size() == endList.size(), "The size of startList not equals endList's.");
            ScanBuilder res = new ScanBuilder(ScanMethod.RANGE, table);
            res.startList = startList;
            res.endList = endList;
            res.scanType = 60;
            return res;
        }

        public static ScanBuilder prefixOf(String table, List<HgOwnerKey> prefixList) {
            HgAssert.isArgumentValid(table, "table");
            HgAssert.isArgumentValid(prefixList, "prefixList");
            ScanBuilder res = new ScanBuilder(ScanMethod.PREFIX, table);
            res.prefixList = prefixList;
            return res;
        }

        public static ScanBuilder prefixIteratorOf(String table, Iterator<HgOwnerKey> prefixItr) {
            HgAssert.isArgumentValid(table, "table");
            ScanBuilder res = new ScanBuilder(ScanMethod.PREFIX, table);
            res.prefixItr = prefixItr;
            return res;
        }

        public static ScanBuilder tableOf(String table) {
            HgAssert.isArgumentValid(table, "table");
            return new ScanBuilder(ScanMethod.ALL, table);
        }

        public ScanBuilder setLimit(long limit) {
            this.limit = limit;
            return this;
        }

        public ScanBuilder setPerKeyLimit(long limit) {
            this.perKeyLimit = limit;
            return this;
        }

        public ScanBuilder setPerKeyMax(long max) {
            this.perKeyMax = max;
            return this;
        }

        public ScanBuilder setScanType(int scanType) {
            this.scanType = scanType;
            return this;
        }

        public ScanBuilder setOrderType(ScanOrderType orderType) {
            this.orderType = orderType;
            return this;
        }

        public ScanBuilder setQuery(byte[] query) {
            this.query = query;
            return this;
        }

        public ScanBuilder setSkipDegree(long skipDegree) {
            this.skipDegree = skipDegree;
            return this;
        }

        public ScanBuilder setOnlyKey(boolean onlyKey) {
            this.onlyKey = onlyKey;
            return this;
        }

        public HgScanQuery build() {
            return new BatchScanQuery();
        }

        private class BatchScanQuery
        implements HgScanQuery {
            private BatchScanQuery() {
            }

            @Override
            public String getTable() {
                return ScanBuilder.this.table;
            }

            @Override
            public ScanMethod getScanMethod() {
                return ScanBuilder.this.sanMethod;
            }

            @Override
            public List<HgOwnerKey> getPrefixList() {
                if (ScanBuilder.this.prefixList == null) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.unmodifiableList(ScanBuilder.this.prefixList);
            }

            @Override
            public Iterator<HgOwnerKey> getPrefixItr() {
                return ScanBuilder.this.prefixItr;
            }

            @Override
            public List<HgOwnerKey> getStartList() {
                if (ScanBuilder.this.startList == null) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.unmodifiableList(ScanBuilder.this.startList);
            }

            @Override
            public List<HgOwnerKey> getEndList() {
                if (ScanBuilder.this.endList == null) {
                    return Collections.EMPTY_LIST;
                }
                return Collections.unmodifiableList(ScanBuilder.this.endList);
            }

            @Override
            public long getLimit() {
                return ScanBuilder.this.limit;
            }

            @Override
            public long getPerKeyLimit() {
                return ScanBuilder.this.perKeyLimit;
            }

            @Override
            public long getPerKeyMax() {
                return ScanBuilder.this.perKeyMax;
            }

            @Override
            public long getSkipDegree() {
                return ScanBuilder.this.skipDegree;
            }

            @Override
            public int getScanType() {
                return ScanBuilder.this.scanType;
            }

            @Override
            public ScanOrderType getOrderType() {
                return ScanBuilder.this.orderType;
            }

            @Override
            public boolean isOnlyKey() {
                return ScanBuilder.this.onlyKey;
            }

            @Override
            public byte[] getQuery() {
                return ScanBuilder.this.query;
            }

            @Override
            public ScanBuilder builder() {
                return ScanBuilder.this;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("HgScanQuery{");
                sb.append("table='").append(this.getTable()).append('\'');
                sb.append(", scanMethod=").append((Object)this.getScanMethod());
                sb.append(", prefixList=").append(this.getPrefixList());
                sb.append(", startList=").append(this.getStartList());
                sb.append(", endList=").append(this.getEndList());
                sb.append(", limit=").append(this.getLimit());
                sb.append(", perKeyLimit=").append(this.getPerKeyLimit());
                sb.append(", perKeyMax=").append(this.getPerKeyMax());
                sb.append(", skipDegree=").append(this.getSkipDegree());
                sb.append(", scanType=").append(this.getScanType());
                sb.append(", orderType=").append(this.getOrderType());
                sb.append(", onlyKey=").append(this.isOnlyKey());
                sb.append(", query=");
                if (ScanBuilder.this.query == null) {
                    sb.append("null");
                } else {
                    sb.append('[');
                    for (int i = 0; i < ScanBuilder.this.query.length; ++i) {
                        sb.append(i == 0 ? "" : ", ").append(ScanBuilder.this.query[i]);
                    }
                    sb.append(']');
                }
                sb.append('}');
                return sb.toString();
            }
        }
    }

    public static enum SortType {
        UNSORTED,
        SORT_BY_EDGE,
        SORT_BY_VERTEX;

    }

    public static enum ScanMethod {
        ALL,
        PREFIX,
        RANGE;

    }
}

