/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool;

import com.beust.jcommander.Parameter;
import java.util.List;
import org.gridkit.jvmtool.cli.CommandLauncher;
import org.gridkit.lab.jvm.attach.AttachManager;
import org.gridkit.lab.jvm.attach.JavaProcessId;
import org.gridkit.util.formating.GridSink;

public class JvmProcessPrinter {
    private final CommandLauncher host;
    @Parameter(names={"-pd", "--process-details"}, variableArity=true, description="Print custom information related to a process. Following tags can be used: PID, MAIN, FDQN_MAIN, ARGS, D<sys-prop>, d<sys-prop>, X<jvm-flag>, x<jvm-flag>")
    private List<String> displayFields;

    public JvmProcessPrinter(CommandLauncher host) {
        this.host = host;
    }

    public boolean isDefined() {
        return this.displayFields != null && !this.displayFields.isEmpty();
    }

    public void describeHeader(GridSink sink) {
        for (String tag : this.displayFields) {
            if (tag.startsWith("d") || tag.startsWith("x") || tag.startsWith("D") || tag.startsWith("X")) {
                sink.append(tag.substring(1));
                continue;
            }
            sink.append(tag);
        }
        sink.endOfRow();
    }

    public void describe(JavaProcessId jpid, GridSink sink) {
        for (String tag : this.displayFields) {
            if ("PID".equals(tag)) {
                sink.append(this.getPid(jpid));
                continue;
            }
            if ("MAIN".equals(tag)) {
                sink.append(this.getShortMain(jpid));
                continue;
            }
            if ("FDQN_MAIN".equals(tag)) {
                sink.append(this.getMain(jpid));
                continue;
            }
            if ("ARGS".equals(tag)) {
                sink.append(this.getArgs(jpid));
                continue;
            }
            if (tag.startsWith("d")) {
                sink.append(this.getProp(jpid, tag.substring(1)));
                continue;
            }
            if (tag.startsWith("D")) {
                sink.append(tag.substring(1) + "=" + this.getProp(jpid, tag.substring(1)));
                continue;
            }
            if (tag.startsWith("x")) {
                sink.append(this.getFlagValue(jpid, tag.substring(1)));
                continue;
            }
            if (tag.startsWith("X")) {
                sink.append(this.getFlag(jpid, tag.substring(1)));
                continue;
            }
            sink.append("Unknown(" + tag + ")");
        }
        sink.endOfRow();
    }

    private String getFlagValue(JavaProcessId jpid, String flagName) {
        String val = this.getFlag(jpid, flagName);
        if (val.startsWith("-XX:+")) {
            return "true";
        }
        if (val.startsWith("-XX:-")) {
            return "false";
        }
        int ch = val.indexOf("=");
        return ch <= 0 ? val : val.substring(ch + 1);
    }

    private String getProp(JavaProcessId jpid, String propName) {
        return (String)AttachManager.getDetails((JavaProcessId)jpid).getSystemProperties().get(propName);
    }

    private String getFlag(JavaProcessId jpid, String flagName) {
        return AttachManager.getDetails((JavaProcessId)jpid).getVmFlag(flagName);
    }

    private String getArgs(JavaProcessId jpid) {
        String desc = jpid.getDescription();
        int n = desc.indexOf(32);
        if (n >= 0) {
            desc = desc.substring(n + 1);
        }
        return desc;
    }

    private String getMain(JavaProcessId jpid) {
        String desc = jpid.getDescription();
        int n = desc.indexOf(32);
        if (n >= 0) {
            desc = desc.substring(0, n);
        }
        return desc;
    }

    private String getShortMain(JavaProcessId jpid) {
        String main = this.getMain(jpid);
        if (main.endsWith(".jar")) {
            return main;
        }
        int n = main.lastIndexOf(46);
        if (n >= 0) {
            main = main.substring(n + 1);
        }
        return main;
    }

    private String getPid(JavaProcessId jpid) {
        return String.valueOf(jpid.getPID());
    }
}

