/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.hstore;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.hstore.HstoreOptions;
import org.apache.hugegraph.backend.store.hstore.HstoreSessions;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.meta.PdMetaDriver;
import org.apache.hugegraph.pd.client.PDClient;
import org.apache.hugegraph.pd.client.PDConfig;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.HgStoreClient;
import org.apache.hugegraph.store.HgStoreSession;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.util.HgStoreClientConst;
import org.apache.hugegraph.store.grpc.common.ScanOrderType;
import org.apache.hugegraph.testutil.Assert;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.StringEncoding;

public class HstoreSessionsImpl
extends HstoreSessions {
    private static final Set<String> infoInitializedGraph = Collections.synchronizedSet(new HashSet());
    private static int tableCode = 0;
    private static volatile Boolean initializedNode = Boolean.FALSE;
    private static volatile PDClient defaultPdClient;
    private static volatile HgStoreClient hgStoreClient;
    private final HugeConfig config;
    private final HstoreSession session;
    private final Map<String, Integer> tables;
    private final AtomicInteger refCount;
    private final String graphName;

    public HstoreSessionsImpl(HugeConfig config, String database, String store) {
        super(config, database, store);
        this.config = config;
        this.graphName = database + "/" + store;
        this.initStoreNode(config);
        this.session = new HstoreSession(this.config, this.graphName);
        this.tables = new ConcurrentHashMap<String, Integer>();
        this.refCount = new AtomicInteger(1);
    }

    public static HgStoreClient getHgStoreClient() {
        return hgStoreClient;
    }

    public static PDClient getDefaultPdClient() {
        return defaultPdClient;
    }

    public static byte[] encode(String string) {
        return StringEncoding.encode((String)string);
    }

    public static String decode(byte[] bytes) {
        return StringEncoding.decode((byte[])bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStoreNode(HugeConfig config) {
        if (!initializedNode.booleanValue()) {
            HstoreSessionsImpl hstoreSessionsImpl = this;
            synchronized (hstoreSessionsImpl) {
                if (!initializedNode.booleanValue()) {
                    PDConfig pdConfig = PDConfig.of((String)((String)config.get((TypedOption)CoreOptions.PD_PEERS))).setAuthority(PdMetaDriver.PDAuthConfig.service(), PdMetaDriver.PDAuthConfig.token()).setEnableCache(true);
                    defaultPdClient = PDClient.create((PDConfig)pdConfig);
                    hgStoreClient = HgStoreClient.create((PDClient)defaultPdClient);
                    initializedNode = Boolean.TRUE;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        if (!infoInitializedGraph.contains(this.graphName)) {
            Set<String> set = infoInitializedGraph;
            synchronized (set) {
                if (!infoInitializedGraph.contains(this.graphName)) {
                    Integer partitionCount = (Integer)this.config.get(HstoreOptions.PARTITION_COUNT);
                    Assert.assertTrue((String)"The value of hstore.partition_count cannot be less than 0.", (partitionCount > -1 ? 1 : 0) != 0);
                    defaultPdClient.setGraph(Metapb.Graph.newBuilder().setGraphName(this.graphName).setPartitionCount(partitionCount.intValue()).build());
                    infoInitializedGraph.add(this.graphName);
                }
            }
        }
        this.session.open();
    }

    protected boolean opened() {
        return this.session != null;
    }

    @Override
    public Set<String> openedTables() {
        return this.tables.keySet();
    }

    @Override
    public synchronized void createTable(String ... tables) {
        for (String table : tables) {
            this.session.createTable(table);
            this.tables.put(table, tableCode++);
        }
    }

    @Override
    public synchronized void dropTable(String ... tables) {
        for (String table : tables) {
            this.session.dropTable(table);
            this.tables.remove(table);
        }
    }

    @Override
    public boolean existsTable(String table) {
        return this.session.existsTable(table);
    }

    @Override
    public void truncateTable(String table) {
        this.session.truncateTable(table);
    }

    @Override
    public void clear() {
        this.session.deleteGraph();
        try {
            hgStoreClient.getPdClient().delGraph(this.graphName);
        }
        catch (PDException pDException) {
            // empty catch block
        }
    }

    @Override
    public final HstoreSessions.Session session() {
        return (HstoreSessions.Session)super.getOrNewSession();
    }

    protected final HstoreSessions.Session newSession() {
        return new HstoreSession(this.config(), this.graphName);
    }

    protected synchronized void doClose() {
        this.checkValid();
        if (this.refCount != null) {
            if (this.refCount.decrementAndGet() > 0) {
                return;
            }
            if (this.refCount.get() != 0) {
                return;
            }
        }
        assert (this.refCount.get() == 0);
        this.tables.clear();
        this.session.close();
    }

    private void checkValid() {
    }

    private final class HstoreSession
    extends HstoreSessions.Session {
        private static final boolean TRANSACTIONAL = true;
        private final HgStoreSession graph;
        int changedSize = 0;

        public HstoreSession(HugeConfig conf, String graphName) {
            this.setGraphName(graphName);
            this.setConf(conf);
            this.graph = hgStoreClient.openSession(graphName);
        }

        public void open() {
            this.opened = true;
        }

        public void close() {
            this.opened = false;
        }

        public void reset() {
            if (this.changedSize != 0) {
                this.rollback();
                this.changedSize = 0;
            }
        }

        public boolean hasChanges() {
            return this.changedSize > 0;
        }

        public Integer commit() {
            if (!this.hasChanges()) {
                return 0;
            }
            int commitSize = this.changedSize;
            this.graph.commit();
            this.changedSize = 0;
            return commitSize;
        }

        public void rollback() {
            this.graph.rollback();
            this.changedSize = 0;
        }

        @Override
        public void createTable(String tableName) {
            this.graph.createTable(tableName);
        }

        @Override
        public void dropTable(String tableName) {
            this.graph.dropTable(tableName);
        }

        @Override
        public boolean existsTable(String tableName) {
            return this.graph.existsTable(tableName);
        }

        @Override
        public void truncateTable(String tableName) {
            this.graph.deleteTable(tableName);
        }

        @Override
        public void deleteGraph() {
            this.graph.deleteGraph(this.getGraphName());
        }

        @Override
        public Pair<byte[], byte[]> keyRange(String table) {
            return null;
        }

        private void prepare() {
            if (!this.hasChanges()) {
                this.graph.beginTx();
            }
            ++this.changedSize;
        }

        @Override
        public void put(String table, byte[] ownerKey, byte[] key, byte[] value) {
            this.prepare();
            this.graph.put(table, HgOwnerKey.of((byte[])ownerKey, (byte[])key), value);
        }

        @Override
        public synchronized void increase(String table, byte[] ownerKey, byte[] key, byte[] value) {
            this.prepare();
            this.graph.merge(table, HgOwnerKey.of((byte[])ownerKey, (byte[])key), value);
        }

        @Override
        public void delete(String table, byte[] ownerKey, byte[] key) {
            this.prepare();
            this.graph.delete(table, HgOwnerKey.of((byte[])ownerKey, (byte[])key));
        }

        @Override
        public void deletePrefix(String table, byte[] ownerKey, byte[] key) {
            this.prepare();
            this.graph.deletePrefix(table, HgOwnerKey.of((byte[])ownerKey, (byte[])key));
        }

        @Override
        public void deleteRange(String table, byte[] ownerKeyFrom, byte[] ownerKeyTo, byte[] keyFrom, byte[] keyTo) {
            this.prepare();
            this.graph.deleteRange(table, HgOwnerKey.of((byte[])ownerKeyFrom, (byte[])keyFrom), HgOwnerKey.of((byte[])ownerKeyTo, (byte[])keyTo));
        }

        @Override
        public byte[] get(String table, byte[] key) {
            return this.graph.get(table, HgOwnerKey.of((byte[])HgStoreClientConst.ALL_PARTITION_OWNER, (byte[])key));
        }

        @Override
        public byte[] get(String table, byte[] ownerKey, byte[] key) {
            byte[] values = this.graph.get(table, HgOwnerKey.of((byte[])ownerKey, (byte[])key));
            return values != null ? values : new byte[]{};
        }

        @Override
        public void beginTx() {
            this.graph.beginTx();
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table) {
            assert (!this.hasChanges());
            return new ColumnIterator<HgKvIterator>(table, this.graph.scanIterator(table));
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] conditionQueryToByte) {
            assert (!this.hasChanges());
            HgKvIterator results = this.graph.scanIterator(table, conditionQueryToByte);
            return new ColumnIterator<HgKvIterator>(table, results);
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] ownerKey, byte[] prefix) {
            assert (!this.hasChanges());
            HgKvIterator result = this.graph.scanIterator(table, HgOwnerKey.of((byte[])ownerKey, (byte[])prefix));
            return new ColumnIterator<HgKvIterator>(table, result);
        }

        @Override
        public List<BackendEntry.BackendColumnIterator> scan(String table, List<HgOwnerKey> keys, int scanType, long limit, byte[] query) {
            HgScanQuery scanQuery = HgScanQuery.prefixOf((String)table, keys).builder().setScanType(scanType).setQuery(query).setPerKeyLimit(limit).build();
            List scanIterators = this.graph.scanBatch(scanQuery);
            LinkedList<BackendEntry.BackendColumnIterator> columnIterators = new LinkedList<BackendEntry.BackendColumnIterator>();
            scanIterators.forEach(item -> columnIterators.add(new ColumnIterator<HgKvIterator>(table, (HgKvIterator)item)));
            return columnIterators;
        }

        @Override
        public BackendEntry.BackendIterator<BackendEntry.BackendColumnIterator> scan(final String table, Iterator<HgOwnerKey> keys, int scanType, Query queryParam, byte[] query) {
            ScanOrderType orderType;
            switch (queryParam.orderType()) {
                case ORDER_NONE: {
                    orderType = ScanOrderType.ORDER_NONE;
                    break;
                }
                case ORDER_WITHIN_VERTEX: {
                    orderType = ScanOrderType.ORDER_WITHIN_VERTEX;
                    break;
                }
                case ORDER_STRICT: {
                    orderType = ScanOrderType.ORDER_STRICT;
                    break;
                }
                default: {
                    throw new RuntimeException("not implement");
                }
            }
            HgScanQuery scanQuery = HgScanQuery.prefixIteratorOf((String)table, keys).builder().setScanType(scanType).setQuery(query).setPerKeyMax(queryParam.limit()).setOrderType(orderType).setOnlyKey(!queryParam.withProperties()).setSkipDegree(queryParam.skipDegree()).build();
            final KvCloseableIterator scanIterators = this.graph.scanBatch2(scanQuery);
            return new BackendEntry.BackendIterator<BackendEntry.BackendColumnIterator>(){

                public void close() {
                    scanIterators.close();
                }

                public byte[] position() {
                    throw new NotImplementedException();
                }

                public boolean hasNext() {
                    return scanIterators.hasNext();
                }

                public BackendEntry.BackendColumnIterator next() {
                    return new ColumnIterator<HgKvIterator>(table, (HgKvIterator)scanIterators.next());
                }
            };
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] ownerKeyFrom, byte[] ownerKeyTo, byte[] keyFrom, byte[] keyTo, int scanType) {
            assert (!this.hasChanges());
            HgKvIterator result = this.graph.scanIterator(table, HgOwnerKey.of((byte[])ownerKeyFrom, (byte[])keyFrom), HgOwnerKey.of((byte[])ownerKeyTo, (byte[])keyTo), 0L, scanType, null);
            return new ColumnIterator<HgKvIterator>(table, result, keyFrom, keyTo, scanType);
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] ownerKeyFrom, byte[] ownerKeyTo, byte[] keyFrom, byte[] keyTo, int scanType, byte[] query) {
            assert (!this.hasChanges());
            HgKvIterator result = this.graph.scanIterator(table, HgOwnerKey.of((byte[])ownerKeyFrom, (byte[])keyFrom), HgOwnerKey.of((byte[])ownerKeyTo, (byte[])keyTo), 0L, scanType, query);
            return new ColumnIterator<HgKvIterator>(table, result, keyFrom, keyTo, scanType);
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] ownerKeyFrom, byte[] ownerKeyTo, byte[] keyFrom, byte[] keyTo, int scanType, byte[] query, byte[] position) {
            assert (!this.hasChanges());
            HgKvIterator result = this.graph.scanIterator(table, HgOwnerKey.of((byte[])ownerKeyFrom, (byte[])keyFrom), HgOwnerKey.of((byte[])ownerKeyTo, (byte[])keyTo), 0L, scanType, query);
            result.seek(position);
            return new ColumnIterator<HgKvIterator>(table, result, keyFrom, keyTo, scanType);
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, int codeFrom, int codeTo, int scanType, byte[] query) {
            assert (!this.hasChanges());
            HgKvIterator iterator = this.graph.scanIterator(table, codeFrom, codeTo, 256, new byte[0]);
            return new ColumnIterator<HgKvIterator>(table, iterator, new byte[0], new byte[0], scanType);
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, int codeFrom, int codeTo, int scanType, byte[] query, byte[] position) {
            assert (!this.hasChanges());
            HgKvIterator iterator = this.graph.scanIterator(table, codeFrom, codeTo, 256, new byte[0]);
            iterator.seek(position);
            return new ColumnIterator<HgKvIterator>(table, iterator, new byte[0], new byte[0], scanType);
        }

        @Override
        public BackendEntry.BackendColumnIterator getWithBatch(String table, List<HgOwnerKey> keys) {
            assert (!this.hasChanges());
            HgKvIterator kvIterator = this.graph.batchPrefix(table, keys);
            return new ColumnIterator<HgKvIterator>(table, kvIterator);
        }

        @Override
        public void merge(String table, byte[] ownerKey, byte[] key, byte[] value) {
            this.prepare();
            this.graph.merge(table, HgOwnerKey.of((byte[])ownerKey, (byte[])key), value);
        }

        @Override
        public void setMode(GraphMode mode) {
        }

        @Override
        public void truncate() throws Exception {
            this.graph.truncate();
            HstoreSessionsImpl.getDefaultPdClient().resetIdByKey(this.getGraphName());
        }

        @Override
        public int getActiveStoreSize() {
            try {
                return defaultPdClient.getActiveStores().size();
            }
            catch (PDException pDException) {
                return 0;
            }
        }
    }

    private static class ColumnIterator<T extends HgKvIterator>
    implements BackendEntry.BackendColumnIterator,
    HstoreSessions.Countable {
        private final T iter;
        private final byte[] keyBegin;
        private final byte[] keyEnd;
        private final int scanType;
        private final String table;
        private final byte[] value;
        private boolean gotNext;
        private byte[] position;

        public ColumnIterator(String table, T results) {
            this(table, results, null, null, 0);
        }

        public ColumnIterator(String table, T results, byte[] keyBegin, byte[] keyEnd, int scanType) {
            E.checkNotNull(results, (String)"results");
            this.table = table;
            this.iter = results;
            this.keyBegin = keyBegin;
            this.keyEnd = keyEnd;
            this.scanType = scanType;
            this.value = null;
            if (this.iter.hasNext()) {
                this.iter.next();
                this.gotNext = true;
                this.position = this.iter.position();
            } else {
                this.gotNext = false;
                this.position = null;
            }
            if (!ArrayUtils.isEmpty((byte[])this.keyBegin) || !ArrayUtils.isEmpty((byte[])this.keyEnd)) {
                this.checkArguments();
            }
        }

        public T iter() {
            return this.iter;
        }

        private void checkArguments() {
            E.checkArgument((!this.match(1) || !this.match(2) ? 1 : 0) != 0, (String)"Can't set SCAN_PREFIX_WITH_BEGIN and SCAN_PREFIX_WITH_END at the same time", (Object[])new Object[0]);
            E.checkArgument((!this.match(1) || !this.match(4) ? 1 : 0) != 0, (String)"Can't set SCAN_PREFIX_WITH_BEGIN and SCAN_GT_BEGIN/SCAN_GTE_BEGIN at the same time", (Object[])new Object[0]);
            E.checkArgument((!this.match(2) || !this.match(16) ? 1 : 0) != 0, (String)"Can't set SCAN_PREFIX_WITH_END and SCAN_LT_END/SCAN_LTE_END at the same time", (Object[])new Object[0]);
            if (this.match(1) && !this.matchHash()) {
                E.checkArgument((this.keyBegin != null ? 1 : 0) != 0, (String)"Parameter `keyBegin` can't be null if set SCAN_PREFIX_WITH_BEGIN", (Object[])new Object[0]);
                E.checkArgument((this.keyEnd == null ? 1 : 0) != 0, (String)"Parameter `keyEnd` must be null if set SCAN_PREFIX_WITH_BEGIN", (Object[])new Object[0]);
            }
            if (this.match(2) && !this.matchHash()) {
                E.checkArgument((this.keyEnd != null ? 1 : 0) != 0, (String)"Parameter `keyEnd` can't be null if set SCAN_PREFIX_WITH_END", (Object[])new Object[0]);
            }
            if (this.match(4) && !this.matchHash()) {
                E.checkArgument((this.keyBegin != null ? 1 : 0) != 0, (String)"Parameter `keyBegin` can't be null if set SCAN_GT_BEGIN or SCAN_GTE_BEGIN", (Object[])new Object[0]);
            }
            if (this.match(16) && !this.matchHash()) {
                E.checkArgument((this.keyEnd != null ? 1 : 0) != 0, (String)"Parameter `keyEnd` can't be null if set SCAN_LT_END or SCAN_LTE_END", (Object[])new Object[0]);
            }
        }

        private boolean matchHash() {
            return this.scanType == 256;
        }

        private boolean match(int expected) {
            return HstoreSessions.Session.matchScanType(expected, this.scanType);
        }

        public boolean hasNext() {
            this.position = (byte[])(this.gotNext ? this.iter.position() : null);
            return this.gotNext;
        }

        private boolean filter(byte[] key) {
            if (this.match(1)) {
                return Bytes.prefixWith((byte[])key, (byte[])this.keyBegin);
            }
            if (this.match(2)) {
                assert (this.keyEnd != null);
                return Bytes.prefixWith((byte[])key, (byte[])this.keyEnd);
            }
            if (this.match(16)) {
                if ((this.scanType | 0x100) != 0) {
                    return true;
                }
                assert (this.keyEnd != null);
                if (this.match(48)) {
                    return Bytes.compare((byte[])(key = Arrays.copyOfRange(key, 0, this.keyEnd.length)), (byte[])this.keyEnd) <= 0;
                }
                return Bytes.compare((byte[])key, (byte[])this.keyEnd) < 0;
            }
            assert (this.match(128) || this.match(4) || this.match(12)) : "Unknown scan type";
            return true;
        }

        public BackendEntry.BackendColumn next() {
            BackendEntryIterator.checkInterrupted();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BackendEntry.BackendColumn col = BackendEntry.BackendColumn.of((byte[])this.iter.key(), (byte[])this.iter.value());
            if (this.iter.hasNext()) {
                this.gotNext = true;
                this.iter.next();
            } else {
                this.gotNext = false;
            }
            return col;
        }

        @Override
        public long count() {
            long count = 0L;
            while (this.hasNext()) {
                this.next();
                ++count;
                BackendEntryIterator.checkInterrupted();
            }
            return count;
        }

        public byte[] position() {
            return this.position;
        }

        public void close() {
            if (this.iter != null) {
                this.iter.close();
            }
        }
    }
}

