/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.exception;

import java.util.List;
import org.apache.fury.exception.FuryException;

public class DeserializationException
extends FuryException {
    private List<Object> readObjects;

    public DeserializationException(String message) {
        super(message);
    }

    public DeserializationException(Throwable cause) {
        super(cause);
    }

    public DeserializationException(String message, Throwable cause) {
        super(message, cause);
    }

    public DeserializationException(List<Object> readObjects, Throwable cause) {
        super(cause);
        this.readObjects = readObjects;
    }

    @Override
    public String getMessage() {
        if (this.readObjects == null) {
            return super.getMessage();
        }
        try {
            return "Deserialize failed, read objects are: " + this.readObjects;
        }
        catch (Throwable e) {
            StringBuilder builder = new StringBuilder("Deserialize failed, type of read objects are: [");
            for (Object readObject : this.readObjects) {
                builder.append(readObject == null ? null : readObject.getClass()).append(", ");
            }
            builder.delete(builder.length() - 2, builder.length());
            builder.append("]");
            return builder.toString();
        }
    }
}

