/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.server;

import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.ServerOptions;
import org.apache.hugegraph.event.EventHub;
import org.apache.hugegraph.server.ApplicationConfig;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.version.ApiVersion;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;

public class RestServer {
    private static final Logger LOG = Log.logger(RestServer.class);
    private final HugeConfig conf;
    private final EventHub eventHub;
    private HttpServer httpServer = null;

    public RestServer(HugeConfig conf, EventHub hub) {
        this.conf = conf;
        this.eventHub = hub;
    }

    public void start() throws IOException {
        String url = (String)this.conf.get(ServerOptions.REST_SERVER_URL);
        URI uri = UriBuilder.fromUri((String)url).build(new Object[0]);
        ApplicationConfig rc = new ApplicationConfig(this.conf, this.eventHub);
        this.httpServer = this.configHttpServer(uri, rc);
        try {
            this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new StaticHttpHandler(new String[]{"swagger-ui"}), new String[]{"/swagger-ui"});
            this.httpServer.start();
        }
        catch (Throwable e) {
            this.httpServer.shutdownNow();
            throw e;
        }
        this.calcMaxWriteThreads();
    }

    private HttpServer configHttpServer(URI uri, ResourceConfig rc) {
        HttpServer server;
        String protocol = uri.getScheme();
        if (protocol != null && protocol.equals("https")) {
            SSLContextConfigurator sslContext = new SSLContextConfigurator();
            String keystoreFile = (String)this.conf.get(ServerOptions.SSL_KEYSTORE_FILE);
            String keystorePass = (String)this.conf.get(ServerOptions.SSL_KEYSTORE_PASSWORD);
            sslContext.setKeyStoreFile(keystoreFile);
            sslContext.setKeyStorePass(keystorePass);
            SSLEngineConfigurator sslConfig = new SSLEngineConfigurator(sslContext);
            sslConfig.setClientMode(false);
            sslConfig.setWantClientAuth(true);
            server = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (ResourceConfig)rc, (boolean)true, (SSLEngineConfigurator)sslConfig);
        } else {
            server = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (ResourceConfig)rc, (boolean)false);
        }
        Collection listeners = server.getListeners();
        E.checkState((!listeners.isEmpty() ? 1 : 0) != 0, (String)"Http Server should have some listeners, but now is none", (Object[])new Object[0]);
        NetworkListener listener = (NetworkListener)listeners.iterator().next();
        int maxWorkerThreads = (Integer)this.conf.get(ServerOptions.MAX_WORKER_THREADS);
        listener.getTransport().getWorkerThreadPoolConfig().setCorePoolSize(maxWorkerThreads).setMaxPoolSize(maxWorkerThreads);
        int idleTimeout = (Integer)this.conf.get(ServerOptions.CONN_IDLE_TIMEOUT);
        int maxRequests = (Integer)this.conf.get(ServerOptions.CONN_MAX_REQUESTS);
        listener.getKeepAlive().setIdleTimeoutInSeconds(idleTimeout);
        listener.getKeepAlive().setMaxRequestsCount(maxRequests);
        int transactionTimeout = (Integer)this.conf.get(ServerOptions.REQUEST_TIMEOUT);
        listener.setTransactionTimeout(transactionTimeout);
        return server;
    }

    public Future<HttpServer> shutdown() {
        E.checkNotNull((Object)this.httpServer, (String)"http server");
        final CompletableFuture<HttpServer> future = new CompletableFuture<HttpServer>();
        future.whenComplete((server, exception) -> this.httpServer.shutdownNow());
        GrizzlyFuture grizzlyFuture = this.httpServer.shutdown();
        grizzlyFuture.addCompletionHandler((CompletionHandler)new CompletionHandler<HttpServer>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.completeExceptionally(throwable);
            }

            public void completed(HttpServer result) {
                future.complete(result);
            }

            public void updated(HttpServer result) {
            }
        });
        return future;
    }

    public void shutdownNow() {
        E.checkNotNull((Object)this.httpServer, (String)"http server");
        this.httpServer.shutdownNow();
    }

    public static RestServer start(String conf, EventHub hub) throws Exception {
        LOG.info("RestServer starting...");
        ApiVersion.check();
        HugeConfig config = new HugeConfig(conf);
        RestServer server = new RestServer(config, hub);
        server.start();
        LOG.info("RestServer started");
        return server;
    }

    private void calcMaxWriteThreads() {
        int maxWriteThreads = (Integer)this.conf.get(ServerOptions.MAX_WRITE_THREADS);
        if (maxWriteThreads > 0) {
            return;
        }
        assert (maxWriteThreads == 0);
        int maxWriteRatio = (Integer)this.conf.get(ServerOptions.MAX_WRITE_RATIO);
        assert (maxWriteRatio >= 0 && maxWriteRatio <= 100);
        int maxWorkerThreads = (Integer)this.conf.get(ServerOptions.MAX_WORKER_THREADS);
        maxWriteThreads = maxWorkerThreads * maxWriteRatio / 100;
        E.checkState((maxWriteThreads >= 0 ? 1 : 0) != 0, (String)"Invalid value of maximum batch writing threads '%s'", (Object[])new Object[]{maxWriteThreads});
        if (maxWriteThreads == 0) {
            E.checkState((maxWriteRatio == 0 ? 1 : 0) != 0, (String)"The value of maximum batch writing threads is 0 due to the max_write_ratio '%s' is too small, set to '%s' at least to ensure one thread.If you want to disable batch write, please let max_write_ratio be 0", (Object[])new Object[]{maxWriteRatio, (int)Math.ceil(100.0 / (double)maxWorkerThreads)});
        }
        LOG.info("The maximum batch writing threads is {} (total threads {})", (Object)maxWriteThreads, (Object)maxWorkerThreads);
        this.conf.setProperty(ServerOptions.MAX_WRITE_THREADS.name(), (Object)String.valueOf(maxWriteThreads));
    }
}

