/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import java.util.Map;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.auth.UserAPI;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeTarget;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.JsonUtil;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/auth/targets")
@Singleton
@Tag(name="TargetAPI")
public class TargetAPI
extends API {
    private static final Logger LOG = Log.logger(TargetAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, JsonTarget jsonTarget) {
        LOG.debug("GraphSpace [{}] create target: {}", (Object)graphSpace, (Object)jsonTarget);
        TargetAPI.checkCreatingBody(jsonTarget);
        HugeTarget target = jsonTarget.build();
        target.id(manager.authManager().createTarget(target));
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)target);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id, JsonTarget jsonTarget) {
        HugeTarget target;
        LOG.debug("GraphSpace [{}] update target: {}", (Object)graphSpace, (Object)jsonTarget);
        TargetAPI.checkUpdatingBody(jsonTarget);
        try {
            target = manager.authManager().getTarget(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid target id: " + id);
        }
        target = jsonTarget.build(target);
        manager.authManager().updateTarget(target);
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)target);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("GraphSpace [{}] list targets", (Object)graphSpace);
        List targets = manager.authManager().listAllTargets(limit);
        return manager.serializer().writeAuthElements("targets", targets);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] get target: {}", (Object)graphSpace, (Object)id);
        HugeTarget target = manager.authManager().getTarget(UserAPI.parseId(id));
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)target);
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] delete target: {}", (Object)graphSpace, (Object)id);
        try {
            manager.authManager().deleteTarget(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid target id: " + id);
        }
    }

    @JsonIgnoreProperties(value={"id", "target_creator", "target_create", "target_update"})
    private static class JsonTarget
    implements Checkable {
        @JsonProperty(value="target_name")
        private String name;
        @JsonProperty(value="target_graph")
        private String graph;
        @JsonProperty(value="target_url")
        private String url;
        @JsonProperty(value="target_resources")
        private List<Map<String, Object>> resources;

        private JsonTarget() {
        }

        public HugeTarget build(HugeTarget target) {
            E.checkArgument((this.name == null || target.name().equals(this.name) ? 1 : 0) != 0, (String)"The name of target can't be updated", (Object[])new Object[0]);
            E.checkArgument((this.graph == null || target.graph().equals(this.graph) ? 1 : 0) != 0, (String)"The graph of target can't be updated", (Object[])new Object[0]);
            if (this.url != null) {
                target.url(this.url);
            }
            if (this.resources != null) {
                target.resources(JsonUtil.toJson(this.resources));
            }
            return target;
        }

        public HugeTarget build() {
            HugeTarget target = new HugeTarget(this.name, this.graph, this.url);
            if (this.resources != null) {
                target.resources(JsonUtil.toJson(this.resources));
            }
            return target;
        }

        public String toString() {
            return "JsonTarget{name='" + this.name + "', graph='" + this.graph + "', url='" + this.url + "', resources=" + String.valueOf(this.resources) + "}";
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of target can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.graph, (String)"The graph of target can't be null", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.url, (String)"The url of target can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
            E.checkArgument((this.url != null || this.resources != null ? 1 : 0) != 0, (String)"Expect one of target url/resources", (Object[])new Object[0]);
        }
    }
}

