/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.auth.UserAPI;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.auth.HugeProject;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="graphspaces/{graphspace}/auth/projects")
@Singleton
@Tag(name="ProjectAPI")
public class ProjectAPI
extends API {
    private static final Logger LOG = Log.logger(ProjectAPI.class);
    private static final String ACTION_ADD_GRAPH = "add_graph";
    private static final String ACTION_REMOVE_GRAPH = "remove_graph";

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, JsonProject jsonProject) {
        LOG.debug("GraphSpace [{}] create project: {}", (Object)graphSpace, (Object)jsonProject);
        ProjectAPI.checkCreatingBody(jsonProject);
        HugeProject project = jsonProject.build();
        Id projectId = manager.authManager().createProject(project);
        project = manager.authManager().getProject(projectId);
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)project);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id, @QueryParam(value="action") String action, JsonProject jsonProject) {
        HugeProject project;
        LOG.debug("GraphSpace [{}] update {} project: {}", new Object[]{graphSpace, action, jsonProject});
        ProjectAPI.checkUpdatingBody(jsonProject);
        Id projectId = UserAPI.parseId(id);
        AuthManager authManager = manager.authManager();
        try {
            project = authManager.getProject(projectId);
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid project id: " + id);
        }
        if (ProjectAPI.isAddGraph(action)) {
            project = jsonProject.buildAddGraph(project);
        } else if (ProjectAPI.isRemoveGraph(action)) {
            project = jsonProject.buildRemoveGraph(project);
        } else {
            E.checkArgument((boolean)StringUtils.isEmpty((String)action), (String)"The action parameter can only be either %s or %s or '', but got '%s'", (Object[])new Object[]{ACTION_ADD_GRAPH, ACTION_REMOVE_GRAPH, action});
            project = jsonProject.buildUpdateDescription(project);
        }
        authManager.updateProject(project);
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)project);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("GraphSpace [{}] list project", (Object)graphSpace);
        List projects = manager.authManager().listAllProject(limit);
        return manager.serializer().writeAuthElements("projects", projects);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        HugeProject project;
        LOG.debug("GraphSpace [{}] get project: {}", (Object)graphSpace, (Object)id);
        try {
            project = manager.authManager().getProject(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid project id: " + id);
        }
        return manager.serializer().writeAuthElement((SchemaDefine.AuthElement)project);
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graphspace") String graphSpace, @PathParam(value="id") String id) {
        LOG.debug("GraphSpace [{}] delete project: {}", (Object)graphSpace, (Object)id);
        try {
            manager.authManager().deleteProject(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid project id: " + id);
        }
    }

    public static boolean isAddGraph(String action) {
        return ACTION_ADD_GRAPH.equals(action);
    }

    public static boolean isRemoveGraph(String action) {
        return ACTION_REMOVE_GRAPH.equals(action);
    }

    @JsonIgnoreProperties(value={"id", "target_creator", "target_create", "target_update", "project_admin_group", "project_op_group", "project_target"})
    private static class JsonProject
    implements Checkable {
        @JsonProperty(value="project_name")
        private String name;
        @JsonProperty(value="project_graphs")
        private Set<String> graphs;
        @JsonProperty(value="project_description")
        private String description;

        private JsonProject() {
        }

        public HugeProject build() {
            HugeProject project = new HugeProject(this.name, this.description);
            return project;
        }

        private HugeProject buildAddGraph(HugeProject project) {
            E.checkArgument((this.name == null || this.name.equals(project.name()) ? 1 : 0) != 0, (String)"The name of project can't be updated", (Object[])new Object[0]);
            E.checkArgument((!CollectionUtils.isEmpty(this.graphs) ? 1 : 0) != 0, (String)"The graphs of project can't be empty when adding graphs", (Object[])new Object[0]);
            E.checkArgument((boolean)StringUtils.isEmpty((String)this.description), (String)"The description of project can't be updated when adding graphs", (Object[])new Object[0]);
            HashSet<String> sourceGraphs = new HashSet<String>(project.graphs());
            E.checkArgument((!sourceGraphs.containsAll(this.graphs) ? 1 : 0) != 0, (String)"There are graphs '%s' of project '%s' that have been added in the graph collection", (Object[])new Object[]{this.graphs, project.id()});
            sourceGraphs.addAll(this.graphs);
            project.graphs(sourceGraphs);
            return project;
        }

        private HugeProject buildRemoveGraph(HugeProject project) {
            E.checkArgument((this.name == null || this.name.equals(project.name()) ? 1 : 0) != 0, (String)"The name of project can't be updated", (Object[])new Object[0]);
            E.checkArgument((!CollectionUtils.isEmpty(this.graphs) ? 1 : 0) != 0, (String)"The graphs of project can't be empty when removing graphs", (Object[])new Object[0]);
            E.checkArgument((boolean)StringUtils.isEmpty((String)this.description), (String)"The description of project can't be updated when removing graphs", (Object[])new Object[0]);
            HashSet sourceGraphs = new HashSet(project.graphs());
            sourceGraphs.removeAll(this.graphs);
            project.graphs(sourceGraphs);
            return project;
        }

        private HugeProject buildUpdateDescription(HugeProject project) {
            E.checkArgument((this.name == null || this.name.equals(project.name()) ? 1 : 0) != 0, (String)"The name of project can't be updated", (Object[])new Object[0]);
            E.checkArgumentNotNull((Object)this.description, (String)"The description of project can't be null", (Object[])new Object[0]);
            E.checkArgument((boolean)CollectionUtils.isEmpty(this.graphs), (String)"The graphs of project can't be updated", (Object[])new Object[0]);
            project.description(this.description);
            return project;
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of project can't be null", (Object[])new Object[0]);
            E.checkArgument((boolean)CollectionUtils.isEmpty(this.graphs), (String)"The graphs '%s' of project can't be added whencreating the project '%s'", (Object[])new Object[]{this.graphs, this.name});
        }

        @Override
        public void checkUpdate() {
            E.checkArgument((!CollectionUtils.isEmpty(this.graphs) || this.description != null ? 1 : 0) != 0, (String)"Must specify 'graphs' or 'description' field that need to be updated", (Object[])new Object[0]);
        }
    }
}

