/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query.util;

import org.apache.hugegraph.backend.BinaryId;
import org.apache.hugegraph.id.EdgeId;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.id.IdUtil;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.store.constant.HugeServerTables;

public class KeyUtil {
    private static final byte[] EMPTY_BYTES = new byte[0];

    public static byte[] getOwnerKey(String table, byte[] key) {
        if (key == null || key.length == 0) {
            return EMPTY_BYTES;
        }
        if (HugeServerTables.isEdgeTable(table)) {
            EdgeId id = (EdgeId)IdUtil.fromBytes((byte[])key);
            return KeyUtil.idToBytes(id.ownerVertexId());
        }
        return key;
    }

    public static byte[] getOwnerId(Id id) {
        if (id instanceof BinaryId) {
            id = ((BinaryId)id).origin();
        }
        if (id != null && id.edge()) {
            id = ((EdgeId)id).ownerVertexId();
        }
        return id != null ? id.asBytes() : EMPTY_BYTES;
    }

    public static byte[] idToBytes(Id id) {
        BytesBuffer buffer = BytesBuffer.allocate((int)(1 + id.length()));
        buffer.writeId(id);
        return buffer.bytes();
    }
}

