/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query.func;

import com.google.common.util.concurrent.AtomicDouble;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.store.query.Tuple2;
import org.apache.hugegraph.store.query.concurrent.AtomicFloat;
import org.apache.hugegraph.store.query.func.AbstractAggregationFunction;
import org.apache.hugegraph.store.query.func.AggregationFunction;
import org.apache.hugegraph.store.query.func.UnaryAggregationFunction;

public class AggregationFunctions {
    public static Supplier getAggregationBufferSupplier(String genericType) {
        switch (genericType) {
            case "java.lang.Long": {
                return () -> 0L;
            }
            case "java.lang.Integer": {
                return () -> 0;
            }
            case "java.lang.Float": 
            case "java.lang.Double": {
                return () -> 0.0;
            }
            case "java.lang.String": {
                return () -> "";
            }
        }
        throw new RuntimeException("unsupported generic type of buffer: " + genericType);
    }

    public static class EmptyFunction
    implements AggregationFunction<Integer, Integer, Integer> {
        @Override
        public Integer createBuffer() {
            return 0;
        }

        @Override
        public Integer getBuffer() {
            return 0;
        }

        @Override
        public void iterate(Integer record) {
        }

        @Override
        public void merge(Integer other) {
        }

        @Override
        public Integer reduce() {
            return null;
        }
    }

    public static class CountFunction
    extends AbstractAggregationFunction<AtomicLong, Long, Long> {
        public CountFunction() {
            this.createBuffer();
        }

        @Override
        public AtomicLong createBuffer() {
            this.buffer = new AtomicLong();
            return (AtomicLong)this.buffer;
        }

        @Override
        public AtomicLong getBuffer() {
            return (AtomicLong)this.buffer;
        }

        @Override
        public void iterate(Long record) {
            ((AtomicLong)this.buffer).getAndIncrement();
        }

        @Override
        public void merge(AtomicLong other) {
            ((AtomicLong)this.buffer).getAndAdd(other.get());
        }

        @Override
        public Long reduce() {
            return ((AtomicLong)this.buffer).get();
        }
    }

    public static class AvgFunction
    extends AbstractAggregationFunction<Tuple2<AtomicLong, AtomicDouble>, Double, Double> {
        private final Class filedClassType;

        public AvgFunction(Supplier supplier) {
            this.createBuffer();
            this.filedClassType = supplier.get().getClass();
        }

        public Class getFiledClassType() {
            return this.filedClassType;
        }

        @Override
        public Tuple2<AtomicLong, AtomicDouble> createBuffer() {
            this.buffer = new Tuple2<AtomicLong, AtomicDouble>(new AtomicLong(0L), new AtomicDouble(0.0));
            return (Tuple2)this.buffer;
        }

        @Override
        public void iterate(Double record) {
            if (record != null) {
                ((AtomicLong)((Tuple2)this.buffer).getV1()).getAndAdd(1L);
                ((AtomicDouble)((Tuple2)this.buffer).getV2()).getAndAdd(record.doubleValue());
            }
        }

        @Override
        public void merge(Tuple2<AtomicLong, AtomicDouble> other) {
            ((AtomicLong)((Tuple2)this.buffer).getV1()).getAndAdd(other.getV1().get());
            ((AtomicDouble)((Tuple2)this.buffer).getV2()).getAndAdd(other.getV2().get());
        }

        @Override
        public Double reduce() {
            if (((AtomicLong)((Tuple2)this.buffer).getV1()).get() == 0L) {
                return Double.NaN;
            }
            return ((AtomicDouble)((Tuple2)this.buffer).getV2()).get() / (double)((AtomicLong)((Tuple2)this.buffer).getV1()).get();
        }
    }

    public static class MinFunction<U, T>
    extends UnaryAggregationFunction<U, T> {
        public MinFunction(Id field, Supplier<U> supplier) {
            super(field, supplier);
        }

        public MinFunction(Supplier<U> supplier) {
            this.supplier = supplier;
            this.buffer = this.initBuffer();
        }

        @Override
        protected U initBuffer() {
            return this.getInitValue(() -> new AtomicLong(Long.MAX_VALUE), () -> new AtomicInteger(Integer.MAX_VALUE), () -> new AtomicDouble(Double.MAX_VALUE), () -> new AtomicFloat(Float.MAX_VALUE));
        }

        @Override
        public void iterate(T record) {
            if (record != null) {
                if (this.buffer == null && record != null) {
                    this.buffer = record;
                    return;
                }
                switch (this.buffer.getClass().getName()) {
                    case "java.util.concurrent.atomic.AtomicLong": {
                        if (((AtomicLong)this.buffer).get() <= (Long)record) break;
                        ((AtomicLong)this.buffer).set((Long)record);
                        break;
                    }
                    case "java.util.concurrent.atomic.AtomicInteger": {
                        if (((AtomicInteger)this.buffer).get() <= (Integer)record) break;
                        ((AtomicInteger)this.buffer).set((Integer)record);
                        break;
                    }
                    case "com.google.common.util.concurrent.AtomicDouble": {
                        if (!(((AtomicDouble)this.buffer).get() > (Double)record)) break;
                        ((AtomicDouble)this.buffer).set(((Double)record).doubleValue());
                        break;
                    }
                    case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                        if (!(((AtomicFloat)this.buffer).get() > ((Float)record).floatValue())) break;
                        ((AtomicFloat)this.buffer).set(((Float)record).floatValue());
                        break;
                    }
                    case "java.lang.String": {
                        this.buffer = this.minString((String)this.buffer, (String)record);
                        break;
                    }
                }
            }
        }

        @Override
        public void merge(U other) {
            if (this.buffer == null && other != null) {
                this.buffer = other;
                return;
            }
            switch (this.buffer.getClass().getName()) {
                case "java.util.concurrent.atomic.AtomicLong": {
                    if (((AtomicLong)this.buffer).get() <= ((AtomicLong)other).get()) break;
                    ((AtomicLong)this.buffer).set(((AtomicLong)other).get());
                    break;
                }
                case "java.util.concurrent.atomic.AtomicInteger": {
                    if (((AtomicInteger)this.buffer).get() <= ((AtomicInteger)other).get()) break;
                    ((AtomicInteger)this.buffer).set(((AtomicInteger)other).get());
                    break;
                }
                case "com.google.common.util.concurrent.AtomicDouble": {
                    if (!(((AtomicDouble)this.buffer).get() > ((AtomicDouble)other).get())) break;
                    ((AtomicDouble)this.buffer).set(((AtomicDouble)other).get());
                    break;
                }
                case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                    if (((AtomicFloat)this.buffer).compareTo((AtomicFloat)other) <= 0) break;
                    ((AtomicFloat)this.buffer).set(((AtomicFloat)other).get());
                    break;
                }
                case "java.lang.String": {
                    this.buffer = this.minString((String)this.buffer, (String)other);
                    break;
                }
            }
        }

        private String minString(String s1, String s2) {
            if (s1 == null || s2 == null) {
                return s1 == null ? s2 : s1;
            }
            return s1.compareTo(s2) <= 0 ? s1 : s2;
        }

        @Override
        public T reduce() {
            switch (this.buffer.getClass().getName()) {
                case "java.util.concurrent.atomic.AtomicLong": {
                    return (T)Long.valueOf(((AtomicLong)this.buffer).get());
                }
                case "java.util.concurrent.atomic.AtomicInteger": {
                    return (T)Integer.valueOf(((AtomicInteger)this.buffer).get());
                }
                case "com.google.common.util.concurrent.AtomicDouble": {
                    return (T)Double.valueOf(((AtomicDouble)this.buffer).get());
                }
                case "java.lang.Float": {
                    return (T)this.buffer;
                }
                case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                    return (T)Float.valueOf(((AtomicFloat)this.buffer).get());
                }
            }
            return null;
        }
    }

    public static class MaxFunction<U, T>
    extends UnaryAggregationFunction<U, T> {
        public MaxFunction(Id field, Supplier<U> supplier) {
            super(field, supplier);
        }

        public MaxFunction(Supplier<U> supplier) {
            this.supplier = supplier;
            this.buffer = this.initBuffer();
        }

        @Override
        protected U initBuffer() {
            return this.getInitValue(() -> new AtomicLong(Long.MIN_VALUE), () -> new AtomicInteger(Integer.MIN_VALUE), () -> new AtomicDouble(Double.MIN_VALUE), () -> new AtomicFloat(Float.MIN_VALUE));
        }

        @Override
        public void iterate(T record) {
            if (record != null) {
                if (this.buffer == null && record != null) {
                    this.buffer = record;
                    return;
                }
                switch (this.buffer.getClass().getName()) {
                    case "java.util.concurrent.atomic.AtomicLong": {
                        if (((AtomicLong)this.buffer).get() >= (Long)record) break;
                        ((AtomicLong)this.buffer).set((Long)record);
                        break;
                    }
                    case "java.util.concurrent.atomic.AtomicInteger": {
                        if (((AtomicInteger)this.buffer).get() >= (Integer)record) break;
                        ((AtomicInteger)this.buffer).set((Integer)record);
                        break;
                    }
                    case "com.google.common.util.concurrent.AtomicDouble": {
                        if (!(((AtomicDouble)this.buffer).get() < (Double)record)) break;
                        ((AtomicDouble)this.buffer).set(((Double)record).doubleValue());
                        break;
                    }
                    case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                        if (!(((AtomicFloat)this.buffer).get() < ((Float)record).floatValue())) break;
                        ((AtomicFloat)this.buffer).set(((Float)record).floatValue());
                        break;
                    }
                    case "java.lang.String": {
                        this.buffer = this.maxString((String)this.buffer, (String)record);
                        break;
                    }
                }
            }
        }

        @Override
        public void merge(U other) {
            if (this.buffer == null && other != null) {
                this.buffer = other;
                return;
            }
            switch (this.buffer.getClass().getName()) {
                case "java.util.concurrent.atomic.AtomicLong": {
                    if (((AtomicLong)this.buffer).get() >= ((AtomicLong)other).get()) break;
                    ((AtomicLong)this.buffer).set(((AtomicLong)other).get());
                    break;
                }
                case "java.util.concurrent.atomic.AtomicInteger": {
                    if (((AtomicInteger)this.buffer).get() >= ((AtomicInteger)other).get()) break;
                    ((AtomicInteger)this.buffer).set(((AtomicInteger)other).get());
                    break;
                }
                case "com.google.common.util.concurrent.AtomicDouble": {
                    if (!(((AtomicDouble)this.buffer).get() < ((AtomicDouble)other).get())) break;
                    ((AtomicDouble)this.buffer).set(((AtomicDouble)other).get());
                    break;
                }
                case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                    if (((AtomicFloat)this.buffer).compareTo((AtomicFloat)other) >= 0) break;
                    ((AtomicFloat)this.buffer).set(((AtomicFloat)other).get());
                    break;
                }
                case "java.lang.String": {
                    this.buffer = this.maxString((String)this.buffer, (String)other);
                    break;
                }
            }
        }

        private String maxString(String s1, String s2) {
            if (s1 == null || s2 == null) {
                return s1 == null ? s2 : s1;
            }
            return s1.compareTo(s2) >= 0 ? s1 : s2;
        }

        @Override
        public T reduce() {
            switch (this.buffer.getClass().getName()) {
                case "java.util.concurrent.atomic.AtomicLong": {
                    return (T)Long.valueOf(((AtomicLong)this.buffer).get());
                }
                case "java.util.concurrent.atomic.AtomicInteger": {
                    return (T)Integer.valueOf(((AtomicInteger)this.buffer).get());
                }
                case "com.google.common.util.concurrent.AtomicDouble": {
                    return (T)Double.valueOf(((AtomicDouble)this.buffer).get());
                }
                case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                    return (T)Float.valueOf(((AtomicFloat)this.buffer).get());
                }
                case "java.lang.String": {
                    return (T)this.buffer;
                }
            }
            return null;
        }
    }

    public static class SumFunction<U, T extends Number>
    extends UnaryAggregationFunction<U, T> {
        public SumFunction(Id field, Supplier<U> supplier) {
            super(field, supplier);
        }

        public SumFunction(Supplier<U> supplier) {
            this.supplier = supplier;
            this.buffer = this.initBuffer();
        }

        @Override
        public void iterate(T record) {
            if (record != null) {
                switch (this.buffer.getClass().getName()) {
                    case "java.util.concurrent.atomic.AtomicLong": {
                        ((AtomicLong)this.buffer).getAndAdd((Long)record);
                        break;
                    }
                    case "java.util.concurrent.atomic.AtomicInteger": {
                        ((AtomicInteger)this.buffer).getAndAdd((Integer)record);
                        break;
                    }
                    case "com.google.common.util.concurrent.AtomicDouble": {
                        ((AtomicDouble)this.buffer).getAndAdd(((Double)record).doubleValue());
                        break;
                    }
                    case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                        ((AtomicFloat)this.buffer).getAndAdd(((Float)record).floatValue());
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported buffer type: " + this.buffer.getClass().getName() + ". Supported types: AtomicLong, AtomicInteger, AtomicDouble, AtomicFloat");
                    }
                }
            }
        }

        @Override
        public void merge(U other) {
            switch (this.buffer.getClass().getName()) {
                case "java.util.concurrent.atomic.AtomicLong": {
                    ((AtomicLong)this.buffer).getAndAdd(((AtomicLong)other).get());
                    break;
                }
                case "java.util.concurrent.atomic.AtomicInteger": {
                    ((AtomicInteger)this.buffer).getAndAdd(((AtomicInteger)other).get());
                    break;
                }
                case "com.google.common.util.concurrent.AtomicDouble": {
                    ((AtomicDouble)this.buffer).getAndAdd(((AtomicDouble)other).get());
                    break;
                }
                case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                    ((AtomicFloat)this.buffer).getAndAdd(((AtomicFloat)other).get());
                    break;
                }
            }
        }

        @Override
        public T reduce() {
            switch (this.buffer.getClass().getName()) {
                case "java.util.concurrent.atomic.AtomicLong": {
                    return (T)Long.valueOf(((AtomicLong)this.buffer).get());
                }
                case "java.util.concurrent.atomic.AtomicInteger": {
                    return (T)Integer.valueOf(((AtomicInteger)this.buffer).get());
                }
                case "com.google.common.util.concurrent.AtomicDouble": {
                    return (T)Double.valueOf(((AtomicDouble)this.buffer).get());
                }
                case "org.apache.hugegraph.store.query.concurrent.AtomicFloat": {
                    return (T)Float.valueOf(((AtomicFloat)this.buffer).get());
                }
            }
            return null;
        }

        @Override
        protected U initBuffer() {
            return this.getInitValue(() -> new AtomicLong(0L), () -> new AtomicInteger(0), () -> new AtomicDouble(0.0), () -> new AtomicFloat(0.0f));
        }
    }
}

