/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query.func;

import org.apache.hugegraph.id.Id;

public class AggregationFunctionParam {
    private AggregationFunctionType functionType;
    private FieldType fieldType;
    private Id field;

    private AggregationFunctionParam(AggregationFunctionType functionType, FieldType fieldType, Id filed) {
        this.functionType = functionType;
        this.fieldType = fieldType;
        this.field = filed;
    }

    public static AggregationFunctionParam ofCount() {
        return new AggregationFunctionParam(AggregationFunctionType.COUNT, FieldType.LONG, null);
    }

    public static AggregationFunctionParam ofSum(FieldType fieldType, Id field) {
        return new AggregationFunctionParam(AggregationFunctionType.SUM, fieldType, field);
    }

    public static AggregationFunctionParam ofMin(FieldType fieldType, Id field) {
        return new AggregationFunctionParam(AggregationFunctionType.MIN, fieldType, field);
    }

    public static AggregationFunctionParam ofMax(FieldType fieldType, Id field) {
        return new AggregationFunctionParam(AggregationFunctionType.MAX, fieldType, field);
    }

    public static AggregationFunctionParam ofAvg(FieldType fieldType, Id field) {
        return new AggregationFunctionParam(AggregationFunctionType.AVG, fieldType, field);
    }

    public AggregationFunctionType getFunctionType() {
        return this.functionType;
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    public Id getField() {
        return this.field;
    }

    public void setFunctionType(AggregationFunctionType functionType) {
        this.functionType = functionType;
    }

    public void setFieldType(FieldType fieldType) {
        this.fieldType = fieldType;
    }

    public void setField(Id field) {
        this.field = field;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AggregationFunctionParam)) {
            return false;
        }
        AggregationFunctionParam other = (AggregationFunctionParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AggregationFunctionType this$functionType = this.getFunctionType();
        AggregationFunctionType other$functionType = other.getFunctionType();
        if (this$functionType == null ? other$functionType != null : !((Object)((Object)this$functionType)).equals((Object)other$functionType)) {
            return false;
        }
        FieldType this$fieldType = this.getFieldType();
        FieldType other$fieldType = other.getFieldType();
        if (this$fieldType == null ? other$fieldType != null : !((Object)((Object)this$fieldType)).equals((Object)other$fieldType)) {
            return false;
        }
        Id this$field = this.getField();
        Id other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AggregationFunctionParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AggregationFunctionType $functionType = this.getFunctionType();
        result = result * 59 + ($functionType == null ? 43 : ((Object)((Object)$functionType)).hashCode());
        FieldType $fieldType = this.getFieldType();
        result = result * 59 + ($fieldType == null ? 43 : ((Object)((Object)$fieldType)).hashCode());
        Id $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public String toString() {
        return "AggregationFunctionParam(functionType=" + String.valueOf((Object)this.getFunctionType()) + ", fieldType=" + String.valueOf((Object)this.getFieldType()) + ", field=" + String.valueOf(this.getField()) + ")";
    }

    public static enum FieldType {
        LONG("java.lang.Long"),
        INTEGER("java.lang.Integer"),
        FLOAT("java.lang.Float"),
        DOUBLE("java.lang.Double"),
        STRING("java.lang.String");

        private final String genericType;

        private FieldType(String genericType) {
            this.genericType = genericType;
        }

        public String getGenericType() {
            return this.genericType;
        }
    }

    public static enum AggregationFunctionType {
        COUNT,
        SUM,
        MIN,
        MAX,
        AVG;

    }
}

