/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.query.ConditionQuery;
import org.apache.hugegraph.store.query.PropertyList;
import org.apache.hugegraph.store.query.QueryTypeParam;
import org.apache.hugegraph.store.query.StoreQueryType;
import org.apache.hugegraph.store.query.func.AggregationFunctionParam;

public class StoreQueryParam {
    private final PropertyList properties = PropertyList.of();
    private final boolean groupBySchemaLabel = false;
    private final SORT_ORDER sortOrder = SORT_ORDER.ASC;
    private final DEDUP_OPTION dedupOption = DEDUP_OPTION.NONE;
    private final Integer limit = 0;
    private final Integer offset = 0;
    private final double sampleFactor = 1.0;
    private final boolean loadPropertyFromIndex = false;
    private final boolean checkTTL = false;
    private String queryId;
    private String graph;
    private String table;
    private List<AggregationFunctionParam> funcList;
    private List<Id> groupBy;
    private List<Id> orderBy;
    private ConditionQuery conditionQuery;
    private List<Integer> having;
    private StoreQueryType queryType;
    private List<QueryTypeParam> queryParam;
    private byte[] position;
    private List<Id> olapProperties;
    private List<List<QueryTypeParam>> indexes;

    private static void isFalse(boolean expression, String message) {
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    private static <E> boolean isEmpty(List<E> list) {
        return list == null || list.size() == 0;
    }

    public void checkQuery() {
        StoreQueryParam.isFalse(this.queryId == null, "query id is null");
        StoreQueryParam.isFalse(this.graph == null, "graph is null");
        StoreQueryParam.isFalse(this.table == null, "table is null");
        StoreQueryParam.isFalse(this.queryType == null, "queryType is null");
        StoreQueryParam.isFalse(this.queryType == StoreQueryType.PRIMARY_SCAN && StoreQueryParam.isEmpty(this.queryParam), "query param is null when PRIMARY_SCAN");
        StoreQueryParam.isFalse(this.queryType == StoreQueryType.NO_SCAN && StoreQueryParam.isEmpty(this.indexes), "ScanType.NO_SCAN without indexes");
        StoreQueryParam.isFalse(this.queryType == StoreQueryType.NO_SCAN && (this.indexes.size() != 1 || this.indexes.get(0).size() != 1), "ScanType.NO_SCAN only support one index");
        StoreQueryParam.isFalse(false, " loadPropertyFromIndex only support one(must be one) index in no scan");
        StoreQueryParam.isFalse(this.queryType == StoreQueryType.INDEX_SCAN && StoreQueryParam.isEmpty(this.indexes), "ScanType.INDEX_SCAN without indexes ");
        StoreQueryParam.isFalse(!StoreQueryParam.isEmpty(this.groupBy) && !StoreQueryParam.isEmpty(this.properties.getPropertyIds()) && !new HashSet<Id>(this.groupBy).containsAll(this.properties.getPropertyIds()), "properties should be subset of groupBy");
        StoreQueryParam.isFalse(!StoreQueryParam.isEmpty(this.groupBy) && !StoreQueryParam.isEmpty(this.orderBy) && !new HashSet<Id>(this.groupBy).containsAll(this.orderBy), "order by should be subset of groupBy");
        if (this.funcList != null) {
            for (AggregationFunctionParam func : this.funcList) {
                if (func.getFunctionType() == AggregationFunctionParam.AggregationFunctionType.SUM || func.getFunctionType() == AggregationFunctionParam.AggregationFunctionType.MAX || func.getFunctionType() == AggregationFunctionParam.AggregationFunctionType.MIN || func.getFunctionType() == AggregationFunctionParam.AggregationFunctionType.AVG) {
                    StoreQueryParam.isFalse(func.getField() == null, func.getFunctionType().name() + " has no filed value");
                }
                if (func.getFunctionType() != AggregationFunctionParam.AggregationFunctionType.SUM) continue;
                StoreQueryParam.isFalse(func.getFieldType() == AggregationFunctionParam.FieldType.STRING, func.getFunctionType().name() + " can not apply a String type");
            }
        }
        StoreQueryParam.isFalse(this.limit <= 0, "limit should be greater than 0");
        StoreQueryParam.isFalse(false, "sample factor out of range [0-1]");
    }

    public PropertyList getProperties() {
        return this.properties;
    }

    public boolean isGroupBySchemaLabel() {
        Objects.requireNonNull(this);
        return false;
    }

    public SORT_ORDER getSortOrder() {
        return this.sortOrder;
    }

    public DEDUP_OPTION getDedupOption() {
        return this.dedupOption;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public double getSampleFactor() {
        return this.sampleFactor;
    }

    public boolean isLoadPropertyFromIndex() {
        Objects.requireNonNull(this);
        return false;
    }

    public boolean isCheckTTL() {
        Objects.requireNonNull(this);
        return false;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getGraph() {
        return this.graph;
    }

    public String getTable() {
        return this.table;
    }

    public List<AggregationFunctionParam> getFuncList() {
        return this.funcList;
    }

    public List<Id> getGroupBy() {
        return this.groupBy;
    }

    public List<Id> getOrderBy() {
        return this.orderBy;
    }

    public ConditionQuery getConditionQuery() {
        return this.conditionQuery;
    }

    public List<Integer> getHaving() {
        return this.having;
    }

    public StoreQueryType getQueryType() {
        return this.queryType;
    }

    public List<QueryTypeParam> getQueryParam() {
        return this.queryParam;
    }

    public byte[] getPosition() {
        return this.position;
    }

    public List<Id> getOlapProperties() {
        return this.olapProperties;
    }

    public List<List<QueryTypeParam>> getIndexes() {
        return this.indexes;
    }

    public void setQueryId(String queryId) {
        this.queryId = queryId;
    }

    public void setGraph(String graph) {
        this.graph = graph;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setFuncList(List<AggregationFunctionParam> funcList) {
        this.funcList = funcList;
    }

    public void setGroupBy(List<Id> groupBy) {
        this.groupBy = groupBy;
    }

    public void setOrderBy(List<Id> orderBy) {
        this.orderBy = orderBy;
    }

    public void setConditionQuery(ConditionQuery conditionQuery) {
        this.conditionQuery = conditionQuery;
    }

    public void setHaving(List<Integer> having) {
        this.having = having;
    }

    public void setQueryType(StoreQueryType queryType) {
        this.queryType = queryType;
    }

    public void setQueryParam(List<QueryTypeParam> queryParam) {
        this.queryParam = queryParam;
    }

    public void setPosition(byte[] position) {
        this.position = position;
    }

    public void setOlapProperties(List<Id> olapProperties) {
        this.olapProperties = olapProperties;
    }

    public void setIndexes(List<List<QueryTypeParam>> indexes) {
        this.indexes = indexes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StoreQueryParam)) {
            return false;
        }
        StoreQueryParam other = (StoreQueryParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isGroupBySchemaLabel() != other.isGroupBySchemaLabel()) {
            return false;
        }
        if (Double.compare(this.getSampleFactor(), other.getSampleFactor()) != 0) {
            return false;
        }
        if (this.isLoadPropertyFromIndex() != other.isLoadPropertyFromIndex()) {
            return false;
        }
        if (this.isCheckTTL() != other.isCheckTTL()) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        Integer this$offset = this.getOffset();
        Integer other$offset = other.getOffset();
        if (this$offset == null ? other$offset != null : !((Object)this$offset).equals(other$offset)) {
            return false;
        }
        PropertyList this$properties = this.getProperties();
        PropertyList other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !this$properties.equals(other$properties)) {
            return false;
        }
        SORT_ORDER this$sortOrder = this.getSortOrder();
        SORT_ORDER other$sortOrder = other.getSortOrder();
        if (this$sortOrder == null ? other$sortOrder != null : !((Object)((Object)this$sortOrder)).equals((Object)other$sortOrder)) {
            return false;
        }
        DEDUP_OPTION this$dedupOption = this.getDedupOption();
        DEDUP_OPTION other$dedupOption = other.getDedupOption();
        if (this$dedupOption == null ? other$dedupOption != null : !((Object)((Object)this$dedupOption)).equals((Object)other$dedupOption)) {
            return false;
        }
        String this$queryId = this.getQueryId();
        String other$queryId = other.getQueryId();
        if (this$queryId == null ? other$queryId != null : !this$queryId.equals(other$queryId)) {
            return false;
        }
        String this$graph = this.getGraph();
        String other$graph = other.getGraph();
        if (this$graph == null ? other$graph != null : !this$graph.equals(other$graph)) {
            return false;
        }
        String this$table = this.getTable();
        String other$table = other.getTable();
        if (this$table == null ? other$table != null : !this$table.equals(other$table)) {
            return false;
        }
        List<AggregationFunctionParam> this$funcList = this.getFuncList();
        List<AggregationFunctionParam> other$funcList = other.getFuncList();
        if (this$funcList == null ? other$funcList != null : !((Object)this$funcList).equals(other$funcList)) {
            return false;
        }
        List<Id> this$groupBy = this.getGroupBy();
        List<Id> other$groupBy = other.getGroupBy();
        if (this$groupBy == null ? other$groupBy != null : !((Object)this$groupBy).equals(other$groupBy)) {
            return false;
        }
        List<Id> this$orderBy = this.getOrderBy();
        List<Id> other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !((Object)this$orderBy).equals(other$orderBy)) {
            return false;
        }
        ConditionQuery this$conditionQuery = this.getConditionQuery();
        ConditionQuery other$conditionQuery = other.getConditionQuery();
        if (this$conditionQuery == null ? other$conditionQuery != null : !this$conditionQuery.equals(other$conditionQuery)) {
            return false;
        }
        List<Integer> this$having = this.getHaving();
        List<Integer> other$having = other.getHaving();
        if (this$having == null ? other$having != null : !((Object)this$having).equals(other$having)) {
            return false;
        }
        StoreQueryType this$queryType = this.getQueryType();
        StoreQueryType other$queryType = other.getQueryType();
        if (this$queryType == null ? other$queryType != null : !((Object)((Object)this$queryType)).equals((Object)other$queryType)) {
            return false;
        }
        List<QueryTypeParam> this$queryParam = this.getQueryParam();
        List<QueryTypeParam> other$queryParam = other.getQueryParam();
        if (this$queryParam == null ? other$queryParam != null : !((Object)this$queryParam).equals(other$queryParam)) {
            return false;
        }
        if (!Arrays.equals(this.getPosition(), other.getPosition())) {
            return false;
        }
        List<Id> this$olapProperties = this.getOlapProperties();
        List<Id> other$olapProperties = other.getOlapProperties();
        if (this$olapProperties == null ? other$olapProperties != null : !((Object)this$olapProperties).equals(other$olapProperties)) {
            return false;
        }
        List<List<QueryTypeParam>> this$indexes = this.getIndexes();
        List<List<QueryTypeParam>> other$indexes = other.getIndexes();
        return !(this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StoreQueryParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isGroupBySchemaLabel() ? 79 : 97);
        long $sampleFactor = Double.doubleToLongBits(this.getSampleFactor());
        result = result * 59 + (int)($sampleFactor >>> 32 ^ $sampleFactor);
        result = result * 59 + (this.isLoadPropertyFromIndex() ? 79 : 97);
        result = result * 59 + (this.isCheckTTL() ? 79 : 97);
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        Integer $offset = this.getOffset();
        result = result * 59 + ($offset == null ? 43 : ((Object)$offset).hashCode());
        PropertyList $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : $properties.hashCode());
        SORT_ORDER $sortOrder = this.getSortOrder();
        result = result * 59 + ($sortOrder == null ? 43 : ((Object)((Object)$sortOrder)).hashCode());
        DEDUP_OPTION $dedupOption = this.getDedupOption();
        result = result * 59 + ($dedupOption == null ? 43 : ((Object)((Object)$dedupOption)).hashCode());
        String $queryId = this.getQueryId();
        result = result * 59 + ($queryId == null ? 43 : $queryId.hashCode());
        String $graph = this.getGraph();
        result = result * 59 + ($graph == null ? 43 : $graph.hashCode());
        String $table = this.getTable();
        result = result * 59 + ($table == null ? 43 : $table.hashCode());
        List<AggregationFunctionParam> $funcList = this.getFuncList();
        result = result * 59 + ($funcList == null ? 43 : ((Object)$funcList).hashCode());
        List<Id> $groupBy = this.getGroupBy();
        result = result * 59 + ($groupBy == null ? 43 : ((Object)$groupBy).hashCode());
        List<Id> $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : ((Object)$orderBy).hashCode());
        ConditionQuery $conditionQuery = this.getConditionQuery();
        result = result * 59 + ($conditionQuery == null ? 43 : $conditionQuery.hashCode());
        List<Integer> $having = this.getHaving();
        result = result * 59 + ($having == null ? 43 : ((Object)$having).hashCode());
        StoreQueryType $queryType = this.getQueryType();
        result = result * 59 + ($queryType == null ? 43 : ((Object)((Object)$queryType)).hashCode());
        List<QueryTypeParam> $queryParam = this.getQueryParam();
        result = result * 59 + ($queryParam == null ? 43 : ((Object)$queryParam).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPosition());
        List<Id> $olapProperties = this.getOlapProperties();
        result = result * 59 + ($olapProperties == null ? 43 : ((Object)$olapProperties).hashCode());
        List<List<QueryTypeParam>> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        return result;
    }

    public String toString() {
        return "StoreQueryParam(properties=" + String.valueOf(this.getProperties()) + ", groupBySchemaLabel=" + this.isGroupBySchemaLabel() + ", sortOrder=" + String.valueOf((Object)this.getSortOrder()) + ", dedupOption=" + String.valueOf((Object)this.getDedupOption()) + ", limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", sampleFactor=" + this.getSampleFactor() + ", loadPropertyFromIndex=" + this.isLoadPropertyFromIndex() + ", checkTTL=" + this.isCheckTTL() + ", queryId=" + this.getQueryId() + ", graph=" + this.getGraph() + ", table=" + this.getTable() + ", funcList=" + String.valueOf(this.getFuncList()) + ", groupBy=" + String.valueOf(this.getGroupBy()) + ", orderBy=" + String.valueOf(this.getOrderBy()) + ", conditionQuery=" + String.valueOf(this.getConditionQuery()) + ", having=" + String.valueOf(this.getHaving()) + ", queryType=" + String.valueOf((Object)this.getQueryType()) + ", queryParam=" + String.valueOf(this.getQueryParam()) + ", position=" + Arrays.toString(this.getPosition()) + ", olapProperties=" + String.valueOf(this.getOlapProperties()) + ", indexes=" + String.valueOf(this.getIndexes()) + ")";
    }

    public static enum SORT_ORDER {
        ASC,
        DESC,
        STRICT_ORDER;

    }

    public static enum DEDUP_OPTION {
        NONE,
        DEDUP,
        LIMIT_DEDUP,
        PRECISE_DEDUP;

    }
}

