/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query;

import java.util.Arrays;

public class QueryTypeParam {
    public static final QueryTypeParam EMPTY = new QueryTypeParam();
    int code = -1;
    private byte[] start;
    private byte[] end;
    private int boundary = 0;
    private boolean isPrefix = false;
    private boolean isSecondaryIndex = false;
    private byte[] idPrefix;

    private QueryTypeParam() {
    }

    public QueryTypeParam(byte[] start, byte[] end, int boundary, boolean isPrefix, boolean isSecondaryIndex, int code) {
        this.start = start;
        this.end = end;
        this.boundary = boundary;
        this.isPrefix = isPrefix;
        this.isSecondaryIndex = isSecondaryIndex;
        this.code = code;
    }

    public QueryTypeParam(byte[] start, byte[] end, int boundary, boolean isPrefix, boolean isSecondaryIndex, int code, byte[] idPrefix) {
        this.start = start;
        this.end = end;
        this.boundary = boundary;
        this.isPrefix = isPrefix;
        this.isSecondaryIndex = isSecondaryIndex;
        this.code = code;
        this.idPrefix = idPrefix;
    }

    @Deprecated
    public static QueryTypeParam ofIdScanParam(byte[] start) {
        assert (start != null);
        return new QueryTypeParam(start, null, 0, false, false, -1);
    }

    public static QueryTypeParam ofIdScanParam(byte[] start, int code) {
        assert (start != null);
        return new QueryTypeParam(start, null, 0, false, false, code);
    }

    public static QueryTypeParam ofPrefixScanParam(byte[] start, int boundary) {
        assert (start != null);
        return new QueryTypeParam(start, null, boundary, true, false, -1);
    }

    public static QueryTypeParam ofPrefixScanParam(byte[] start, int boundary, int code) {
        assert (start != null);
        return new QueryTypeParam(start, null, boundary, true, false, code);
    }

    public static QueryTypeParam ofRangeScanParam(byte[] start, byte[] end, int boundary) {
        assert (start != null && end != null);
        return new QueryTypeParam(start, end, boundary, false, false, -1);
    }

    public static QueryTypeParam ofRangeScanParam(byte[] start, byte[] end, int boundary, int code) {
        assert (start != null && end != null);
        return new QueryTypeParam(start, end, boundary, false, false, code);
    }

    public static QueryTypeParam ofIndexScanParam(byte[] start, byte[] end, int boundary) {
        return new QueryTypeParam(start, end, boundary, false, true, -1);
    }

    public static QueryTypeParam ofIndexScanParam(byte[] start, byte[] end, int boundary, byte[] idPrefix) {
        return new QueryTypeParam(start, end, boundary, false, true, -1, idPrefix);
    }

    public static QueryTypeParam ofIndexScanParam(byte[] start, int boundary) {
        return new QueryTypeParam(start, null, boundary, true, true, -1);
    }

    public static QueryTypeParam ofIndexScanParam(byte[] start, int boundary, byte[] idPrefix) {
        return new QueryTypeParam(start, null, boundary, true, true, -1, idPrefix);
    }

    public byte[] getIdPrefix() {
        return this.idPrefix;
    }

    public void setIdPrefix(byte[] idPrefix) {
        this.idPrefix = idPrefix;
    }

    public boolean isIdScan() {
        return !this.isPrefix && this.start != null && this.start.length > 0 && (this.end == null || this.end.length == 0) && !this.isSecondaryIndex;
    }

    public boolean isRangeScan() {
        return !this.isPrefix && this.start != null && this.start.length > 0 && this.end != null && this.end.length > 0 && !this.isSecondaryIndex;
    }

    public boolean isPrefixScan() {
        return this.isPrefix && this.start != null && this.start.length > 0 && (this.end == null || this.end.length == 0) && !this.isSecondaryIndex;
    }

    public boolean isIndexScan() {
        return this.isRangeIndexScan() || this.isPrefixIndexScan();
    }

    public boolean isRangeIndexScan() {
        return this.isSecondaryIndex && !this.isPrefix && this.start != null && this.start.length > 0 && this.end != null && this.end.length > 0;
    }

    public boolean isPrefixIndexScan() {
        return this.isSecondaryIndex && this.isPrefix && this.start != null && this.start.length > 0;
    }

    public String toString() {
        return "QueryTypeParam{" + (this.isSecondaryIndex ? "[S - " : "[P - ") + (this.end != null ? "Range]" : (this.isPrefix ? "Prefix]" : "ID]")) + " start=" + Arrays.toString(this.start) + (String)(this.end != null ? ", end=" + Arrays.toString(this.end) : "") + ", boundary=" + this.boundary + (String)(this.isIdScan() ? ", code=" + this.code : "") + (String)(this.idPrefix != null ? ", idPrefix=" + Arrays.toString(this.idPrefix) : "") + "}";
    }

    public int getCode() {
        return this.code;
    }

    public byte[] getStart() {
        return this.start;
    }

    public byte[] getEnd() {
        return this.end;
    }

    public int getBoundary() {
        return this.boundary;
    }

    public boolean isPrefix() {
        return this.isPrefix;
    }

    public boolean isSecondaryIndex() {
        return this.isSecondaryIndex;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setStart(byte[] start) {
        this.start = start;
    }

    public void setEnd(byte[] end) {
        this.end = end;
    }

    public void setBoundary(int boundary) {
        this.boundary = boundary;
    }

    public void setPrefix(boolean isPrefix) {
        this.isPrefix = isPrefix;
    }

    public void setSecondaryIndex(boolean isSecondaryIndex) {
        this.isSecondaryIndex = isSecondaryIndex;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryTypeParam)) {
            return false;
        }
        QueryTypeParam other = (QueryTypeParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.getBoundary() != other.getBoundary()) {
            return false;
        }
        if (this.isPrefix() != other.isPrefix()) {
            return false;
        }
        if (this.isSecondaryIndex() != other.isSecondaryIndex()) {
            return false;
        }
        if (!Arrays.equals(this.getStart(), other.getStart())) {
            return false;
        }
        if (!Arrays.equals(this.getEnd(), other.getEnd())) {
            return false;
        }
        return Arrays.equals(this.getIdPrefix(), other.getIdPrefix());
    }

    protected boolean canEqual(Object other) {
        return other instanceof QueryTypeParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + this.getBoundary();
        result = result * 59 + (this.isPrefix() ? 79 : 97);
        result = result * 59 + (this.isSecondaryIndex() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getStart());
        result = result * 59 + Arrays.hashCode(this.getEnd());
        result = result * 59 + Arrays.hashCode(this.getIdPrefix());
        return result;
    }
}

