/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.query;

import java.util.List;
import org.apache.hugegraph.id.Id;

public class PropertyList {
    private final List<Id> propertyIds;
    private final boolean emptyId;

    private PropertyList(List<Id> propertyIds, boolean emptyId) {
        this.propertyIds = propertyIds;
        this.emptyId = emptyId;
    }

    public static PropertyList empty() {
        return new PropertyList(List.of(), true);
    }

    public static PropertyList of() {
        return new PropertyList(List.of(), false);
    }

    public static PropertyList of(List<Id> propertyIds) {
        return new PropertyList(propertyIds, false);
    }

    public List<Id> getPropertyIds() {
        return this.propertyIds;
    }

    public boolean isEmptyId() {
        return this.emptyId;
    }

    public boolean needSerialize() {
        return this.emptyId || this.propertyIds != null && this.propertyIds.size() > 0;
    }

    public String toString() {
        return "PropertyList{propertyIds=" + String.valueOf(this.propertyIds) + ", isEmpty=" + this.emptyId + "}";
    }
}

