/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.PagingStateException;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Clauses;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.page.PageState;
import org.apache.hugegraph.backend.query.Aggregate;
import org.apache.hugegraph.backend.query.Condition;
import org.apache.hugegraph.backend.query.IdQuery;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendTable;
import org.apache.hugegraph.backend.store.Shard;
import org.apache.hugegraph.backend.store.cassandra.CassandraBackendEntry;
import org.apache.hugegraph.backend.store.cassandra.CassandraEntryIterator;
import org.apache.hugegraph.backend.store.cassandra.CassandraSessionPool;
import org.apache.hugegraph.backend.store.cassandra.CassandraShard;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.exception.NotSupportException;
import org.apache.hugegraph.iterator.ExtendableIterator;
import org.apache.hugegraph.iterator.WrappedIterator;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.CopyUtil;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;
import org.slf4j.Logger;

public abstract class CassandraTable
extends BackendTable<CassandraSessionPool.Session, TableBackendEntry.Row> {
    private static final Logger LOG = Log.logger(CassandraTable.class);
    private static final int MAX_ELEMENTS_IN_CLAUSE = 65535;

    public CassandraTable(String table) {
        super(table);
    }

    protected void registerMetaHandlers() {
        this.registerMetaHandler("splits", (session, meta, args) -> {
            E.checkArgument((args.length == 1 ? 1 : 0) != 0, (String)"The args count of %s must be 1", (Object[])new Object[]{meta});
            long splitSize = (Long)args[0];
            CassandraShard splitter = new CassandraShard((CassandraSessionPool.Session)session, session.keyspace(), this.table());
            return splitter.getSplits(0L, splitSize);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean queryExist(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
        IdQuery.OneIdQuery query = new IdQuery.OneIdQuery(HugeType.UNKNOWN, entry.id());
        Iterator<BackendEntry> iter = this.query(session, (Query)query);
        try {
            boolean bl = iter.hasNext();
            return bl;
        }
        finally {
            WrappedIterator.close(iter);
        }
    }

    public Number queryNumber(CassandraSessionPool.Session session, Query query) {
        Aggregate aggregate = query.aggregateNotNull();
        Iterator results = this.query(query, statement -> {
            int timeout = session.aggregateTimeout();
            statement.setReadTimeoutMillis(timeout * 1000);
            return session.query((Statement)statement);
        }, (q, rs) -> {
            Row row = rs.one();
            if (row == null) {
                return IteratorUtils.of((Object)aggregate.defaultValue());
            }
            return IteratorUtils.of((Object)row.getLong(0));
        });
        return aggregate.reduce(results);
    }

    public Iterator<BackendEntry> query(CassandraSessionPool.Session session, Query query) {
        return this.query(query, session::query, this::results2Entries);
    }

    protected <R> Iterator<R> query(Query query, Function<Statement, ResultSet> fetcher, BiFunction<Query, ResultSet, Iterator<R>> parser) {
        ExtendableIterator rs = new ExtendableIterator();
        if (query.limit() == 0L && !query.noLimit()) {
            LOG.debug("Return empty result(limit=0) for query {}", (Object)query);
            return rs;
        }
        List<Select> selects = this.query2Select(this.table(), query);
        try {
            for (Select select : selects) {
                ResultSet results = fetcher.apply((Statement)select);
                rs.extend(parser.apply(query, results));
            }
        }
        catch (DriverException e) {
            LOG.debug("Failed to query [{}], detail statement: {}", new Object[]{query, selects, e});
            try {
                rs.close();
            }
            catch (Exception e2) {
                LOG.error("Got error {} when closing iterator for query {}", (Object)e2, (Object)query);
            }
            throw new BackendException("Failed to query [%s]", (Throwable)e, new Object[]{query});
        }
        LOG.debug("Return {} for query {}", (Object)rs, (Object)query);
        return rs;
    }

    protected List<Select> query2Select(String table, Query query) {
        Select.Selection selection = QueryBuilder.select();
        Aggregate aggregate = query.aggregate();
        if (aggregate != null) {
            if (aggregate.countAll()) {
                selection.countAll();
            } else {
                selection.fcall(aggregate.func().string(), new Object[]{aggregate.column()});
            }
        }
        Select select = selection.from(table);
        if (query.offset() != 0L) {
            LOG.debug("Query offset is not supported on Cassandra store currently, it will be replaced by [0, offset + limit)");
        }
        for (Map.Entry order : query.orders().entrySet()) {
            String name = CassandraTable.formatKey((HugeKeys)order.getKey());
            if (order.getValue() == Query.Order.ASC) {
                select.orderBy(new Ordering[]{QueryBuilder.asc((String)name)});
                continue;
            }
            assert (order.getValue() == Query.Order.DESC);
            select.orderBy(new Ordering[]{QueryBuilder.desc((String)name)});
        }
        List<Select> ids = this.queryId2Select(query, select);
        if (query.conditionsSize() == 0) {
            this.setPageState(query, ids);
            LOG.debug("Query only by id(s): {}", ids);
            return ids;
        }
        ArrayList<Select> conds = new ArrayList<Select>(ids.size());
        for (Select id : ids) {
            conds.addAll(this.queryCondition2Select(query, id));
        }
        this.setPageState(query, conds);
        LOG.debug("Query by conditions: {}", conds);
        return conds;
    }

    protected void setPageState(Query query, List<Select> selects) {
        if (query.noLimit() && !query.paging()) {
            return;
        }
        for (Select select : selects) {
            int total = (int)query.total();
            if (!query.noLimit()) {
                E.checkArgument(((long)total == query.total() ? 1 : 0) != 0, (String)"Invalid query limit %s", (Object[])new Object[]{query.limit()});
            } else assert (total == -1) : total;
            String page = query.page();
            if (page == null) {
                assert (total > 0) : total;
                select.limit(total);
                continue;
            }
            assert (total > 0 || total == -1) : total;
            select.setFetchSize(total);
            if (page.isEmpty()) continue;
            byte[] position = PageState.fromString((String)page).position();
            try {
                select.setPagingState(PagingState.fromBytes((byte[])position));
            }
            catch (PagingStateException e) {
                throw new BackendException((Throwable)e);
            }
        }
    }

    protected List<Select> queryId2Select(Query query, Select select) {
        if (query.idsSize() == 0) {
            return ImmutableList.of((Object)select);
        }
        List<HugeKeys> nameParts = this.idColumnName();
        ArrayList<List<Object>> ids = new ArrayList<List<Object>>(query.idsSize());
        for (Id id : query.ids()) {
            List<Object> list = this.idColumnValue(id);
            if (nameParts.size() != list.size()) {
                throw new NotFoundException("Unsupported ID format: '%s' (should contain %s)", new Object[]{id, nameParts});
            }
            ids.add(list);
        }
        if (nameParts.size() == 1) {
            ArrayList<Object> idList = new ArrayList<Object>(ids.size());
            for (List list : ids) {
                assert (list.size() == 1);
                idList.add(list.get(0));
            }
            return this.ids2IdSelects(select, nameParts.get(0), idList);
        }
        ArrayList<Select> selects = new ArrayList<Select>(ids.size());
        for (List list : ids) {
            assert (nameParts.size() == list.size());
            Select idSelect = CassandraTable.cloneSelect(select, this.table());
            int n = nameParts.size();
            for (int i = 0; i < n; ++i) {
                idSelect.where(CassandraTable.formatEQ(nameParts.get(i), list.get(i)));
            }
            selects.add(idSelect);
        }
        return selects;
    }

    protected Collection<Select> queryCondition2Select(Query query, Select select) {
        Collection conditions = query.conditions();
        for (Condition condition : conditions) {
            Clause clause = this.condition2Cql(condition);
            select.where(clause);
            if (!Clauses.needAllowFiltering(clause)) continue;
            select.allowFiltering();
        }
        return ImmutableList.of((Object)select);
    }

    protected Clause condition2Cql(Condition condition) {
        switch (condition.type()) {
            case AND: {
                Condition.And and = (Condition.And)condition;
                Clause left = this.condition2Cql(and.left());
                Clause right = this.condition2Cql(and.right());
                return Clauses.and(left, right);
            }
            case OR: {
                throw new BackendException("Not support OR currently");
            }
            case RELATION: {
                Condition.Relation r = (Condition.Relation)condition;
                return this.relation2Cql(r);
            }
        }
        String msg = "Unsupported condition: " + String.valueOf(condition);
        throw new AssertionError((Object)msg);
    }

    protected Clause relation2Cql(Condition.Relation relation) {
        String key = relation.serialKey().toString();
        Object value = relation.serialValue();
        switch (relation.relation()) {
            case EQ: {
                return QueryBuilder.eq((String)key, (Object)value);
            }
            case GT: {
                return QueryBuilder.gt((String)key, (Object)value);
            }
            case GTE: {
                return QueryBuilder.gte((String)key, (Object)value);
            }
            case LT: {
                return QueryBuilder.lt((String)key, (Object)value);
            }
            case LTE: {
                return QueryBuilder.lte((String)key, (Object)value);
            }
            case IN: {
                return Clauses.in(key, (List)value);
            }
            case CONTAINS_VALUE: {
                return QueryBuilder.contains((String)key, (Object)value);
            }
            case CONTAINS_KEY: {
                return QueryBuilder.containsKey((String)key, (Object)value);
            }
            case SCAN: {
                String[] col = (String[])this.pkColumnName().stream().map(CassandraTable::formatKey).toArray(String[]::new);
                Shard shard = (Shard)value;
                Object start = QueryBuilder.raw((String)shard.start());
                Object end = QueryBuilder.raw((String)shard.end());
                return Clauses.and(QueryBuilder.gte((String)QueryBuilder.token((String[])col), (Object)start), QueryBuilder.lt((String)QueryBuilder.token((String[])col), (Object)end));
            }
        }
        throw new NotSupportException("relation '%s'", new Object[]{relation});
    }

    private List<Select> ids2IdSelects(Select select, HugeKeys key, List<Object> ids) {
        int size = ids.size();
        ArrayList<Select> selects = new ArrayList<Select>();
        int i = 0;
        while (i < size) {
            int j = Math.min(i + 65535, size);
            Select idSelect = CassandraTable.cloneSelect(select, this.table());
            idSelect.where(QueryBuilder.in((String)CassandraTable.formatKey(key), ids.subList(i, j)));
            selects.add(idSelect);
            i = j;
        }
        return selects;
    }

    protected static Select cloneSelect(Select select, String table) {
        return (Select)CopyUtil.copy((Object)select, (Object)QueryBuilder.select().from(table));
    }

    protected Iterator<BackendEntry> results2Entries(Query q, ResultSet r) {
        return new CassandraEntryIterator(r, q, (e1, row) -> {
            CassandraBackendEntry e2 = CassandraTable.row2Entry(q.resultType(), row);
            return this.mergeEntries((BackendEntry)e1, (BackendEntry)e2);
        });
    }

    protected static CassandraBackendEntry row2Entry(HugeType type, Row row) {
        CassandraBackendEntry entry = new CassandraBackendEntry(type);
        List cols = row.getColumnDefinitions().asList();
        for (ColumnDefinitions.Definition col : cols) {
            String name = col.getName();
            HugeKeys key = CassandraTable.parseKey(name);
            Object value = row.getObject(name);
            if (value == null) {
                assert (key == HugeKeys.EXPIRED_TIME);
                continue;
            }
            entry.column(key, value);
        }
        return entry;
    }

    protected List<HugeKeys> pkColumnName() {
        return this.idColumnName();
    }

    protected List<HugeKeys> idColumnName() {
        return ImmutableList.of((Object)HugeKeys.ID);
    }

    protected List<Object> idColumnValue(Id id) {
        return ImmutableList.of((Object)id.asObject());
    }

    protected List<Long> idColumnValue(TableBackendEntry.Row entry) {
        return ImmutableList.of((Object)entry.id().asLong());
    }

    protected List<HugeKeys> modifiableColumnName() {
        return ImmutableList.of((Object)HugeKeys.PROPERTIES);
    }

    protected BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
        return e2;
    }

    public static final String formatKey(HugeKeys key) {
        return key.name();
    }

    public static final HugeKeys parseKey(String name) {
        return HugeKeys.valueOf((String)name.toUpperCase());
    }

    public static final Clause formatEQ(HugeKeys key, Object value) {
        return QueryBuilder.eq((String)CassandraTable.formatKey(key), (Object)value);
    }

    public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
        session.add((Statement)this.buildInsert(entry));
    }

    public void append(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
        session.add((Statement)this.buildAppend(entry));
    }

    public void eliminate(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
        session.add((Statement)this.buildEliminate(entry));
    }

    public void delete(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
        session.add((Statement)this.buildDelete(entry));
    }

    protected Insert buildInsert(TableBackendEntry.Row entry) {
        assert (!entry.columns().isEmpty());
        Insert insert = QueryBuilder.insertInto((String)this.table());
        for (Map.Entry c : entry.columns().entrySet()) {
            insert.value(CassandraTable.formatKey((HugeKeys)c.getKey()), c.getValue());
        }
        return insert;
    }

    protected Update buildAppend(TableBackendEntry.Row entry) {
        List<HugeKeys> idNames = this.idColumnName();
        List<HugeKeys> colNames = this.modifiableColumnName();
        Map columns = entry.columns();
        Update update = QueryBuilder.update((String)this.table());
        for (HugeKeys key : colNames) {
            if (!columns.containsKey(key)) continue;
            String name = CassandraTable.formatKey(key);
            Object value = columns.get(key);
            if (value instanceof Map) {
                update.with(QueryBuilder.putAll((String)name, (Map)((Map)value)));
                continue;
            }
            if (value instanceof List) {
                update.with(QueryBuilder.appendAll((String)name, (List)((List)value)));
                continue;
            }
            update.with(QueryBuilder.append((String)name, value));
        }
        for (HugeKeys idName : idNames) {
            assert (columns.containsKey(idName));
            update.where(CassandraTable.formatEQ(idName, columns.get(idName)));
        }
        return update;
    }

    protected Update buildEliminate(TableBackendEntry.Row entry) {
        List<HugeKeys> idNames = this.idColumnName();
        List<HugeKeys> colNames = this.modifiableColumnName();
        Map columns = entry.columns();
        Update update = QueryBuilder.update((String)this.table());
        for (HugeKeys key : colNames) {
            Set keySet;
            if (!columns.containsKey(key)) continue;
            String name = CassandraTable.formatKey(key);
            Object value = columns.get(key);
            if (value instanceof Map) {
                keySet = ((Map)value).keySet();
                update.with(QueryBuilder.removeAll((String)name, keySet));
                continue;
            }
            if (value instanceof Set) {
                update.with(QueryBuilder.removeAll((String)name, (Set)((Set)value)));
                continue;
            }
            if (value instanceof List) {
                keySet = new HashSet((List)value);
                update.with(QueryBuilder.removeAll((String)name, keySet));
                continue;
            }
            update.with(QueryBuilder.remove((String)name, value));
        }
        for (HugeKeys idName : idNames) {
            assert (columns.containsKey(idName));
            update.where(CassandraTable.formatEQ(idName, columns.get(idName)));
        }
        return update;
    }

    protected Delete buildDelete(TableBackendEntry.Row entry) {
        List<HugeKeys> idNames = this.idColumnName();
        Delete delete = QueryBuilder.delete().from(this.table());
        if (entry.columns().isEmpty()) {
            List<Long> idValues = this.idColumnValue(entry);
            assert (idNames.size() == idValues.size());
            int n = idNames.size();
            for (int i = 0; i < n; ++i) {
                delete.where(CassandraTable.formatEQ(idNames.get(i), idValues.get(i)));
            }
        } else {
            for (HugeKeys idName : idNames) {
                delete.where(CassandraTable.formatEQ(idName, entry.column(idName)));
            }
        }
        return delete;
    }

    protected void createTable(CassandraSessionPool.Session session, ImmutableMap<HugeKeys, DataType> partitionKeys, ImmutableMap<HugeKeys, DataType> clusteringKeys, ImmutableMap<HugeKeys, DataType> columns) {
        Create table = (Create)SchemaBuilder.createTable((String)this.table()).ifNotExists();
        for (Map.Entry entry : partitionKeys.entrySet()) {
            table.addPartitionKey(CassandraTable.formatKey((HugeKeys)entry.getKey()), (DataType)entry.getValue());
        }
        for (Map.Entry entry : clusteringKeys.entrySet()) {
            table.addClusteringColumn(CassandraTable.formatKey((HugeKeys)entry.getKey()), (DataType)entry.getValue());
        }
        for (Map.Entry entry : columns.entrySet()) {
            table.addColumn(CassandraTable.formatKey((HugeKeys)entry.getKey()), (DataType)entry.getValue());
        }
        LOG.debug("Create table: {}", (Object)table);
        session.execute((Statement)table);
    }

    protected void dropTable(CassandraSessionPool.Session session) {
        LOG.debug("Drop table: {}", (Object)this.table());
        session.execute((Statement)SchemaBuilder.dropTable((String)this.table()).ifExists());
    }

    protected void truncateTable(CassandraSessionPool.Session session) {
        LOG.debug("Truncate table: {}", (Object)this.table());
        session.execute((Statement)QueryBuilder.truncate((String)this.table()));
    }

    protected void createIndex(CassandraSessionPool.Session session, String indexLabel, HugeKeys column) {
        String indexName = CassandraTable.joinTableName((String)this.table(), (String)indexLabel);
        SchemaStatement index = SchemaBuilder.createIndex((String)indexName).ifNotExists().onTable(this.table()).andColumn(CassandraTable.formatKey(column));
        LOG.debug("Create index: {}", (Object)index);
        session.execute((Statement)index);
    }

    public void clear(CassandraSessionPool.Session session) {
        this.dropTable(session);
    }

    public void truncate(CassandraSessionPool.Session session) {
        this.truncateTable(session);
    }

    public boolean isOlap() {
        return false;
    }
}

