/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.pd.common.PDException;
import org.apache.hugegraph.pd.grpc.Metapb;
import org.apache.hugegraph.pd.model.Partition;
import org.apache.hugegraph.pd.service.PDRestService;
import org.apache.hugegraph.pd.service.PDService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphStatistics {
    private static final Logger log = LoggerFactory.getLogger(GraphStatistics.class);
    private transient PDRestService pdRestService;
    String graphName;
    long partitionCount;
    String state;
    List<Partition> partitions;
    long dataSize;
    int nodeCount;
    int edgeCount;
    long keyCount;

    public GraphStatistics(Metapb.Graph graph, PDRestService restService, PDService pdService) throws PDException {
        this.pdRestService = restService;
        if (graph == null) {
            return;
        }
        HashMap<Integer, Long> partition2DataSize = new HashMap<Integer, Long>();
        this.graphName = graph.getGraphName();
        this.partitionCount = graph.getPartitionCount();
        this.state = String.valueOf(graph.getState());
        List stores = this.pdRestService.getStores(this.graphName);
        for (Metapb.Store store : stores) {
            List graphStatsList = store.getStats().getGraphStatsList();
            Iterator iterator = graphStatsList.iterator();
            while (iterator.hasNext()) {
                Metapb.GraphStats graphStats = (Metapb.GraphStats)iterator.next();
                if (!this.graphName.equals(graphStats.getGraphName()) || !Metapb.ShardRole.Leader.equals((Object)graphStats.getRole())) continue;
                this.keyCount += graphStats.getApproximateKeys();
                this.dataSize += graphStats.getApproximateSize();
                partition2DataSize.put(graphStats.getPartitionId(), graphStats.getApproximateSize());
            }
        }
        ArrayList<Partition> resultPartitionList = new ArrayList<Partition>();
        List tmpPartitions = this.pdRestService.getPartitions(this.graphName);
        if (tmpPartitions != null && !tmpPartitions.isEmpty()) {
            for (Metapb.Partition partition : tmpPartitions) {
                Metapb.PartitionStats partitionStats = this.pdRestService.getPartitionStats(this.graphName, partition.getId());
                Partition pt = new Partition(partition, partitionStats, pdService);
                pt.dataSize = partition2DataSize.getOrDefault(partition.getId(), 0L);
                resultPartitionList.add(pt);
            }
        }
        this.partitions = resultPartitionList;
        if (this.graphName != null && this.graphName.length() >= 2) {
            String suf = this.graphName.substring(this.graphName.length() - 2);
            if ("/g".equals(suf) || "/m".equals(suf) || "/s".equals(suf)) {
                this.graphName = this.graphName.substring(0, this.graphName.length() - 2);
            } else {
                log.error("invalid graph name in GraphStatistics: {}", (Object)this.graphName);
            }
        } else {
            log.error("invalid graph name in GraphStatistics: {}", (Object)this.graphName);
        }
    }

    public String getGraphName() {
        return this.graphName;
    }

    public long getPartitionCount() {
        return this.partitionCount;
    }

    public String getState() {
        return this.state;
    }

    public List<Partition> getPartitions() {
        return this.partitions;
    }

    public long getDataSize() {
        return this.dataSize;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public int getEdgeCount() {
        return this.edgeCount;
    }

    public long getKeyCount() {
        return this.keyCount;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public void setPartitionCount(long partitionCount) {
        this.partitionCount = partitionCount;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setPartitions(List<Partition> partitions) {
        this.partitions = partitions;
    }

    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    public void setNodeCount(int nodeCount) {
        this.nodeCount = nodeCount;
    }

    public void setEdgeCount(int edgeCount) {
        this.edgeCount = edgeCount;
    }

    public void setKeyCount(long keyCount) {
        this.keyCount = keyCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GraphStatistics)) {
            return false;
        }
        GraphStatistics other = (GraphStatistics)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getPartitionCount() != other.getPartitionCount()) {
            return false;
        }
        if (this.getDataSize() != other.getDataSize()) {
            return false;
        }
        if (this.getNodeCount() != other.getNodeCount()) {
            return false;
        }
        if (this.getEdgeCount() != other.getEdgeCount()) {
            return false;
        }
        if (this.getKeyCount() != other.getKeyCount()) {
            return false;
        }
        String this$graphName = this.getGraphName();
        String other$graphName = other.getGraphName();
        if (this$graphName == null ? other$graphName != null : !this$graphName.equals(other$graphName)) {
            return false;
        }
        String this$state = this.getState();
        String other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        List this$partitions = this.getPartitions();
        List other$partitions = other.getPartitions();
        return !(this$partitions == null ? other$partitions != null : !((Object)this$partitions).equals(other$partitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GraphStatistics;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $partitionCount = this.getPartitionCount();
        result = result * 59 + (int)($partitionCount >>> 32 ^ $partitionCount);
        long $dataSize = this.getDataSize();
        result = result * 59 + (int)($dataSize >>> 32 ^ $dataSize);
        result = result * 59 + this.getNodeCount();
        result = result * 59 + this.getEdgeCount();
        long $keyCount = this.getKeyCount();
        result = result * 59 + (int)($keyCount >>> 32 ^ $keyCount);
        String $graphName = this.getGraphName();
        result = result * 59 + ($graphName == null ? 43 : $graphName.hashCode());
        String $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        List $partitions = this.getPartitions();
        result = result * 59 + ($partitions == null ? 43 : ((Object)$partitions).hashCode());
        return result;
    }

    public String toString() {
        return "GraphStatistics(pdRestService=" + String.valueOf(this.pdRestService) + ", graphName=" + this.getGraphName() + ", partitionCount=" + this.getPartitionCount() + ", state=" + this.getState() + ", partitions=" + String.valueOf(this.getPartitions()) + ", dataSize=" + this.getDataSize() + ", nodeCount=" + this.getNodeCount() + ", edgeCount=" + this.getEdgeCount() + ", keyCount=" + this.getKeyCount() + ")";
    }
}

