/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.rocksdb;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.serializer.BinarySerializer;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.BackendEntryIterator;
import org.apache.hugegraph.backend.store.rocksdb.OpenedRocksDB;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBIngester;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBIteratorPool;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBOptions;
import org.apache.hugegraph.backend.store.rocksdb.RocksDBSessions;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.Bytes;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.hugegraph.util.StringEncoding;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.ColumnFamilyOptionsInterface;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.Env;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.MutableColumnFamilyOptionsInterface;
import org.rocksdb.MutableDBOptionsInterface;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.SstFileManager;
import org.rocksdb.TableFormatConfig;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;
import org.slf4j.Logger;

public class RocksDBStdSessions
extends RocksDBSessions {
    private static final Logger LOG = Log.logger(RocksDBStdSessions.class);
    private final HugeConfig config;
    private final String dataPath;
    private final String walPath;
    private volatile OpenedRocksDB rocksdb;
    private final AtomicInteger refCount;

    public RocksDBStdSessions(HugeConfig config, String database, String store, String dataPath, String walPath) throws RocksDBException {
        super(config, database, store);
        this.config = config;
        this.dataPath = dataPath;
        this.walPath = walPath;
        this.rocksdb = RocksDBStdSessions.openRocksDB(config, dataPath, walPath);
        this.refCount = new AtomicInteger(1);
    }

    public RocksDBStdSessions(HugeConfig config, String database, String store, String dataPath, String walPath, List<String> cfNames) throws RocksDBException {
        super(config, database, store);
        this.config = config;
        this.dataPath = dataPath;
        this.walPath = walPath;
        this.rocksdb = RocksDBStdSessions.openRocksDB(config, cfNames, dataPath, walPath);
        this.refCount = new AtomicInteger(1);
        this.ingestExternalFile();
    }

    private RocksDBStdSessions(HugeConfig config, String database, String store, RocksDBStdSessions origin) {
        super(config, database, store);
        this.config = config;
        this.dataPath = origin.dataPath;
        this.walPath = origin.walPath;
        this.rocksdb = origin.rocksdb;
        this.refCount = origin.refCount;
        this.refCount.incrementAndGet();
    }

    public void open() throws Exception {
    }

    protected boolean opened() {
        return this.rocksdb != null && this.rocksdb.isOwningHandle();
    }

    @Override
    public Set<String> openedTables() {
        return this.rocksdb.cfs();
    }

    @Override
    public synchronized void createTable(String ... tables) throws RocksDBException {
        this.checkValid();
        ArrayList<ColumnFamilyDescriptor> cfds = new ArrayList<ColumnFamilyDescriptor>();
        for (String table : tables) {
            if (this.rocksdb.existCf(table)) continue;
            ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(RocksDBStdSessions.encode(table));
            ColumnFamilyOptions options = cfd.getOptions();
            RocksDBStdSessions.initOptions(this.config(), null, null, options, options);
            cfds.add(cfd);
        }
        List cfhs = this.rocksdb().createColumnFamilies(cfds);
        for (ColumnFamilyHandle cfh : cfhs) {
            String table;
            table = RocksDBStdSessions.decode(cfh.getName());
            this.rocksdb.addCf(table, new OpenedRocksDB.CFHandle(this.rocksdb(), cfh));
        }
        this.ingestExternalFile();
    }

    @Override
    public synchronized void dropTable(String ... tables) throws RocksDBException {
        OpenedRocksDB.CFHandle cfh;
        this.checkValid();
        ArrayList<ColumnFamilyHandle> cfhs = new ArrayList<ColumnFamilyHandle>();
        for (String table : tables) {
            cfh = this.rocksdb.cf(table);
            if (cfh == null) continue;
            cfhs.add(cfh.waitForDrop());
        }
        this.rocksdb().dropColumnFamilies(cfhs);
        for (String table : tables) {
            cfh = this.rocksdb.cf(table);
            if (cfh == null) continue;
            cfh.destroy();
            this.rocksdb.removeCf(table);
        }
    }

    @Override
    public boolean existsTable(String table) {
        return this.rocksdb.existCf(table);
    }

    @Override
    public void reloadRocksDB() throws RocksDBException {
        if (this.rocksdb.isOwningHandle()) {
            this.rocksdb.close();
        }
        this.rocksdb = RocksDBStdSessions.openRocksDB(this.config, (List<String>)ImmutableList.of(), this.dataPath, this.walPath);
    }

    @Override
    public void forceCloseRocksDB() {
        this.rocksdb().close();
    }

    @Override
    public List<String> property(String property) {
        try {
            if (property.equals("rocksdb.disk-usage")) {
                long size = this.rocksdb.totalSize();
                return ImmutableList.of((Object)String.valueOf(size));
            }
            ArrayList<String> values = new ArrayList<String>();
            for (String cf : this.openedTables()) {
                OpenedRocksDB.CFHandle cfh = this.cf(cf);
                try {
                    values.add(this.rocksdb().getProperty(cfh.get(), property));
                }
                finally {
                    if (cfh == null) continue;
                    cfh.close();
                }
            }
            return values;
        }
        catch (UnsupportedOperationException | RocksDBException e) {
            throw new BackendException(e);
        }
    }

    @Override
    public void compactRange() {
        try {
            this.rocksdb().compactRange();
        }
        catch (RocksDBException e) {
            throw new BackendException((Throwable)e);
        }
    }

    @Override
    public RocksDBSessions copy(HugeConfig config, String database, String store) {
        return new RocksDBStdSessions(config, database, store, this);
    }

    @Override
    public void createSnapshot(String snapshotPath) {
        this.rocksdb.createCheckpoint(snapshotPath);
    }

    @Override
    public void resumeSnapshot(String snapshotPath) {
        File originDataDir = new File(this.dataPath);
        File snapshotDir = new File(snapshotPath);
        try {
            this.forceCloseRocksDB();
            if (originDataDir.exists()) {
                LOG.info("Delete origin data directory {}", (Object)originDataDir);
                FileUtils.deleteDirectory((File)originDataDir);
            }
            FileUtils.moveDirectory((File)snapshotDir, (File)originDataDir);
            LOG.info("Move snapshot directory {} to {}", (Object)snapshotDir, (Object)originDataDir);
            this.reloadRocksDB();
        }
        catch (Exception e) {
            throw new BackendException("Failed to resume snapshot '%s' to' %s'", (Throwable)e, new Object[]{snapshotDir, this.dataPath});
        }
    }

    @Override
    public String buildSnapshotPath(String snapshotPrefix) {
        Path originDataPath = Paths.get(this.dataPath, new String[0]);
        Path parentParentPath = originDataPath.toAbsolutePath().getParent().getParent();
        Path pureDataPath = parentParentPath.relativize(originDataPath.toAbsolutePath());
        Path snapshotPath = parentParentPath.resolve(snapshotPrefix + "_" + String.valueOf(pureDataPath));
        E.checkArgument((boolean)snapshotPath.toFile().exists(), (String)"The snapshot path '%s' doesn't exist", (Object[])new Object[]{snapshotPath});
        return snapshotPath.toString();
    }

    @Override
    public String hardLinkSnapshot(String snapshotPath) throws RocksDBException {
        String snapshotLinkPath = this.dataPath + "_temp";
        try (OpenedRocksDB rocksdb = RocksDBStdSessions.openRocksDB(this.config, (List<String>)ImmutableList.of(), snapshotPath, null);){
            rocksdb.createCheckpoint(snapshotLinkPath);
        }
        LOG.info("The snapshot {} has been hard linked to {}", (Object)snapshotPath, (Object)snapshotLinkPath);
        return snapshotLinkPath;
    }

    @Override
    public final RocksDBSessions.Session session() {
        return (RocksDBSessions.Session)super.getOrNewSession();
    }

    protected final RocksDBSessions.Session newSession() {
        E.checkState((boolean)this.rocksdb.isOwningHandle(), (String)"RocksDB has not been initialized", (Object[])new Object[0]);
        return new StdSession(this.config());
    }

    protected synchronized void doClose() {
        this.checkValid();
        if (this.refCount.decrementAndGet() > 0) {
            return;
        }
        assert (this.refCount.get() == 0);
        this.rocksdb.close();
    }

    private void checkValid() {
        E.checkState((boolean)this.rocksdb.isOwningHandle(), (String)"It seems RocksDB has been closed", (Object[])new Object[0]);
    }

    private RocksDB rocksdb() {
        this.checkValid();
        return this.rocksdb.rocksdb();
    }

    private OpenedRocksDB.CFHandle cf(String cfName) {
        OpenedRocksDB.CFHandle cfh = this.rocksdb.cf(cfName);
        if (cfh == null) {
            throw new BackendException("Table '%s' is not opened", new Object[]{cfName});
        }
        cfh.open();
        return cfh;
    }

    private void ingestExternalFile() throws RocksDBException {
        String directory = (String)this.config().get(RocksDBOptions.SST_PATH);
        if (directory == null || directory.isEmpty()) {
            return;
        }
        RocksDBIngester ingester = new RocksDBIngester(this.rocksdb());
        for (String cf : this.rocksdb.cfs()) {
            Path path = Paths.get(directory, cf);
            if (!path.toFile().isDirectory()) continue;
            OpenedRocksDB.CFHandle cfh = this.cf(cf);
            try {
                ingester.ingest(path, cfh.get());
            }
            finally {
                if (cfh == null) continue;
                cfh.close();
            }
        }
    }

    private static OpenedRocksDB openRocksDB(HugeConfig config, String dataPath, String walPath) throws RocksDBException {
        Options options = new Options();
        RocksDBStdSessions.initOptions(config, options, options, options, options);
        options.setWalDir(walPath);
        SstFileManager sstFileManager = new SstFileManager(Env.getDefault());
        options.setSstFileManager(sstFileManager);
        RocksDB rocksdb = RocksDB.open((Options)options, (String)dataPath);
        ConcurrentHashMap<String, OpenedRocksDB.CFHandle> cfs = new ConcurrentHashMap<String, OpenedRocksDB.CFHandle>();
        return new OpenedRocksDB(rocksdb, cfs, sstFileManager);
    }

    private static OpenedRocksDB openRocksDB(HugeConfig config, List<String> cfNames, String dataPath, String walPath) throws RocksDBException {
        Set<String> mergedCFs = RocksDBStdSessions.mergeOldCFs(dataPath, cfNames);
        ImmutableList cfs = ImmutableList.copyOf(mergedCFs);
        ArrayList<ColumnFamilyDescriptor> cfds = new ArrayList<ColumnFamilyDescriptor>(cfs.size());
        for (String cf : cfs) {
            ColumnFamilyDescriptor cfd = new ColumnFamilyDescriptor(RocksDBStdSessions.encode(cf));
            ColumnFamilyOptions options = cfd.getOptions();
            RocksDBStdSessions.initOptions(config, null, null, options, options);
            cfds.add(cfd);
        }
        DBOptions options = new DBOptions();
        RocksDBStdSessions.initOptions(config, options, options, null, null);
        if (walPath != null) {
            options.setWalDir(walPath);
        }
        SstFileManager sstFileManager = new SstFileManager(Env.getDefault());
        options.setSstFileManager(sstFileManager);
        ArrayList cfhs = new ArrayList();
        RocksDB rocksdb = RocksDB.open((DBOptions)options, (String)dataPath, cfds, cfhs);
        E.checkState((cfhs.size() == cfs.size() ? 1 : 0) != 0, (String)"Expect same size of cf-handles and cf-names", (Object[])new Object[0]);
        ConcurrentHashMap<String, OpenedRocksDB.CFHandle> cfHandles = new ConcurrentHashMap<String, OpenedRocksDB.CFHandle>();
        for (int i = 0; i < cfs.size(); ++i) {
            cfHandles.put((String)cfs.get(i), new OpenedRocksDB.CFHandle(rocksdb, (ColumnFamilyHandle)cfhs.get(i)));
        }
        return new OpenedRocksDB(rocksdb, cfHandles, sstFileManager);
    }

    private static Set<String> mergeOldCFs(String path, List<String> cfNames) throws RocksDBException {
        Set<String> cfs = RocksDBStdSessions.listCFs(path);
        cfs.addAll(cfNames);
        return cfs;
    }

    public static Set<String> listCFs(String path) throws RocksDBException {
        HashSet<String> cfs = new HashSet<String>();
        List oldCFs = RocksDB.listColumnFamilies((Options)new Options(), (String)path);
        if (oldCFs.isEmpty()) {
            cfs.add("default");
        } else {
            for (byte[] oldCF : oldCFs) {
                cfs.add(RocksDBStdSessions.decode(oldCF));
            }
        }
        return cfs;
    }

    public static void initOptions(HugeConfig conf, DBOptionsInterface<?> db, MutableDBOptionsInterface<?> mdb, ColumnFamilyOptionsInterface<?> cf, MutableColumnFamilyOptionsInterface<?> mcf) {
        boolean optimize = (Boolean)conf.get(RocksDBOptions.OPTIMIZE_MODE);
        if (db != null) {
            db.setCreateIfMissing(true);
            db.setWriteDbidToManifest(true);
            db.setAvoidUnnecessaryBlockingIO(true);
            if (optimize) {
                int processors = CoreOptions.CPUS;
                db.setIncreaseParallelism(Math.max(processors / 2, 1));
                db.setAllowConcurrentMemtableWrite(true);
                db.setEnableWriteThreadAdaptiveYield(true);
            }
            db.setInfoLogLevel(InfoLogLevel.valueOf((String)((String)conf.get(RocksDBOptions.LOG_LEVEL) + "_LEVEL")));
            db.setMaxSubcompactions(((Integer)conf.get(RocksDBOptions.MAX_SUB_COMPACTIONS)).intValue());
            db.setAllowMmapWrites(((Boolean)conf.get(RocksDBOptions.ALLOW_MMAP_WRITES)).booleanValue());
            db.setAllowMmapReads(((Boolean)conf.get(RocksDBOptions.ALLOW_MMAP_READS)).booleanValue());
            db.setUseDirectReads(((Boolean)conf.get(RocksDBOptions.USE_DIRECT_READS)).booleanValue());
            db.setUseDirectIoForFlushAndCompaction(((Boolean)conf.get(RocksDBOptions.USE_DIRECT_READS_WRITES_FC)).booleanValue());
            db.setUseFsync(((Boolean)conf.get(RocksDBOptions.USE_FSYNC)).booleanValue());
            db.setAtomicFlush(((Boolean)conf.get(RocksDBOptions.ATOMIC_FLUSH)).booleanValue());
            db.setMaxManifestFileSize(((Long)conf.get(RocksDBOptions.MAX_MANIFEST_FILE_SIZE)).longValue());
            db.setSkipStatsUpdateOnDbOpen(((Boolean)conf.get(RocksDBOptions.SKIP_STATS_UPDATE_ON_DB_OPEN)).booleanValue());
            db.setSkipCheckingSstFileSizesOnDbOpen(((Boolean)conf.get(RocksDBOptions.SKIP_CHECK_SIZE_ON_DB_OPEN)).booleanValue());
            db.setMaxFileOpeningThreads(((Integer)conf.get(RocksDBOptions.MAX_FILE_OPENING_THREADS)).intValue());
            db.setDbWriteBufferSize(((Long)conf.get(RocksDBOptions.DB_MEMTABLE_SIZE)).longValue());
            db.setLogReadaheadSize(((Long)conf.get(RocksDBOptions.LOG_READAHEAD_SIZE)).longValue());
            long cacheCapacity = (Long)conf.get(RocksDBOptions.ROW_CACHE_CAPACITY);
            if (cacheCapacity > 0L) {
                db.setRowCache((Cache)new LRUCache(cacheCapacity));
            }
        }
        if (mdb != null) {
            mdb.setMaxBackgroundJobs(((Integer)conf.get(RocksDBOptions.MAX_BG_JOBS)).intValue());
            mdb.setDelayedWriteRate(((Long)conf.get(RocksDBOptions.DELAYED_WRITE_RATE)).longValue());
            mdb.setMaxOpenFiles(((Integer)conf.get(RocksDBOptions.MAX_OPEN_FILES)).intValue());
            mdb.setMaxTotalWalSize(((Long)conf.get(RocksDBOptions.MAX_TOTAL_WAL_SIZE)).longValue());
            mdb.setBytesPerSync(((Long)conf.get(RocksDBOptions.BYTES_PER_SYNC)).longValue());
            mdb.setWalBytesPerSync(((Long)conf.get(RocksDBOptions.WAL_BYTES_PER_SYNC)).longValue());
            mdb.setStrictBytesPerSync(((Boolean)conf.get(RocksDBOptions.STRICT_BYTES_PER_SYNC)).booleanValue());
            mdb.setCompactionReadaheadSize(((Long)conf.get(RocksDBOptions.COMPACTION_READAHEAD_SIZE)).longValue());
            mdb.setDeleteObsoleteFilesPeriodMicros(1000000L * (Long)conf.get(RocksDBOptions.DELETE_OBSOLETE_FILE_PERIOD));
        }
        if (cf != null) {
            if (optimize) {
                cf.optimizeLevelStyleCompaction();
                cf.optimizeUniversalStyleCompaction();
            }
            int numLevels = (Integer)conf.get(RocksDBOptions.NUM_LEVELS);
            List compressions = (List)conf.get(RocksDBOptions.LEVELS_COMPRESSIONS);
            E.checkArgument((compressions.isEmpty() || compressions.size() == numLevels ? 1 : 0) != 0, (String)"Elements number of '%s' must be 0 or be the same as '%s', but got %s != %s", (Object[])new Object[]{RocksDBOptions.LEVELS_COMPRESSIONS.name(), RocksDBOptions.NUM_LEVELS.name(), compressions.size(), numLevels});
            cf.setNumLevels(numLevels);
            cf.setCompactionStyle((CompactionStyle)conf.get(RocksDBOptions.COMPACTION_STYLE));
            cf.setBottommostCompressionType((CompressionType)conf.get(RocksDBOptions.BOTTOMMOST_COMPRESSION));
            if (!compressions.isEmpty()) {
                cf.setCompressionPerLevel(compressions);
            }
            cf.setMinWriteBufferNumberToMerge(((Integer)conf.get(RocksDBOptions.MIN_MEMTABLES_TO_MERGE)).intValue());
            cf.setMaxWriteBufferNumberToMaintain(((Integer)conf.get(RocksDBOptions.MAX_MEMTABLES_TO_MAINTAIN)).intValue());
            cf.setInplaceUpdateSupport(((Boolean)conf.get(RocksDBOptions.MEMTABLE_INPLACE_UPDATE_SUPPORT)).booleanValue());
            cf.setLevelCompactionDynamicLevelBytes(((Boolean)conf.get(RocksDBOptions.DYNAMIC_LEVEL_BYTES)).booleanValue());
            cf.setOptimizeFiltersForHits(((Boolean)conf.get(RocksDBOptions.BLOOM_FILTERS_SKIP_LAST_LEVEL)).booleanValue());
            cf.setTableFormatConfig(RocksDBStdSessions.initTableConfig(conf));
            int prefixLength = (Integer)conf.get(RocksDBOptions.PREFIX_EXTRACTOR_CAPPED);
            if (prefixLength > 0) {
                cf.useCappedPrefixExtractor(prefixLength);
            }
            cf.setMergeOperatorName("uint64add");
        }
        if (mcf != null) {
            mcf.setCompressionType((CompressionType)conf.get(RocksDBOptions.COMPRESSION));
            mcf.setWriteBufferSize(((Long)conf.get(RocksDBOptions.MEMTABLE_SIZE)).longValue());
            mcf.setMaxWriteBufferNumber(((Integer)conf.get(RocksDBOptions.MAX_MEMTABLES)).intValue());
            mcf.setMaxBytesForLevelBase(((Long)conf.get(RocksDBOptions.MAX_LEVEL1_BYTES)).longValue());
            mcf.setMaxBytesForLevelMultiplier(((Double)conf.get(RocksDBOptions.MAX_LEVEL_BYTES_MULTIPLIER)).doubleValue());
            mcf.setTargetFileSizeBase(((Long)conf.get(RocksDBOptions.TARGET_FILE_SIZE_BASE)).longValue());
            mcf.setTargetFileSizeMultiplier(((Integer)conf.get(RocksDBOptions.TARGET_FILE_SIZE_MULTIPLIER)).intValue());
            mcf.setLevel0FileNumCompactionTrigger(((Integer)conf.get(RocksDBOptions.LEVEL0_COMPACTION_TRIGGER)).intValue());
            mcf.setLevel0SlowdownWritesTrigger(((Integer)conf.get(RocksDBOptions.LEVEL0_SLOWDOWN_WRITES_TRIGGER)).intValue());
            mcf.setLevel0StopWritesTrigger(((Integer)conf.get(RocksDBOptions.LEVEL0_STOP_WRITES_TRIGGER)).intValue());
            mcf.setSoftPendingCompactionBytesLimit(((Long)conf.get(RocksDBOptions.SOFT_PENDING_COMPACTION_LIMIT)).longValue());
            mcf.setHardPendingCompactionBytesLimit(((Long)conf.get(RocksDBOptions.HARD_PENDING_COMPACTION_LIMIT)).longValue());
            mcf.setMemtablePrefixBloomSizeRatio(((Double)conf.get(RocksDBOptions.MEMTABLE_BLOOM_SIZE_RATIO)).doubleValue());
            mcf.setMemtableWholeKeyFiltering(((Boolean)conf.get(RocksDBOptions.MEMTABLE_BLOOM_WHOLE_KEY_FILTERING)).booleanValue());
            mcf.setMemtableHugePageSize(((Long)conf.get(RocksDBOptions.MEMTABL_BLOOM_HUGE_PAGE_SIZE)).longValue());
            boolean bulkload = (Boolean)conf.get(RocksDBOptions.BULKLOAD_MODE);
            if (bulkload) {
                mcf.setDisableAutoCompactions(true);
                int trigger = Integer.MAX_VALUE;
                mcf.setLevel0FileNumCompactionTrigger(trigger);
                mcf.setLevel0SlowdownWritesTrigger(trigger);
                mcf.setLevel0StopWritesTrigger(trigger);
                long limit = Long.MAX_VALUE;
                mcf.setSoftPendingCompactionBytesLimit(limit);
                mcf.setHardPendingCompactionBytesLimit(limit);
            }
        }
    }

    public static TableFormatConfig initTableConfig(HugeConfig conf) {
        BlockBasedTableConfig tableConfig = new BlockBasedTableConfig();
        tableConfig.setFormatVersion(((Integer)conf.get(RocksDBOptions.TABLE_FORMAT_VERSION)).intValue());
        tableConfig.setIndexType((IndexType)conf.get(RocksDBOptions.INDEX_TYPE));
        tableConfig.setDataBlockIndexType((DataBlockIndexType)conf.get(RocksDBOptions.DATA_BLOCK_SEARCH_TYPE));
        tableConfig.setDataBlockHashTableUtilRatio(((Double)conf.get(RocksDBOptions.DATA_BLOCK_HASH_TABLE_RATIO)).doubleValue());
        long blockSize = (Long)conf.get(RocksDBOptions.BLOCK_SIZE);
        tableConfig.setBlockSize(blockSize);
        tableConfig.setBlockSizeDeviation(((Integer)conf.get(RocksDBOptions.BLOCK_SIZE_DEVIATION)).intValue());
        tableConfig.setBlockRestartInterval(((Integer)conf.get(RocksDBOptions.BLOCK_RESTART_INTERVAL)).intValue());
        long cacheCapacity = (Long)conf.get(RocksDBOptions.BLOCK_CACHE_CAPACITY);
        if (cacheCapacity <= 0L) {
            tableConfig.setNoBlockCache(true);
        } else {
            tableConfig.setBlockCache((Cache)new LRUCache(cacheCapacity));
        }
        int bitsPerKey = (Integer)conf.get(RocksDBOptions.BLOOM_FILTER_BITS_PER_KEY);
        if (bitsPerKey >= 0) {
            boolean blockBased = (Boolean)conf.get(RocksDBOptions.BLOOM_FILTER_MODE);
            tableConfig.setFilterPolicy((Filter)new BloomFilter((double)bitsPerKey, blockBased));
            tableConfig.setWholeKeyFiltering(((Boolean)conf.get(RocksDBOptions.BLOOM_FILTER_WHOLE_KEY)).booleanValue());
            tableConfig.setCacheIndexAndFilterBlocks(((Boolean)conf.get(RocksDBOptions.CACHE_FILTER_AND_INDEX)).booleanValue());
            tableConfig.setPinL0FilterAndIndexBlocksInCache(((Boolean)conf.get(RocksDBOptions.PIN_L0_INDEX_AND_FILTER)).booleanValue());
            if (((Boolean)conf.get(RocksDBOptions.PARTITION_FILTERS_INDEXES)).booleanValue()) {
                tableConfig.setPartitionFilters(true).setIndexType(IndexType.kTwoLevelIndexSearch).setMetadataBlockSize(blockSize).setCacheIndexAndFilterBlocksWithHighPriority(true);
                tableConfig.setPinTopLevelIndexAndFilter(((Boolean)conf.get(RocksDBOptions.PIN_TOP_INDEX_AND_FILTER)).booleanValue());
            }
        }
        return tableConfig;
    }

    public static byte[] encode(String string) {
        return StringEncoding.encode((String)string);
    }

    public static String decode(byte[] bytes) {
        return StringEncoding.decode((byte[])bytes);
    }

    private static class MgetIterator
    implements BackendEntry.BackendColumnIterator {
        private final List<byte[]> keys;
        private final List<byte[]> values;
        private int current;
        private byte[] currentValue;

        public MgetIterator(List<byte[]> keys, List<byte[]> values) {
            E.checkNotEmpty(keys, (String)"keys");
            E.checkNotEmpty(values, (String)"values");
            E.checkArgument((keys.size() == values.size() ? 1 : 0) != 0, (String)"Expect the same size between keys and values", (Object[])new Object[0]);
            this.keys = keys;
            this.values = values;
            this.current = 0;
            this.currentValue = null;
        }

        public void close() {
        }

        public byte[] position() {
            return null;
        }

        public boolean hasNext() {
            while (this.current < this.values.size()) {
                this.currentValue = this.values.get(this.current);
                if (this.currentValue != null) {
                    return true;
                }
                ++this.current;
            }
            return false;
        }

        public BackendEntry.BackendColumn next() {
            if (this.currentValue == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            byte[] key = this.keys.get(this.current++);
            byte[] value = this.currentValue;
            this.currentValue = null;
            return BackendEntry.BackendColumn.of((byte[])key, (byte[])value);
        }
    }

    private static class ScanIterator
    implements BackendEntry.BackendColumnIterator,
    RocksDBSessions.Countable {
        private final String table;
        private final RocksDBIteratorPool.ReusedRocksIterator reusedIter;
        private final RocksIterator iter;
        private final byte[] keyBegin;
        private final byte[] keyEnd;
        private final int scanType;
        private byte[] position;
        private boolean matched;

        public ScanIterator(String table, RocksDBIteratorPool.ReusedRocksIterator reusedIter, byte[] keyBegin, byte[] keyEnd, int scanType) {
            E.checkNotNull((Object)reusedIter, (String)"reusedIter");
            this.table = table;
            this.reusedIter = reusedIter;
            this.iter = reusedIter.iterator();
            this.keyBegin = keyBegin;
            this.keyEnd = keyEnd;
            this.scanType = scanType;
            this.position = keyBegin;
            this.matched = false;
            this.checkArguments();
            this.seek();
        }

        private void checkArguments() {
            E.checkArgument((!this.match(1) || !this.match(2) ? 1 : 0) != 0, (String)"Can't set SCAN_PREFIX_WITH_BEGIN and SCAN_PREFIX_WITH_END at the same time", (Object[])new Object[0]);
            E.checkArgument((!this.match(1) || !this.match(4) ? 1 : 0) != 0, (String)"Can't set SCAN_PREFIX_WITH_BEGIN and SCAN_GT_BEGIN/SCAN_GTE_BEGIN at the same time", (Object[])new Object[0]);
            E.checkArgument((!this.match(2) || !this.match(16) ? 1 : 0) != 0, (String)"Can't set SCAN_PREFIX_WITH_END and SCAN_LT_END/SCAN_LTE_END at the same time", (Object[])new Object[0]);
            if (this.match(1)) {
                E.checkArgument((this.keyBegin != null ? 1 : 0) != 0, (String)"Parameter `keyBegin` can't be null if set SCAN_PREFIX_WITH_BEGIN", (Object[])new Object[0]);
                E.checkArgument((this.keyEnd == null ? 1 : 0) != 0, (String)"Parameter `keyEnd` must be null if set SCAN_PREFIX_WITH_BEGIN", (Object[])new Object[0]);
            }
            if (this.match(2)) {
                E.checkArgument((this.keyEnd != null ? 1 : 0) != 0, (String)"Parameter `keyEnd` can't be null if set SCAN_PREFIX_WITH_END", (Object[])new Object[0]);
            }
            if (this.match(4)) {
                E.checkArgument((this.keyBegin != null ? 1 : 0) != 0, (String)"Parameter `keyBegin` can't be null if set SCAN_GT_BEGIN or SCAN_GTE_BEGIN", (Object[])new Object[0]);
            }
            if (this.match(16)) {
                E.checkArgument((this.keyEnd != null ? 1 : 0) != 0, (String)"Parameter `keyEnd` can't be null if set SCAN_LT_END or SCAN_LTE_END", (Object[])new Object[0]);
            }
        }

        private boolean match(int expected) {
            return RocksDBSessions.Session.matchScanType(expected, this.scanType);
        }

        private void dump() {
            this.seek();
            LOG.info(">>>> scan from {}: {}{}", new Object[]{this.table, this.keyBegin == null ? "*" : StringEncoding.format((byte[])this.keyBegin), this.iter.isValid() ? "" : " - No data"});
            while (this.iter.isValid()) {
                LOG.info("{}={}", (Object)StringEncoding.format((byte[])this.iter.key()), (Object)StringEncoding.format((byte[])this.iter.value()));
                this.iter.next();
            }
        }

        public boolean hasNext() {
            this.matched = this.iter.isOwningHandle();
            if (!this.matched) {
                return this.matched;
            }
            this.matched = this.iter.isValid();
            if (this.matched) {
                this.position = this.iter.key();
                if (!this.match(128)) {
                    this.matched = this.filter(this.position);
                }
            }
            if (!this.matched) {
                this.position = null;
                this.close();
            }
            return this.matched;
        }

        private void seek() {
            if (this.keyBegin == null || this.keyBegin.length == 0) {
                this.iter.seekToFirst();
            } else {
                this.iter.seek(this.keyBegin);
                if (this.match(4) && !this.match(12)) {
                    while (this.iter.isValid() && Bytes.equals((byte[])this.iter.key(), (byte[])this.keyBegin)) {
                        this.iter.next();
                    }
                }
            }
        }

        private boolean filter(byte[] key) {
            if (this.match(1)) {
                return Bytes.prefixWith((byte[])key, (byte[])this.keyBegin);
            }
            if (this.match(2)) {
                assert (this.keyEnd != null);
                return Bytes.prefixWith((byte[])key, (byte[])this.keyEnd);
            }
            if (this.match(16)) {
                assert (this.keyEnd != null);
                if (this.match(48)) {
                    return Bytes.compare((byte[])(key = Arrays.copyOfRange(key, 0, this.keyEnd.length)), (byte[])this.keyEnd) <= 0;
                }
                return Bytes.compare((byte[])key, (byte[])this.keyEnd) < 0;
            }
            assert (this.match(128) || this.match(4) || this.match(12)) : "Unknown scan type";
            return true;
        }

        public BackendEntry.BackendColumn next() {
            if (!this.matched && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            BackendEntry.BackendColumn col = BackendEntry.BackendColumn.of((byte[])this.iter.key(), (byte[])this.iter.value());
            this.iter.next();
            this.matched = false;
            return col;
        }

        @Override
        public long count() {
            long count = 0L;
            while (this.hasNext()) {
                this.iter.next();
                this.matched = false;
                ++count;
                BackendEntryIterator.checkInterrupted();
            }
            return count;
        }

        public byte[] position() {
            return this.position;
        }

        public void close() {
            this.reusedIter.close();
        }
    }

    private final class StdSession
    extends RocksDBSessions.Session {
        private WriteBatch batch = new WriteBatch();
        private final WriteOptions writeOptions = new WriteOptions();

        public StdSession(HugeConfig conf) {
            boolean raftMode = (Boolean)conf.get((TypedOption)CoreOptions.RAFT_MODE);
            if (raftMode) {
                this.writeOptions.setDisableWAL(true);
                this.writeOptions.setSync(false);
            }
        }

        public void open() {
            this.opened = true;
        }

        public void close() {
            assert (this.closeable());
            this.opened = false;
        }

        public boolean closed() {
            return !this.opened || !RocksDBStdSessions.this.opened();
        }

        public void reset() {
            this.batch = new WriteBatch();
        }

        public boolean hasChanges() {
            return this.batch.count() > 0;
        }

        @Override
        public String dataPath() {
            return RocksDBStdSessions.this.dataPath;
        }

        @Override
        public String walPath() {
            return RocksDBStdSessions.this.walPath;
        }

        @Override
        public String property(String table, String property) {
            OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);
            try {
                String string = RocksDBStdSessions.this.rocksdb().getProperty(cf.get(), property);
                if (cf != null) {
                    cf.close();
                }
                return string;
            }
            catch (Throwable throwable) {
                try {
                    if (cf != null) {
                        try {
                            cf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new BackendException((Throwable)e);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Pair<byte[], byte[]> keyRange(String table) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);
                 RocksIterator iter = RocksDBStdSessions.this.rocksdb().newIterator(cf.get());){
                iter.seekToFirst();
                if (!iter.isValid()) {
                    Pair<byte[], byte[]> pair = null;
                    return pair;
                }
                byte[] startKey = iter.key();
                iter.seekToLast();
                if (!iter.isValid()) {
                    Pair pair = Pair.of((Object)startKey, null);
                    return pair;
                }
                byte[] endKey = iter.key();
                return Pair.of((Object)startKey, (Object)endKey);
            }
        }

        @Override
        public void compactRange(String table) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                RocksDBStdSessions.this.rocksdb().compactRange(cf.get());
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        public Integer commit() {
            int count = this.batch.count();
            if (count <= 0) {
                return 0;
            }
            try {
                RocksDBStdSessions.this.rocksdb().write(this.writeOptions, this.batch);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
            this.batch.clear();
            return count;
        }

        public void rollback() {
            this.batch.clear();
        }

        @Override
        public void put(String table, byte[] key, byte[] value) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                this.batch.put(cf.get(), key, value);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public void merge(String table, byte[] key, byte[] value) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                this.batch.merge(cf.get(), key, value);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public void increase(String table, byte[] key, byte[] value) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                RocksDBStdSessions.this.rocksdb().merge(cf.get(), key, value);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public void delete(String table, byte[] key) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                this.batch.delete(cf.get(), key);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public void deleteSingle(String table, byte[] key) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                this.batch.singleDelete(cf.get(), key);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public void deletePrefix(String table, byte[] keyFrom) {
            byte[] keyTo = Arrays.copyOf(keyFrom, keyFrom.length);
            BinarySerializer.increaseOne((byte[])keyTo);
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                this.batch.deleteRange(cf.get(), keyFrom, keyTo);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public void deleteRange(String table, byte[] keyFrom, byte[] keyTo) {
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                this.batch.deleteRange(cf.get(), keyFrom, keyTo);
            }
            catch (RocksDBException e) {
                throw new BackendException((Throwable)e);
            }
        }

        @Override
        public byte[] get(String table, byte[] key) {
            assert (!this.hasChanges());
            OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);
            try {
                byte[] byArray = RocksDBStdSessions.this.rocksdb().get(cf.get(), key);
                if (cf != null) {
                    cf.close();
                }
                return byArray;
            }
            catch (Throwable throwable) {
                try {
                    if (cf != null) {
                        try {
                            cf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new BackendException((Throwable)e);
                }
            }
        }

        @Override
        public BackendEntry.BackendColumnIterator get(String table, List<byte[]> keys) {
            assert (!this.hasChanges());
            OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);
            try {
                ArrayList<ColumnFamilyHandle> cfs = new ArrayList<ColumnFamilyHandle>(keys.size());
                ColumnFamilyHandle cfh = cf.get();
                for (int i = 0; i < keys.size(); ++i) {
                    cfs.add(cfh);
                }
                List values = RocksDBStdSessions.this.rocksdb().multiGetAsList(cfs, keys);
                MgetIterator mgetIterator = new MgetIterator(keys, values);
                if (cf != null) {
                    cf.close();
                }
                return mgetIterator;
            }
            catch (Throwable throwable) {
                try {
                    if (cf != null) {
                        try {
                            cf.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RocksDBException e) {
                    throw new BackendException((Throwable)e);
                }
            }
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table) {
            assert (!this.hasChanges());
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                RocksDBIteratorPool.ReusedRocksIterator iter = cf.newIterator();
                ScanIterator scanIterator = new ScanIterator(table, iter, null, null, 128);
                return scanIterator;
            }
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] prefix) {
            assert (!this.hasChanges());
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                RocksDBIteratorPool.ReusedRocksIterator iter = cf.newIterator();
                ScanIterator scanIterator = new ScanIterator(table, iter, prefix, null, 1);
                return scanIterator;
            }
        }

        @Override
        public BackendEntry.BackendColumnIterator scan(String table, byte[] keyFrom, byte[] keyTo, int scanType) {
            assert (!this.hasChanges());
            try (OpenedRocksDB.CFHandle cf = RocksDBStdSessions.this.cf(table);){
                RocksDBIteratorPool.ReusedRocksIterator iter = cf.newIterator();
                ScanIterator scanIterator = new ScanIterator(table, iter, keyFrom, keyTo, scanType);
                return scanIterator;
            }
        }
    }
}

