/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SafeDateUtil {
    private static final Object LOCK = new Object();
    private static final Map<String, ThreadLocal<SimpleDateFormat>> simpleDateFormats = new HashMap<String, ThreadLocal<SimpleDateFormat>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SimpleDateFormat getSdf(String pattern) {
        ThreadLocal<SimpleDateFormat> tl = simpleDateFormats.get(pattern);
        if (tl == null) {
            Object object = LOCK;
            synchronized (object) {
                tl = simpleDateFormats.get(pattern);
                if (tl == null) {
                    tl = ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));
                    simpleDateFormats.put(pattern, tl);
                }
            }
        }
        return tl.get();
    }

    public static String format(Date date, String pattern) {
        return SafeDateUtil.getSdf(pattern).format(date);
    }

    public static Date parse(String dateStr, String pattern) throws ParseException {
        return SafeDateUtil.getSdf(pattern).parse(dateStr);
    }
}

