/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.schema.builder;

import java.util.Set;
import java.util.function.Function;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.tx.ISchemaTransaction;
import org.apache.hugegraph.exception.ExistedException;
import org.apache.hugegraph.schema.EdgeLabel;
import org.apache.hugegraph.schema.IndexLabel;
import org.apache.hugegraph.schema.PropertyKey;
import org.apache.hugegraph.schema.SchemaElement;
import org.apache.hugegraph.schema.VertexLabel;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.GraphMode;
import org.apache.hugegraph.type.define.SchemaStatus;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.LockUtil;

public abstract class AbstractBuilder {
    private final ISchemaTransaction transaction;
    private final HugeGraph graph;

    public AbstractBuilder(ISchemaTransaction transaction, HugeGraph graph) {
        E.checkNotNull((Object)transaction, (String)"transaction");
        E.checkNotNull((Object)graph, (String)"graph");
        this.transaction = transaction;
        this.graph = graph;
    }

    protected HugeGraph graph() {
        return this.graph;
    }

    protected Id validOrGenerateId(HugeType type, Id id, String name) {
        return this.transaction.validOrGenerateId(type, id, name);
    }

    protected void checkSchemaName(String name) {
        this.transaction.checkSchemaName(name);
    }

    protected Id rebuildIndex(IndexLabel indexLabel, Set<Id> dependencies) {
        return this.transaction.rebuildIndex(indexLabel, dependencies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <V> V lockCheckAndCreateSchema(HugeType type, String name, Function<String, V> callback) {
        String spaceGraph = this.graph.spaceGraphName();
        LockUtil.Locks locks = new LockUtil.Locks(spaceGraph);
        try {
            locks.lockWrites(LockUtil.hugeType2Group(type), IdGenerator.of(name));
            V v = callback.apply(name);
            return v;
        }
        finally {
            locks.unlock();
        }
    }

    protected void updateSchemaStatus(SchemaElement element, SchemaStatus status) {
        this.transaction.updateSchemaStatus(element, status);
    }

    protected void checkSchemaIdIfRestoringMode(HugeType type, Id id) {
        if (this.transaction.graphMode() == GraphMode.RESTORING) {
            E.checkArgument((id != null ? 1 : 0) != 0, (String)"Must provide schema id if in RESTORING mode", (Object[])new Object[0]);
            if (this.transaction.existsSchemaId(type, id)) {
                throw new ExistedException(type.readableName() + " id", (Object)id);
            }
        }
    }

    protected PropertyKey propertyKeyOrNull(String name) {
        return this.transaction.getPropertyKey(name);
    }

    protected VertexLabel vertexLabelOrNull(String name) {
        return this.transaction.getVertexLabel(name);
    }

    protected EdgeLabel edgeLabelOrNull(String name) {
        return this.transaction.getEdgeLabel(name);
    }

    protected IndexLabel indexLabelOrNull(String name) {
        return this.transaction.getIndexLabel(name);
    }
}

