/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.memory.consumer.impl.id;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.memory.consumer.OffHeapObject;
import org.apache.hugegraph.memory.pool.MemoryPool;
import org.apache.hugegraph.memory.util.FurySerializationUtil;

public class ObjectIdOffHeap
extends IdGenerator.ObjectId
implements OffHeapObject {
    private ByteBuf objectOffHeap;

    public ObjectIdOffHeap(MemoryPool memoryPool, Object object) {
        super(object);
        this.serializeSelfToByteBuf(memoryPool);
        this.releaseOriginalVarsOnHeap();
        memoryPool.bindMemoryConsumer(this);
    }

    @Override
    public Object zeroCopyReadFromByteBuf() {
        return new IdGenerator.ObjectId(FurySerializationUtil.FURY.deserialize(ByteBufUtil.getBytes((ByteBuf)this.objectOffHeap)));
    }

    @Override
    public void serializeSelfToByteBuf(MemoryPool memoryPool) {
        byte[] bytes = FurySerializationUtil.FURY.serialize(this.object);
        this.objectOffHeap = (ByteBuf)memoryPool.requireMemory(bytes.length, memoryPool);
        this.objectOffHeap.markReaderIndex();
        this.objectOffHeap.writeBytes(bytes);
    }

    @Override
    public void releaseOriginalVarsOnHeap() {
        this.object = null;
    }

    @Override
    public List<ByteBuf> getAllMemoryBlock() {
        return Collections.singletonList(this.objectOffHeap);
    }

    @Override
    public Object asObject() {
        return FurySerializationUtil.FURY.deserialize(ByteBufUtil.getBytes((ByteBuf)this.objectOffHeap));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.objectOffHeap);
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ObjectIdOffHeap)) {
            return false;
        }
        return this.objectOffHeap.equals((Object)((ObjectIdOffHeap)other).objectOffHeap);
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

