/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.hugegraph.HugeGraphParams;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.store.BackendStoreProvider;
import org.apache.hugegraph.backend.store.memory.InMemoryDBStoreProvider;
import org.apache.hugegraph.backend.store.raft.RaftBackendStoreProvider;
import org.apache.hugegraph.config.CoreOptions;
import org.apache.hugegraph.config.HugeConfig;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class BackendProviderFactory {
    private static final Logger LOG = Log.logger(BackendProviderFactory.class);
    private static final Map<String, Class<? extends BackendStoreProvider>> providers;
    private static final List<String> ALLOWED_BACKENDS;

    public static BackendStoreProvider open(HugeGraphParams params) {
        HugeConfig config = params.configuration();
        String backend = ((String)config.get(CoreOptions.BACKEND)).toLowerCase();
        BackendException.check(!StringUtils.isEmpty((CharSequence)params.graph().graphSpace()), "GraphSpace can not be empty for '%s'", config.get(CoreOptions.STORE));
        String graph = params.graph().graphSpace() + "/" + (String)config.get(CoreOptions.STORE);
        boolean raftMode = (Boolean)config.get(CoreOptions.RAFT_MODE);
        BackendStoreProvider provider = BackendProviderFactory.newProvider(config);
        if (raftMode) {
            LOG.info("Opening backend store '{}' in raft mode for graph '{}'", (Object)backend, (Object)graph);
            provider = new RaftBackendStoreProvider(params, provider);
        }
        provider.open(graph);
        return provider;
    }

    private static BackendStoreProvider newProvider(HugeConfig config) {
        BackendStoreProvider instance;
        String backend = ((String)config.get(CoreOptions.BACKEND)).toLowerCase();
        E.checkState((boolean)ALLOWED_BACKENDS.contains(backend.toLowerCase()), (String)"backend is illegal: %s", (Object[])new Object[]{backend});
        String graph = (String)config.get(CoreOptions.STORE);
        if (InMemoryDBStoreProvider.matchType(backend)) {
            return InMemoryDBStoreProvider.instance(graph);
        }
        Class<? extends BackendStoreProvider> clazz = providers.get(backend);
        BackendException.check(clazz != null, "Not exists BackendStoreProvider: %s", backend);
        assert (BackendStoreProvider.class.isAssignableFrom(clazz));
        try {
            instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        BackendException.check(backend.equals(instance.type()), "BackendStoreProvider with type '%s' can't be opened by key '%s'", instance.type(), backend);
        return instance;
    }

    public static void register(String name, String classPath) {
        Class<?> clazz;
        ClassLoader classLoader = BackendProviderFactory.class.getClassLoader();
        try {
            clazz = classLoader.loadClass(classPath);
        }
        catch (Exception e) {
            throw new BackendException(e);
        }
        boolean subclass = BackendStoreProvider.class.isAssignableFrom(clazz);
        BackendException.check(subclass, "Class '%s' is not a subclass of class BackendStoreProvider", classPath);
        BackendException.check(!providers.containsKey(name), "Exists BackendStoreProvider: %s (%s)", name, providers.get(name));
        providers.put(name, clazz);
    }

    static {
        ALLOWED_BACKENDS = List.of("memory", "rocksdb", "hbase", "hstore");
        providers = new ConcurrentHashMap<String, Class<? extends BackendStoreProvider>>();
    }
}

