/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.pd.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.hugegraph.pd.util.DefaultThreadFactory;

public class Cache<T>
implements Closeable {
    ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor(new DefaultThreadFactory("hg-cache"));
    private ConcurrentMap<String, CacheValue> map = new ConcurrentHashMap<String, CacheValue>();
    private ScheduledFuture<?> future;
    private Runnable checker = () -> {
        for (Map.Entry e : this.map.entrySet()) {
            if (((CacheValue)e.getValue()).getValue() != null) continue;
            this.map.remove(e.getKey());
        }
    };

    public Cache() {
        this.future = this.ex.scheduleWithFixedDelay(this.checker, 1L, 1L, TimeUnit.SECONDS);
    }

    public CacheValue put(String key, T value, long ttl) {
        return this.map.put(key, new CacheValue(value, ttl));
    }

    public T get(String key) {
        CacheValue value = (CacheValue)this.map.get(key);
        if (value == null) {
            return null;
        }
        Object t = value.getValue();
        if (t == null) {
            this.map.remove(key);
        }
        return t;
    }

    public boolean keepAlive(String key, long ttl) {
        CacheValue value = (CacheValue)this.map.get(key);
        if (value == null) {
            return false;
        }
        value.keepAlive(ttl);
        return true;
    }

    @Override
    public void close() throws IOException {
        try {
            this.future.cancel(true);
            this.ex.shutdownNow();
        }
        catch (Exception e) {
            try {
                this.ex.shutdownNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class CacheValue {
        private final T value;
        long outTime;

        protected CacheValue(T value, long ttl) {
            this.value = value;
            this.outTime = System.currentTimeMillis() + ttl;
        }

        protected T getValue() {
            if (System.currentTimeMillis() >= this.outTime) {
                return null;
            }
            return this.value;
        }

        protected void keepAlive(long ttl) {
            this.outTime = System.currentTimeMillis() + ttl;
        }
    }
}

