/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.vector;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apdplat.word.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Word2Vector {
    private static final Logger LOGGER = LoggerFactory.getLogger(Word2Vector.class);

    public static void main(String[] stringArray) {
        String string = "data/word.txt";
        String string2 = "data/vector.txt";
        String string3 = "data/vocabulary.txt";
        int n = 2;
        int n2 = 30;
        if (stringArray.length == 3) {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
        }
        if (stringArray.length == 5) {
            string = stringArray[0];
            string2 = stringArray[1];
            string3 = stringArray[2];
            n = Integer.parseInt(stringArray[3]);
            n2 = Integer.parseInt(stringArray[4]);
        }
        long l = System.currentTimeMillis();
        Word2Vector.word2Vec(string, string2, string3, n, n2);
        long l2 = System.currentTimeMillis() - l;
        LOGGER.info("cost time:" + l2 + " ms");
    }

    private static void word2Vec(String string, String string2, String string3, int n, int n2) {
        Object object;
        File file;
        float f = (float)Runtime.getRuntime().maxMemory() / 1000000.0f;
        float f2 = (float)Runtime.getRuntime().totalMemory() / 1000000.0f;
        float f3 = (float)Runtime.getRuntime().freeMemory() / 1000000.0f;
        String string4 = "\u6267\u884c\u4e4b\u524d\u5269\u4f59\u5185\u5b58:" + f + "-" + f2 + "+" + f3 + "=" + (f - f2 + f3);
        File file2 = new File(string2);
        if (!file2.getParentFile().exists()) {
            file2.getParentFile().mkdirs();
        }
        if (!(file = new File(string3)).getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            object = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "utf-8"));
            Throwable throwable = null;
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file2), "utf-8"));
                 BufferedWriter bufferedWriter2 = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));){
                int n3 = 0;
                long l = System.currentTimeMillis();
                LOGGER.info("1\u3001\u5f00\u59cb\u8ba1\u7b97\u76f8\u5173\u8bcd");
                LOGGER.info("\u4e0a\u4e0b\u6587\u7a97\u53e3\uff1a" + n);
                HashMap<String, List<ContextWord>> hashMap = new HashMap<String, List<ContextWord>>();
                HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
                String string5 = null;
                while ((string5 = ((BufferedReader)object).readLine()) != null) {
                    n3 += string5.length();
                    Word2Vector.word2Vec(hashMap, hashMap2, string5, n);
                }
                long l2 = System.currentTimeMillis() - l;
                LOGGER.info("\u8ba1\u7b97\u5b8c\u6bd5\uff0c\u901f\u5ea6\uff1a" + (long)n3 / l2 + " \u5b57\u7b26/\u6beb\u79d2\uff0c\u8017\u65f6\uff1a" + l2 / 1000L + " \u79d2\uff0c\u6570\u636e\u5927\u5c0f\uff1a" + hashMap.size() + "\uff0c\u8bcd\u5927\u5c0f\uff1a" + hashMap2.size());
                LOGGER.info("2\u3001\u5f00\u59cb\u6574\u7406\u6570\u636e\uff0c\u5f52\u4e00\u5316\u3001\u6392\u5e8f\u3001\u622a\u53d6TOPN");
                LOGGER.info("\u5411\u91cf\u957f\u5ea6\uff1a" + n2);
                l = System.currentTimeMillis();
                Word2Vector.normalize(hashMap, hashMap2, n2);
                LOGGER.info("\u5904\u7406\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) / 1000L + " \u79d2\uff0c\u6570\u636e\u5927\u5c0f\uff1a" + hashMap.size());
                LOGGER.info("3\u3001\u5f00\u59cb\u8f93\u51fa\u7ed3\u679c");
                l = System.currentTimeMillis();
                ArrayList<String> arrayList = new ArrayList<String>();
                for (Map.Entry iterator2 : hashMap.entrySet()) {
                    arrayList.add((String)iterator2.getKey() + " : " + ((List)iterator2.getValue()).toString());
                }
                Collections.sort(arrayList);
                for (String string6 : arrayList) {
                    bufferedWriter.write(string6 + "\n");
                }
                arrayList.clear();
                List list = hashMap2.entrySet().parallelStream().sorted((entry, entry2) -> ((Integer)entry2.getValue()).compareTo((Integer)entry.getValue())).collect(Collectors.toList());
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry3 = (Map.Entry)iterator.next();
                    bufferedWriter2.write((String)entry3.getKey() + " " + entry3.getValue() + "\n");
                }
                LOGGER.info("\u8f93\u51fa\u5b8c\u6bd5\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - l) / 1000L + " \u79d2\uff0c\u6570\u636e\u9879\uff1a" + arrayList.size());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((BufferedReader)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((BufferedReader)object).close();
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u64cd\u4f5c\u9519\u8bef", (Throwable)exception);
        }
        f = (float)Runtime.getRuntime().maxMemory() / 1000000.0f;
        f2 = (float)Runtime.getRuntime().totalMemory() / 1000000.0f;
        f3 = (float)Runtime.getRuntime().freeMemory() / 1000000.0f;
        object = "\u6267\u884c\u4e4b\u540e\u5269\u4f59\u5185\u5b58:" + f + "-" + f2 + "+" + f3 + "=" + (f - f2 + f3);
        LOGGER.info(string4);
        LOGGER.info((String)object);
    }

    private static void word2Vec(Map<String, List<ContextWord>> map, Map<String, Integer> map2, String string, int n) {
        String[] stringArray = string.split(" ");
        if (stringArray.length > 10000) {
            LOGGER.info("\u884c\u5927\u5c0f\uff1a" + stringArray.length);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            if (i > 0 && i % 10000 == 0) {
                LOGGER.info("\u884c\u5904\u7406\u8fdb\u5ea6: " + (float)i / (float)stringArray.length * 100.0f + " %");
            }
            if (!Utils.isChineseCharAndLengthAtLeastTwo(string2 = stringArray[i])) continue;
            Integer n2 = map2.get(string2);
            if (n2 == null) {
                n2 = 1;
            } else {
                Integer n3 = n2;
                Integer n4 = n2 = Integer.valueOf(n2 + 1);
            }
            map2.put(string2, n2);
            for (int j = 1; j <= n; ++j) {
                int n5 = i - j;
                Word2Vector.contextWord(stringArray, n5, j, string2, map);
                n5 = i + j;
                Word2Vector.contextWord(stringArray, n5, j, string2, map);
            }
        }
    }

    private static void contextWord(String[] stringArray, int n, int n2, String string, Map<String, List<ContextWord>> map) {
        String string2 = null;
        if (n > -1 && n < stringArray.length) {
            string2 = stringArray[n];
        }
        if (string2 != null && Utils.isChineseCharAndLengthAtLeastTwo(string2)) {
            Word2Vector.addToMap(map, string, string2, n2);
        }
    }

    private static void addToMap(Map<String, List<ContextWord>> map, String string, String string2, int n) {
        List<ContextWord> list = map.get(string);
        if (list == null) {
            list = new ArrayList<ContextWord>();
            map.put(string, list);
        }
        float f = 1.0f / (float)n;
        boolean bl = false;
        for (ContextWord contextWord : list) {
            if (!contextWord.getWord().equals(string2)) continue;
            float f2 = contextWord.getScore() + f;
            contextWord.setScore(f2);
            bl = true;
            break;
        }
        if (!bl) {
            ContextWord contextWord = new ContextWord(string2, Float.valueOf(f));
            list.add(contextWord);
        }
    }

    private static void normalize(Map<String, List<ContextWord>> map, Map<String, Integer> map2, int n) {
        for (String string : map.keySet()) {
            List<ContextWord> list = map.get(string);
            float f = 0.0f;
            for (ContextWord contextWord : list) {
                if (!(contextWord.getScore() > f)) continue;
                f = contextWord.getScore();
            }
            for (ContextWord contextWord : list) {
                contextWord.setScore(contextWord.getScore() / f);
            }
            Collections.sort(list);
            int n2 = list.size();
            if (n2 > n) {
                list = list.subList(0, n);
            }
            map.put(string, list);
        }
    }

    private static class ContextWord
    implements Comparable {
        private String word;
        private float score;

        public ContextWord(String string, Float f) {
            this.word = string;
            this.score = f.floatValue();
        }

        public String toString() {
            return this.word + " " + this.score;
        }

        public String getWord() {
            return this.word;
        }

        public void setWord(String string) {
            this.word = string;
        }

        public float getScore() {
            return this.score;
        }

        public void setScore(float f) {
            this.score = f;
        }

        public int compareTo(Object object) {
            float f = ((ContextWord)object).getScore();
            if (this.getScore() < f) {
                return 1;
            }
            if (this.getScore() == f) {
                return 0;
            }
            return -1;
        }
    }
}

