/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apdplat.word.util.DoubleArrayGenericTrie;
import org.apdplat.word.util.GenericTrie;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrieTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(TrieTest.class);

    public static void testBigram() throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Stream<String> stream = Files.lines(Paths.get("src/test/resources/bigram.txt", new String[0]));
        stream.forEach(string -> {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null && stringArray.length == 2) {
                hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
            }
        });
        DoubleArrayGenericTrie doubleArrayGenericTrie = new DoubleArrayGenericTrie(WordConfTools.getInt("bigram.double.array.trie.size", 5500000));
        doubleArrayGenericTrie.putAll(hashMap);
        hashMap.keySet().forEach(string -> TrieTest.assertEquals((Integer)hashMap.get(string), doubleArrayGenericTrie.get((String)string)));
        for (int i = 0; i < 1000; ++i) {
            hashMap.keySet().forEach(string -> doubleArrayGenericTrie.get((String)string));
        }
    }

    public static void testTrigram() throws Exception {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        Stream<String> stream = Files.lines(Paths.get("src/test/resources/trigram.txt", new String[0]));
        stream.forEach(string -> {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null && stringArray.length == 2) {
                hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
            }
        });
        DoubleArrayGenericTrie doubleArrayGenericTrie = new DoubleArrayGenericTrie(WordConfTools.getInt("trigram.double.array.trie.size", 10100000));
        doubleArrayGenericTrie.putAll(hashMap);
        hashMap.keySet().forEach(string -> TrieTest.assertEquals((Integer)hashMap.get(string), doubleArrayGenericTrie.get((String)string)));
        for (int i = 0; i < 1000; ++i) {
            hashMap.keySet().forEach(string -> doubleArrayGenericTrie.get((String)string));
        }
    }

    public static void testBigram2() throws Exception {
        GenericTrie genericTrie = new GenericTrie();
        HashMap hashMap = new HashMap();
        Stream<String> stream = Files.lines(Paths.get("src/test/resources/bigram.txt", new String[0]));
        stream.forEach(string -> {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null && stringArray.length == 2) {
                hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
                genericTrie.put(stringArray[0], hashMap.get(stringArray[0]));
            }
        });
        hashMap.keySet().forEach(string -> TrieTest.assertEquals((Integer)hashMap.get(string), (Integer)genericTrie.get((String)string)));
        for (int i = 0; i < 1000; ++i) {
            hashMap.keySet().forEach(string -> {
                Integer cfr_ignored_0 = (Integer)genericTrie.get((String)string);
            });
        }
    }

    public static void testTrigram2() throws Exception {
        GenericTrie genericTrie = new GenericTrie();
        HashMap hashMap = new HashMap();
        Stream<String> stream = Files.lines(Paths.get("src/test/resources/trigram.txt", new String[0]));
        stream.forEach(string -> {
            String[] stringArray = string.split("\\s+");
            if (stringArray != null && stringArray.length == 2) {
                hashMap.put(stringArray[0], Integer.parseInt(stringArray[1]));
                genericTrie.put(stringArray[0], hashMap.get(stringArray[0]));
            }
        });
        hashMap.keySet().forEach(string -> TrieTest.assertEquals((Integer)hashMap.get(string), (Integer)genericTrie.get((String)string)));
        for (int i = 0; i < 1000; ++i) {
            hashMap.keySet().forEach(string -> {
                Integer cfr_ignored_0 = (Integer)genericTrie.get((String)string);
            });
        }
    }

    private static void assertEquals(int n, int n2) {
        if (n != n2) {
            throw new RuntimeException(n + " not equals " + n2);
        }
    }

    private static void test(String string, String string2) throws Exception {
        System.gc();
        Thread.sleep(60000L);
        long l = System.currentTimeMillis();
        if ("bigram".equals(string)) {
            if ("dat".equals(string2)) {
                TrieTest.testBigram();
            }
            if ("t".equals(string2)) {
                TrieTest.testBigram2();
            }
        }
        if ("trigram".equals(string)) {
            if ("dat".equals(string2)) {
                TrieTest.testTrigram();
            }
            if ("t".equals(string2)) {
                TrieTest.testTrigram2();
            }
        }
        long l2 = System.currentTimeMillis() - l;
        LOGGER.info(string + ":" + string2 + " \u8017\u65f6\uff1a" + l2 + " \u6beb\u79d2");
        System.gc();
        Thread.sleep(60000L);
        LOGGER.info("test finish");
        System.exit(0);
    }

    public static void main(String[] stringArray) throws Exception {
        TrieTest.test("bigram", "t");
    }
}

