/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.apdplat.word.util.DirectoryWatcher;
import org.apdplat.word.util.ResourceLoader;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.JedisPubSub;

public class AutoDetector {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoDetector.class);
    private static final Set<String> FILE_WATCHERS = new HashSet<String>();
    private static final Set<String> HTTP_WATCHERS = new HashSet<String>();
    private static final Map<DirectoryWatcher, String> RESOURCES = new HashMap<DirectoryWatcher, String>();
    private static final Map<DirectoryWatcher, ResourceLoader> RESOURCE_LOADERS = new HashMap<DirectoryWatcher, ResourceLoader>();
    private static final Map<DirectoryWatcher.WatcherCallback, DirectoryWatcher> WATCHER_CALLBACKS = new HashMap<DirectoryWatcher.WatcherCallback, DirectoryWatcher>();

    public static void loadAndWatch(ResourceLoader resourceLoader, String string) {
        if ("".equals(string = string.trim())) {
            LOGGER.info("\u6ca1\u6709\u8d44\u6e90\u53ef\u4ee5\u52a0\u8f7d");
            return;
        }
        LOGGER.info("\u5f00\u59cb\u52a0\u8f7d\u8d44\u6e90");
        LOGGER.info(string);
        long l = System.currentTimeMillis();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split("[,\uff0c]")) {
            try {
                string2 = string2.trim();
                if (string2.startsWith("classpath:")) {
                    arrayList.addAll(AutoDetector.loadClasspathResource(string2.replace("classpath:", ""), resourceLoader, string));
                    continue;
                }
                if (string2.startsWith("http:")) {
                    arrayList.addAll(AutoDetector.loadHttpResource(string2, resourceLoader));
                    continue;
                }
                arrayList.addAll(AutoDetector.loadNoneClasspathResource(string2, resourceLoader, string));
            }
            catch (Exception exception) {
                LOGGER.error("\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25\uff1a" + string2, (Throwable)exception);
            }
        }
        LOGGER.info("\u52a0\u8f7d\u8d44\u6e90 " + arrayList.size() + " \u884c");
        resourceLoader.clear();
        resourceLoader.load(arrayList);
        long l2 = System.currentTimeMillis() - l;
        LOGGER.info("\u5b8c\u6210\u52a0\u8f7d\u8d44\u6e90\uff0c\u8017\u65f6" + l2 + " \u6beb\u79d2");
    }

    private static List<String> loadClasspathResource(String string, ResourceLoader resourceLoader, String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        LOGGER.info("\u7c7b\u8def\u5f84\u8d44\u6e90\uff1a" + string);
        Enumeration<URL> enumeration = AutoDetector.class.getClassLoader().getResources(string);
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            LOGGER.info("\u7c7b\u8def\u5f84\u8d44\u6e90URL\uff1a" + uRL);
            if (uRL.getFile().contains(".jar!")) {
                arrayList.addAll(AutoDetector.load("classpath:" + string));
                continue;
            }
            File file = new File(uRL.getFile());
            boolean bl = file.isDirectory();
            if (bl) {
                arrayList.addAll(AutoDetector.loadAndWatchDir(file.toPath(), resourceLoader, string2));
                continue;
            }
            arrayList.addAll(AutoDetector.load(file.getAbsolutePath()));
            AutoDetector.watchFile(file, resourceLoader, string2);
        }
        return arrayList;
    }

    private static List<String> loadHttpResource(String string, ResourceLoader resourceLoader) throws MalformedURLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new URL(string).openConnection().getInputStream(), "utf-8"));){
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                if ("".equals(string2 = string2.trim()) || string2.startsWith("#")) continue;
                arrayList.add(string2);
            }
        }
        AutoDetector.watchHttp(string, resourceLoader);
        return arrayList;
    }

    private static void watchHttp(String string, final ResourceLoader resourceLoader) {
        String[] stringArray = string.split("/");
        final String string2 = stringArray[stringArray.length - 1];
        if (HTTP_WATCHERS.contains(string2)) {
            return;
        }
        HTTP_WATCHERS.add(string2);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                String string = WordConfTools.get("redis.host", "localhost");
                int n = WordConfTools.getInt("redis.port", 6379);
                String string22 = string2 + ".add";
                String string3 = string2 + ".remove";
                LOGGER.info("redis\u670d\u52a1\u5668\u914d\u7f6e\u4fe1\u606f host:" + string + ",port:" + n + ",channels:[" + string22 + "," + string3 + "]");
                while (true) {
                    try {
                        JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), string, n);
                        Jedis jedis = jedisPool.getResource();
                        LOGGER.info("redis\u5b88\u62a4\u7ebf\u7a0b\u542f\u52a8");
                        jedis.subscribe((JedisPubSub)new HttpResourceChangeRedisListener(resourceLoader), new String[]{string22, string3});
                        jedisPool.returnResource(jedis);
                        LOGGER.info("redis\u5b88\u62a4\u7ebf\u7a0b\u7ed3\u675f");
                    }
                    catch (Exception exception) {
                        LOGGER.info("redis\u672a\u542f\u52a8\uff0c\u6682\u505c\u4e00\u5206\u949f\u540e\u91cd\u65b0\u8fde\u63a5");
                        try {
                            Thread.sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            LOGGER.error(interruptedException.getMessage(), (Throwable)interruptedException);
                        }
                        continue;
                    }
                    break;
                }
            }
        });
        thread.setDaemon(true);
        thread.setName("redis\u5b88\u62a4\u7ebf\u7a0b\uff0c\u7528\u4e8e\u52a8\u6001\u76d1\u63a7\u8d44\u6e90\uff1a" + string2);
        thread.start();
    }

    private static List<String> loadNoneClasspathResource(String string, ResourceLoader resourceLoader, String string2) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Path path = Paths.get(string, new String[0]);
        boolean bl = Files.exists(path, new LinkOption[0]);
        if (!bl) {
            LOGGER.error("\u8d44\u6e90\u4e0d\u5b58\u5728\uff1a" + string);
            return arrayList;
        }
        boolean bl2 = Files.isDirectory(path, new LinkOption[0]);
        if (bl2) {
            arrayList.addAll(AutoDetector.loadAndWatchDir(path, resourceLoader, string2));
        } else {
            arrayList.addAll(AutoDetector.load(string));
            AutoDetector.watchFile(path.toFile(), resourceLoader, string2);
        }
        return arrayList;
    }

    private static List<String> loadAndWatchDir(Path path, ResourceLoader resourceLoader, String string) {
        final ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                    arrayList.addAll(AutoDetector.load(path.toAbsolutePath().toString()));
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            LOGGER.error("\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25\uff1a" + path, (Throwable)iOException);
        }
        if (FILE_WATCHERS.contains(path.toString())) {
            return arrayList;
        }
        FILE_WATCHERS.add(path.toString());
        DirectoryWatcher.WatcherCallback watcherCallback = new DirectoryWatcher.WatcherCallback(){
            private long lastExecute = System.currentTimeMillis();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute(WatchEvent.Kind<?> kind, String string) {
                if (System.currentTimeMillis() - this.lastExecute <= 1000L) return;
                this.lastExecute = System.currentTimeMillis();
                LOGGER.info("\u4e8b\u4ef6\uff1a" + kind.name() + " ,\u8def\u5f84\uff1a" + string);
                Class<AutoDetector> clazz = AutoDetector.class;
                synchronized (AutoDetector.class) {
                    DirectoryWatcher directoryWatcher = (DirectoryWatcher)WATCHER_CALLBACKS.get(this);
                    String string2 = (String)RESOURCES.get(directoryWatcher);
                    ResourceLoader resourceLoader = (ResourceLoader)RESOURCE_LOADERS.get(directoryWatcher);
                    LOGGER.info("\u91cd\u65b0\u52a0\u8f7d\u6570\u636e");
                    AutoDetector.loadAndWatch(resourceLoader, string2);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        DirectoryWatcher directoryWatcher = DirectoryWatcher.getDirectoryWatcher(watcherCallback, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        directoryWatcher.watchDirectoryTree(path);
        WATCHER_CALLBACKS.put(watcherCallback, directoryWatcher);
        RESOURCES.put(directoryWatcher, string);
        RESOURCE_LOADERS.put(directoryWatcher, resourceLoader);
        return arrayList;
    }

    private static List<String> load(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            InputStream inputStream = null;
            LOGGER.info("\u52a0\u8f7d\u8d44\u6e90\uff1a" + string);
            inputStream = string.startsWith("classpath:") ? AutoDetector.class.getClassLoader().getResourceAsStream(string.replace("classpath:", "")) : new FileInputStream(string);
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if ("".equals(string2 = string2.trim()) || string2.startsWith("#")) continue;
                    arrayList.add(string2);
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("\u52a0\u8f7d\u8d44\u6e90\u5931\u8d25\uff1a" + string, (Throwable)exception);
        }
        return arrayList;
    }

    private static void watchFile(final File file, ResourceLoader resourceLoader, String string) {
        if (FILE_WATCHERS.contains(file.toString())) {
            return;
        }
        FILE_WATCHERS.add(file.toString());
        LOGGER.info("\u76d1\u63a7\u6587\u4ef6\uff1a" + file.toString());
        DirectoryWatcher.WatcherCallback watcherCallback = new DirectoryWatcher.WatcherCallback(){
            private long lastExecute = System.currentTimeMillis();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void execute(WatchEvent.Kind<?> kind, String string) {
                if (System.currentTimeMillis() - this.lastExecute <= 1000L) return;
                this.lastExecute = System.currentTimeMillis();
                if (!string.equals(file.toString())) {
                    return;
                }
                LOGGER.info("\u4e8b\u4ef6\uff1a" + kind.name() + " ,\u8def\u5f84\uff1a" + string);
                Class<AutoDetector> clazz = AutoDetector.class;
                synchronized (AutoDetector.class) {
                    DirectoryWatcher directoryWatcher = (DirectoryWatcher)WATCHER_CALLBACKS.get(this);
                    String string2 = (String)RESOURCES.get(directoryWatcher);
                    ResourceLoader resourceLoader = (ResourceLoader)RESOURCE_LOADERS.get(directoryWatcher);
                    LOGGER.info("\u91cd\u65b0\u52a0\u8f7d\u6570\u636e");
                    AutoDetector.loadAndWatch(resourceLoader, string2);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
        };
        DirectoryWatcher directoryWatcher = DirectoryWatcher.getDirectoryWatcher(watcherCallback, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        directoryWatcher.watchDirectory(file.getParent());
        WATCHER_CALLBACKS.put(watcherCallback, directoryWatcher);
        RESOURCES.put(directoryWatcher, string);
        RESOURCE_LOADERS.put(directoryWatcher, resourceLoader);
    }

    public static void main(String[] stringArray) {
        AutoDetector.loadAndWatch(new ResourceLoader(){

            @Override
            public void clear() {
                System.out.println("\u6e05\u7a7a\u8d44\u6e90");
            }

            @Override
            public void load(List<String> list) {
                for (String string : list) {
                    System.out.println(string);
                }
            }

            @Override
            public void add(String string) {
                System.out.println("add\uff1a" + string);
            }

            @Override
            public void remove(String string) {
                System.out.println("remove\uff1a" + string);
            }
        }, "d:/DIC, d:/DIC2, d:/dic.txt, classpath:dic2.txt,classpath:dic");
    }

    private static final class HttpResourceChangeRedisListener
    extends JedisPubSub {
        private ResourceLoader resourceLoader;

        public HttpResourceChangeRedisListener(ResourceLoader resourceLoader) {
            this.resourceLoader = resourceLoader;
        }

        public void onMessage(String string, String string2) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("onMessage channel:" + string + " and message:" + string2);
            }
            if (string.endsWith(".add")) {
                this.resourceLoader.add(string2);
            } else if (string.endsWith(".remove")) {
                this.resourceLoader.remove(string2);
            }
        }

        public void onPMessage(String string, String string2, String string3) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("pattern:" + string + " and channel:" + string2 + " and message:" + string3);
            }
            this.onMessage(string2, string3);
        }

        public void onPSubscribe(String string, int n) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("psubscribe pattern:" + string + " and subscribedChannels:" + n);
            }
        }

        public void onPUnsubscribe(String string, int n) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("punsubscribe pattern:" + string + " and subscribedChannels:" + n);
            }
        }

        public void onSubscribe(String string, int n) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("subscribe channel:" + string + " and subscribedChannels:" + n);
            }
        }

        public void onUnsubscribe(String string, int n) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("unsubscribe channel:" + string + " and subscribedChannels:" + n);
            }
        }
    }
}

