/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apdplat.word.recognition.RecognitionTool;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.segmentation.impl.AbstractSegmentation;

public class ReverseMinimumMatching
extends AbstractSegmentation {
    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.ReverseMinimumMatching;
    }

    @Override
    public List<Word> segImpl(String string) {
        Stack<Word> stack = new Stack<Word>();
        int n = string.length();
        int n2 = 1;
        for (int i = n - n2; i >= 0; --i) {
            while (!this.getDictionary().contains(string, i, n2) && !RecognitionTool.recog(string, i, n2)) {
                if (++n2 <= this.getInterceptLength() && --i >= 0) continue;
                i += n2 - 1;
                n2 = 1;
                break;
            }
            this.addWord(stack, string, i, n2);
            n2 = 1;
        }
        n2 = stack.size();
        ArrayList<Word> arrayList = new ArrayList<Word>(n2);
        for (int i = 0; i < n2; ++i) {
            arrayList.add(stack.pop());
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = "\u4ed6\u4e0d\u7ba1\u4e09\u4e03\u4e8c\u5341\u4e00\u5c31\u9a82\u5979\u662f\u4e8c\u767e\u4e94\uff0c\u6211\u5c31\u65e0\u8bed\u4e86\uff0c\u771f\u662f\u4e2a\u4e8c\u8d27\u3002\u4ed6\u8fd8\u95ee\u6211\uff1a\u201c\u6768\u8001\u5e08\uff0c\u2018\u4e8c\u8d27\u2019\u662f\u4ec0\u4e48\u610f\u601d\uff1f\u201d";
        if (stringArray != null && stringArray.length == 1) {
            string = stringArray[0];
        }
        ReverseMinimumMatching reverseMinimumMatching = new ReverseMinimumMatching();
        System.out.println(reverseMinimumMatching.seg(string).toString());
    }
}

