/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apdplat.word.segmentation.Segmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PureEnglish
implements Segmentation {
    private static final Logger LOGGER = LoggerFactory.getLogger(PureEnglish.class);
    private static final Pattern NUMBER = Pattern.compile("\\d+");
    private static final Pattern UNICODE = Pattern.compile("[uU][0-9a-fA-F]{4}");

    @Override
    public SegmentationAlgorithm getSegmentationAlgorithm() {
        return SegmentationAlgorithm.PureEnglish;
    }

    @Override
    public List<Word> seg(String string2) {
        String[] stringArray;
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (String string3 : stringArray = string2.trim().split("[^a-zA-Z0-9]")) {
            if ("".equals(string3) || string3.length() < 2) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (string3.length() < 6 || Character.isUpperCase(string3.charAt(string3.length() - 1)) && Character.isUpperCase(string3.charAt(0)) || NUMBER.matcher(string3).find() || this.isAllUpperCase(string3)) {
                string3 = string3.toLowerCase();
            }
            int n = 0;
            for (int i = 1; i < string3.length(); ++i) {
                if (!Character.isUpperCase(string3.charAt(i)) || !Character.isLowerCase(string3.charAt(i - 1))) continue;
                arrayList2.add(string3.substring(n, i));
                n = i;
            }
            if (n < string3.length()) {
                arrayList2.add(string3.substring(n, string3.length()));
            }
            arrayList2.stream().map(string -> string.toLowerCase()).forEach(string -> {
                if (string.length() < 2) {
                    return;
                }
                if ((string = PureEnglish.irregularity(string)) != null) {
                    arrayList.add(new Word((String)string));
                }
            });
        }
        return arrayList;
    }

    private static String irregularity(String string) {
        if (Character.isDigit(string.charAt(0))) {
            LOGGER.debug("\u8bcd\u4ee5\u6570\u5b57\u5f00\u5934\uff0c\u5ffd\u7565\uff1a" + string);
            return null;
        }
        if (string.startsWith("0x") || string.startsWith("0X")) {
            LOGGER.debug("\u8bcd\u4e3a16\u8fdb\u5236\uff0c\u5ffd\u7565\uff1a" + string);
            return null;
        }
        if (string.endsWith("l") && PureEnglish.isNumeric(string.substring(0, string.length() - 1))) {
            LOGGER.debug("\u8bcd\u4e3along\u7c7b\u578b\u6570\u5b57\uff0c\u5ffd\u7565\uff1a" + string);
            return null;
        }
        if (UNICODE.matcher(string).find()) {
            LOGGER.debug("\u8bcd\u4e3aUNICODE\u5b57\u7b26\u7f16\u7801\uff0c\u5ffd\u7565\uff1a" + string);
            return null;
        }
        switch (string) {
            case "ll": {
                return "will";
            }
            case "re": {
                return "are";
            }
            case "ch": {
                return "chapter";
            }
            case "ve": {
                return "have";
            }
            case "doesn": {
                return "does";
            }
            case "isn": {
                return "is";
            }
            case "br": {
                return null;
            }
        }
        return string;
    }

    private boolean isAllUpperCase(String string) {
        for (char c : string.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String string) {
        for (char c : string.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        PureEnglish pureEnglish = new PureEnglish();
        System.out.println(pureEnglish.seg("Your function may also be added permanently to Hive, however this requires a small modification to a Hive Java file and then rebuilding Hive."));
    }
}

