/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.recognition;

import org.apdplat.word.recognition.Quantifier;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecognitionTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecognitionTool.class);
    private static final boolean RECOGNITION_TOOL_ENABLED = WordConfTools.getBoolean("recognition.tool.enabled", true);
    private static final char[] chineseNumbers = new char[]{'\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341', '\u767e', '\u5343', '\u4e07', '\u4ebf', '\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396', '\u62fe', '\u4f70', '\u4edf', '\u3007'};

    public static boolean recog(String string) {
        return RecognitionTool.recog(string, 0, string.length());
    }

    public static boolean recog(String string, int n, int n2) {
        if (!RECOGNITION_TOOL_ENABLED) {
            return false;
        }
        return RecognitionTool.isEnglishAndNumberMix(string, n, n2) || RecognitionTool.isFraction(string, n, n2) || RecognitionTool.isQuantifier(string, n, n2) || RecognitionTool.isChineseNumber(string, n, n2);
    }

    public static boolean isFraction(String string) {
        return RecognitionTool.isFraction(string, 0, string.length());
    }

    public static boolean isFraction(String string, int n, int n2) {
        int n3;
        if (n2 < 3) {
            return false;
        }
        int n4 = -1;
        for (n3 = n; n3 < n + n2; ++n3) {
            char c = string.charAt(n3);
            if (c != '.' && c != '/' && c != '\uff0f' && c != '\uff0e' && c != '\u00b7') continue;
            n4 = n3;
            break;
        }
        if (n4 == -1 || n4 == n || n4 == n + n2 - 1) {
            return false;
        }
        n3 = n4 - n;
        return RecognitionTool.isNumber(string, n, n3) && RecognitionTool.isNumber(string, n4 + 1, n2 - (n3 + 1));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEnglishAndNumberMix(String string, int n, int n2) {
        char c;
        char c2;
        void var3_4;
        int c3 = n;
        while (var3_4 < n + n2) {
            char c4 = string.charAt((int)var3_4);
            if (!RecognitionTool.isEnglish(c4) && !RecognitionTool.isNumber(c4)) {
                return false;
            }
            ++var3_4;
        }
        if (n > 0 && (RecognitionTool.isEnglish(c2 = string.charAt(n - 1)) || RecognitionTool.isNumber(c2))) {
            return false;
        }
        if (n + n2 < string.length() && (RecognitionTool.isEnglish(c = string.charAt(n + n2)) || RecognitionTool.isNumber(c))) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bc6\u522b\u51fa\u82f1\u6587\u5b57\u6bcd\u548c\u6570\u5b57\u6df7\u5408\u4e32\uff1a" + string.substring(n, n + n2));
        }
        return true;
    }

    public static boolean isEnglish(String string) {
        return RecognitionTool.isEnglish(string, 0, string.length());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isEnglish(String string, int n, int n2) {
        char c;
        char c2;
        void var3_4;
        int c3 = n;
        while (var3_4 < n + n2) {
            char c4 = string.charAt((int)var3_4);
            if (!RecognitionTool.isEnglish(c4)) {
                return false;
            }
            ++var3_4;
        }
        if (n > 0 && RecognitionTool.isEnglish(c2 = string.charAt(n - 1))) {
            return false;
        }
        if (n + n2 < string.length() && RecognitionTool.isEnglish(c = string.charAt(n + n2))) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bc6\u522b\u51fa\u82f1\u6587\u5355\u8bcd\uff1a" + string.substring(n, n + n2));
        }
        return true;
    }

    public static boolean isEnglish(char c) {
        if (c > 'z' && c < '\uff21') {
            return false;
        }
        if (c < 'A') {
            return false;
        }
        if (c > 'Z' && c < 'a') {
            return false;
        }
        if (c > '\uff3a' && c < '\uff41') {
            return false;
        }
        return c <= '\uff5a';
    }

    public static boolean isQuantifier(String string) {
        return RecognitionTool.isQuantifier(string, 0, string.length());
    }

    public static boolean isQuantifier(String string, int n, int n2) {
        if (n2 < 2) {
            return false;
        }
        int n3 = n - 1;
        if (n3 > -1 && (string.charAt(n3) == '.' || string.charAt(n3) == '/')) {
            return false;
        }
        char c = string.charAt(n + n2 - 1);
        if (Quantifier.is(c) && (RecognitionTool.isNumber(string, n, n2 - 1) || RecognitionTool.isChineseNumber(string, n, n2 - 1) || RecognitionTool.isFraction(string, n, n2 - 1))) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("\u8bc6\u522b\u6570\u91cf\u8bcd\uff1a" + string.substring(n, n + n2));
            }
            return true;
        }
        return false;
    }

    public static boolean isNumber(String string) {
        return RecognitionTool.isNumber(string, 0, string.length());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean isNumber(String string, int n, int n2) {
        char c;
        char c2;
        void var3_4;
        int c3 = n;
        while (var3_4 < n + n2) {
            char c4 = string.charAt((int)var3_4);
            if (!RecognitionTool.isNumber(c4)) {
                return false;
            }
            ++var3_4;
        }
        if (n > 0 && RecognitionTool.isNumber(c2 = string.charAt(n - 1))) {
            return false;
        }
        if (n + n2 < string.length() && RecognitionTool.isNumber(c = string.charAt(n + n2))) {
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bc6\u522b\u51fa\u6570\u5b57\uff1a" + string.substring(n, n + n2));
        }
        return true;
    }

    public static boolean isNumber(char c) {
        if (c > '9' && c < '\uff10') {
            return false;
        }
        if (c < '0') {
            return false;
        }
        return c <= '\uff19';
    }

    public static boolean isChineseNumber(String string) {
        return RecognitionTool.isChineseNumber(string, 0, string.length());
    }

    public static boolean isChineseNumber(String string, int n, int n2) {
        int n3;
        for (n3 = n; n3 < n + n2; ++n3) {
            char c = string.charAt(n3);
            int n4 = 0;
            for (char c2 : chineseNumbers) {
                if (c != c2) continue;
                n4 = 1;
                break;
            }
            if (n4 != 0) continue;
            return false;
        }
        if (n > 0) {
            n3 = string.charAt(n - 1);
            for (char c : chineseNumbers) {
                if (n3 != c) continue;
                return false;
            }
        }
        if (n + n2 < string.length()) {
            n3 = string.charAt(n + n2);
            for (char c : chineseNumbers) {
                if (n3 != c) continue;
                return false;
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u8bc6\u522b\u51fa\u4e2d\u6587\u6570\u5b57\uff1a" + string.substring(n, n + n2));
        }
        return true;
    }

    public static void main(String[] stringArray) {
        String string = "0.08%";
        LOGGER.info("" + RecognitionTool.recog(string, 0, string.length()));
    }
}

