/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.analysis;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apdplat.word.analysis.TextSimilarity;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.AtomicFloat;

public class CosineTextSimilarity
extends TextSimilarity {
    @Override
    protected double scoreImpl(List<Word> list, List<Word> list2) {
        this.taggingWeightWithWordFrequency(list, list2);
        Map<String, Float> map = this.toFastSearchMap(list);
        Map<String, Float> map2 = this.toFastSearchMap(list2);
        HashSet<Word> hashSet = new HashSet<Word>();
        hashSet.addAll(list);
        hashSet.addAll(list2);
        AtomicFloat atomicFloat = new AtomicFloat();
        AtomicFloat atomicFloat2 = new AtomicFloat();
        AtomicFloat atomicFloat3 = new AtomicFloat();
        hashSet.parallelStream().forEach(word -> {
            float f;
            Float f2 = (Float)map.get(word.getText());
            Float f3 = (Float)map2.get(word.getText());
            if (f2 != null && f3 != null) {
                f = f2.floatValue() * f3.floatValue();
                atomicFloat.addAndGet(f);
            }
            if (f2 != null) {
                f = f2.floatValue() * f2.floatValue();
                atomicFloat2.addAndGet(f);
            }
            if (f3 != null) {
                f = f3.floatValue() * f3.floatValue();
                atomicFloat3.addAndGet(f);
            }
        });
        double d = Math.sqrt(atomicFloat2.doubleValue());
        double d2 = Math.sqrt(atomicFloat3.doubleValue());
        BigDecimal bigDecimal = BigDecimal.valueOf(d).multiply(BigDecimal.valueOf(d2));
        double d3 = BigDecimal.valueOf(atomicFloat.get()).divide(bigDecimal, 9, 4).doubleValue();
        return d3;
    }

    public static void main(String[] stringArray) {
        String string = "\u6211\u7231\u8d2d\u7269";
        String string2 = "\u6211\u7231\u8bfb\u4e66";
        String string3 = "\u4ed6\u662f\u9ed1\u5ba2";
        CosineTextSimilarity cosineTextSimilarity = new CosineTextSimilarity();
        double d = cosineTextSimilarity.similarScore(string, string);
        double d2 = cosineTextSimilarity.similarScore(string, string2);
        double d3 = cosineTextSimilarity.similarScore(string, string3);
        double d4 = cosineTextSimilarity.similarScore(string2, string2);
        double d5 = cosineTextSimilarity.similarScore(string2, string3);
        double d6 = cosineTextSimilarity.similarScore(string3, string3);
        System.out.println(string + " \u548c " + string + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d);
        System.out.println(string + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d2);
        System.out.println(string + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d3);
        System.out.println(string2 + " \u548c " + string2 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d4);
        System.out.println(string2 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d5);
        System.out.println(string3 + " \u548c " + string3 + " \u7684\u76f8\u4f3c\u5ea6\u5206\u503c\uff1a" + d6);
    }
}

