/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.Cluster;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.ClusterGrpc;
import io.etcd.jetcd.api.MemberAddRequest;
import io.etcd.jetcd.api.MemberListRequest;
import io.etcd.jetcd.api.MemberRemoveRequest;
import io.etcd.jetcd.api.MemberUpdateRequest;
import io.etcd.jetcd.cluster.MemberAddResponse;
import io.etcd.jetcd.cluster.MemberListResponse;
import io.etcd.jetcd.cluster.MemberRemoveResponse;
import io.etcd.jetcd.cluster.MemberUpdateResponse;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

final class ClusterImpl
implements Cluster {
    private final ClusterGrpc.ClusterFutureStub stub;
    private final ClientConnectionManager connectionManager;

    ClusterImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(ClusterGrpc::newFutureStub);
    }

    @Override
    public CompletableFuture<MemberListResponse> listMember() {
        return Util.toCompletableFuture(this.stub.memberList(MemberListRequest.getDefaultInstance()), MemberListResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<MemberAddResponse> addMember(List<URI> peerAddrs) {
        MemberAddRequest memberAddRequest = MemberAddRequest.newBuilder().addAllPeerURLs(peerAddrs.stream().map(URI::toString).collect(Collectors.toList())).build();
        return Util.toCompletableFuture(this.stub.memberAdd(memberAddRequest), MemberAddResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<MemberRemoveResponse> removeMember(long memberID) {
        MemberRemoveRequest memberRemoveRequest = MemberRemoveRequest.newBuilder().setID(memberID).build();
        return Util.toCompletableFuture(this.stub.memberRemove(memberRemoveRequest), MemberRemoveResponse::new, this.connectionManager.getExecutorService());
    }

    @Override
    public CompletableFuture<MemberUpdateResponse> updateMember(long memberID, List<URI> peerAddrs) {
        MemberUpdateRequest memberUpdateRequest = MemberUpdateRequest.newBuilder().addAllPeerURLs(peerAddrs.stream().map(URI::toString).collect(Collectors.toList())).setID(memberID).build();
        return Util.toCompletableFuture(this.stub.memberUpdate(memberUpdateRequest), MemberUpdateResponse::new, this.connectionManager.getExecutorService());
    }
}

