/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.metrics;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import org.apache.hugegraph.store.node.metrics.ProcfsEntry;
import org.apache.hugegraph.store.node.metrics.ProcfsReader;
import org.apache.hugegraph.store.node.metrics.ProcfsSmaps;

/*
 * Exception performing whole class analysis ignored.
 */
public class ProcfsSmaps
extends ProcfsEntry {
    private static final int KILOBYTE = 1024;
    private final Map<KEY, AtomicLong> values = new HashMap();

    public ProcfsSmaps() {
        super(ProcfsReader.getInstance((String)"smaps"));
    }

    ProcfsSmaps(ProcfsReader reader) {
        super(reader);
    }

    protected void reset() {
        EnumSet.allOf(KEY.class).forEach(key -> this.values.put(key, new AtomicLong(-1L)));
    }

    protected void handle(Collection<String> lines) {
        Objects.requireNonNull(lines);
        for (String line : lines) {
            if (line.startsWith("Size:")) {
                this.inc(KEY.VSS, ProcfsSmaps.parseKiloBytes((String)line) * 1024L);
                continue;
            }
            if (line.startsWith("Rss:")) {
                this.inc(KEY.RSS, ProcfsSmaps.parseKiloBytes((String)line) * 1024L);
                continue;
            }
            if (line.startsWith("Pss:")) {
                this.inc(KEY.PSS, ProcfsSmaps.parseKiloBytes((String)line) * 1024L);
                continue;
            }
            if (line.startsWith("Swap:")) {
                this.inc(KEY.SWAP, ProcfsSmaps.parseKiloBytes((String)line) * 1024L);
                continue;
            }
            if (!line.startsWith("SwapPss:")) continue;
            this.inc(KEY.SWAPPSS, ProcfsSmaps.parseKiloBytes((String)line) * 1024L);
        }
    }

    public Long get(KEY key) {
        Objects.requireNonNull(key);
        this.collect();
        return ((AtomicLong)this.values.get(key)).longValue();
    }

    private void inc(KEY key, long increment) {
        Objects.requireNonNull(key);
        ((AtomicLong)this.values.get(key)).getAndUpdate((LongUnaryOperator)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static long parseKiloBytes(String line) {
        Objects.requireNonNull(line);
        return Long.parseLong(line.split("\\s+")[1]);
    }
}

