/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.stages;

import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.backend.BackendColumn;
import org.apache.hugegraph.id.Id;
import org.apache.hugegraph.pd.common.PartitionUtils;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.serializer.BinaryElementSerializer;
import org.apache.hugegraph.serializer.BytesBuffer;
import org.apache.hugegraph.store.business.BusinessHandler;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.QueryUtil;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResultType;
import org.apache.hugegraph.structure.BaseElement;
import org.apache.hugegraph.structure.BaseVertex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlapStage
implements QueryStage {
    private static final Logger log = LoggerFactory.getLogger(OlapStage.class);
    private final BusinessHandler handler = new QueryUtil().getHandler();
    private final BinaryElementSerializer serializer = new BinaryElementSerializer();
    private String graph;
    private String table;
    private List<Id> properties;

    public void init(Object ... objects) {
        this.graph = (String)objects[0];
        this.table = (String)objects[1];
        this.properties = QueryUtil.fromStringBytes((List)((List)objects[2]));
    }

    public PipelineResult handle(PipelineResult result) {
        if (result == null) {
            return null;
        }
        if (result.getResultType() == PipelineResultType.HG_ELEMENT) {
            BaseElement element = result.getElement();
            int code = PartitionUtils.calcHashcode((byte[])BinaryElementSerializer.ownerId((BaseElement)element).asBytes());
            for (Id property : this.properties) {
                byte[] key = this.getOlapKey(property, element.id());
                byte[] values = this.handler.doGet(this.graph, code, "g+olap", key);
                if (values == null) continue;
                BackendColumn column = BackendColumn.of((byte[])key, (byte[])values);
                QueryUtil.parseOlap((BackendColumn)column, (BaseVertex)((BaseVertex)element));
            }
        } else if (result.getResultType() == PipelineResultType.BACKEND_COLUMN) {
            RocksDBSession.BackendColumn column = result.getColumn();
            try {
                BaseVertex vertexOnlyId = this.serializer.parseVertex(null, BackendColumn.of((byte[])column.name, null), null);
                int code = PartitionUtils.calcHashcode((byte[])BinaryElementSerializer.ownerId((BaseElement)vertexOnlyId).asBytes());
                ArrayList<BackendColumn> list = new ArrayList<BackendColumn>();
                for (Id property : this.properties) {
                    byte[] key = this.getOlapKey(property, vertexOnlyId.id());
                    byte[] values = this.handler.doGet(this.graph, code, "g+olap", key);
                    if (values == null) continue;
                    list.add(BackendColumn.of((byte[])key, (byte[])values));
                }
                BackendColumn vertex = QueryUtil.combineColumn((BackendColumn)BackendColumn.of((byte[])column.name, (byte[])column.value), list);
                result.setColumn(RocksDBSession.BackendColumn.of((byte[])vertex.name, (byte[])vertex.value));
            }
            catch (Exception e) {
                log.error("parse olap error, graph: {}, table : {}", new Object[]{this.graph, this.table, e});
                return null;
            }
        }
        return result;
    }

    private byte[] getOlapKey(Id propertyId, Id vertexId) {
        BytesBuffer bufferName = BytesBuffer.allocate((int)(1 + propertyId.length() + 1 + vertexId.length()));
        bufferName.writeId(propertyId);
        return bufferName.writeId(vertexId).bytes();
    }

    public String getName() {
        return "OLAP_STAGE";
    }

    public void close() {
        this.properties.clear();
    }
}

