/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc.query.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hugegraph.store.node.grpc.query.QueryStage;
import org.apache.hugegraph.store.node.grpc.query.model.PipelineResult;
import org.apache.hugegraph.store.node.grpc.query.stages.EarlyStopException;

public class QueryPlan {
    private final List<QueryStage> stages = new LinkedList();

    public void addStage(QueryStage pipeline) {
        this.stages.add(pipeline);
    }

    public boolean onlyStopStage() {
        return this.stages.size() == 1 && "STOP_STAGE".equals(((QueryStage)this.stages.get(0)).getName());
    }

    public boolean containsAggStage() {
        return this.stages.stream().anyMatch(stage -> stage.getName().equals("AGG_STAGE"));
    }

    public Object execute(PipelineResult data) throws EarlyStopException {
        if (data == null || this.stages.isEmpty()) {
            return data;
        }
        ArrayList current = new ArrayList();
        ArrayList<PipelineResult> next = new ArrayList<PipelineResult>();
        next.add(data);
        for (QueryStage stage : this.stages) {
            current.clear();
            current.addAll(next);
            next.clear();
            for (Object item : current) {
                if (item instanceof Iterator) {
                    Iterator itr = (Iterator)item;
                    while (itr.hasNext()) {
                        this.callStage(stage, next, (PipelineResult)itr.next());
                    }
                    continue;
                }
                this.callStage(stage, next, (PipelineResult)item);
            }
        }
        if (next.isEmpty()) {
            return null;
        }
        if (next.get(0) instanceof Iterator || next.size() == 1) {
            return next.get(0);
        }
        return next.iterator();
    }

    private void callStage(QueryStage stage, List<Object> list, PipelineResult pre) throws EarlyStopException {
        Iterator ret = stage.isIterator() ? stage.handleIterator(pre) : stage.handle(pre);
        if (ret != null) {
            list.add(ret);
        }
    }

    public String toString() {
        String names = String.join((CharSequence)", ", this.stages.stream().map(QueryStage::getName).collect(Collectors.toList()));
        return "QueryPlan{stages=[" + names + "]}";
    }

    public void clear() {
        for (QueryStage stage : this.stages) {
            stage.close();
        }
        this.stages.clear();
    }

    public boolean isEmpty() {
        return this.stages.isEmpty();
    }

    public boolean hasIteratorResult() {
        return this.stages.stream().anyMatch(QueryStage::isIterator);
    }
}

