/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.function.Supplier;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.business.SelectIterator;
import org.apache.hugegraph.store.grpc.common.ScanMethod;
import org.apache.hugegraph.store.grpc.stream.ScanQueryRequest;
import org.apache.hugegraph.store.grpc.stream.ScanStreamReq;
import org.apache.hugegraph.store.grpc.stream.SelectParam;
import org.apache.hugegraph.store.node.grpc.BatchScanIterator;
import org.apache.hugegraph.store.node.grpc.EmptyIterator;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.grpc.ParallelScanIterator;
import org.apache.hugegraph.store.node.grpc.ScanQuery;
import org.apache.hugegraph.store.node.grpc.ScanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ScanUtil {
    private static final Logger log = LoggerFactory.getLogger(ScanUtil.class);
    private static final Map<String, byte[]> tableKeyMap = new HashMap();

    ScanUtil() {
    }

    static ScanIterator getIterator(ScanStreamReq request, HgStoreWrapperEx wrapper) {
        String graph = request.getHeader().getGraph();
        String table = request.getTable();
        ScanMethod method = request.getMethod();
        byte[] start = request.getStart().toByteArray();
        byte[] end = request.getEnd().toByteArray();
        byte[] prefix = request.getPrefix().toByteArray();
        int partition = request.getCode();
        int scanType = request.getScanType();
        byte[] query = request.getQuery().toByteArray();
        ScanIterator iter = null;
        switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$common$ScanMethod[method.ordinal()]) {
            case 1: {
                iter = wrapper.scanAll(graph, table, query);
                break;
            }
            case 2: {
                iter = wrapper.scanPrefix(graph, partition, table, prefix, scanType, query);
                break;
            }
            case 3: {
                iter = wrapper.scan(graph, partition, table, start, end, scanType, query);
            }
        }
        if (iter == null) {
            log.warn("Failed to create a scanIterator with ScanMethod: [" + String.valueOf(method) + "]");
            iter = new EmptyIterator();
        }
        SelectParam selects = request.getSelects();
        List properties = null;
        if (selects != null) {
            properties = selects.getPropertiesList();
        }
        iter = new SelectIterator(iter, properties);
        iter.seek(request.getPosition().toByteArray());
        return iter;
    }

    static ScanIterator getIterator(ScanQuery sq, HgStoreWrapperEx wrapper) {
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)sq);
        }
        ScanIterator iter = null;
        switch (1.$SwitchMap$org$apache$hugegraph$store$grpc$common$ScanMethod[sq.method.ordinal()]) {
            case 1: {
                iter = wrapper.scanAll(sq.graph, sq.table, sq.query);
                break;
            }
            case 2: {
                iter = wrapper.scanPrefix(sq.graph, sq.keyCode, sq.table, sq.prefix, sq.scanType, sq.query);
                break;
            }
            case 3: {
                iter = wrapper.scan(sq.graph, sq.keyCode, sq.table, sq.start, sq.end, sq.scanType, sq.query);
            }
        }
        if (iter == null) {
            log.warn("Failed to create a scanIterator with ScanMethod: [" + String.valueOf(sq.method) + "]");
            iter = new EmptyIterator();
        }
        iter.seek(sq.position);
        return iter;
    }

    static ScanQuery toSq(ScanStreamReq request) {
        ScanQuery res = ScanQuery.of();
        res.graph = request.getHeader().getGraph();
        res.table = request.getTable();
        res.method = request.getMethod();
        res.keyCode = request.getCode();
        res.start = request.getStart().toByteArray();
        res.end = request.getEnd().toByteArray();
        res.prefix = request.getPrefix().toByteArray();
        res.scanType = request.getScanType();
        res.query = request.getQuery().toByteArray();
        res.position = request.getPosition().toByteArray();
        if (log.isDebugEnabled()) {
            log.debug("{}", (Object)res);
        }
        return res;
    }

    static ScanIterator getIterator(String graph, ScanQueryRequest request, HgStoreWrapperEx wrapper) {
        ScanIteratorSupplier supplier = new ScanIteratorSupplier(graph, request, wrapper);
        return BatchScanIterator.of((Supplier)supplier, (Supplier)supplier.getLimitSupplier());
    }

    static ScanIterator getParallelIterator(String graph, ScanQueryRequest request, HgStoreWrapperEx wrapper, ThreadPoolExecutor executor) {
        ScanIteratorSupplier supplier = new ScanIteratorSupplier(graph, request, wrapper);
        return ParallelScanIterator.of((Supplier)supplier, (Supplier)supplier.getLimitSupplier(), (ScanQueryRequest)request, (ThreadPoolExecutor)executor);
    }
}

