/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.node.grpc;

import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import org.apache.hugegraph.rocksdb.access.RocksDBSession;
import org.apache.hugegraph.rocksdb.access.ScanIterator;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.stream.KvPageRes;
import org.apache.hugegraph.store.grpc.stream.ScanQueryRequest;
import org.apache.hugegraph.store.grpc.stream.ScanStreamBatchReq;
import org.apache.hugegraph.store.node.grpc.HgStoreWrapperEx;
import org.apache.hugegraph.store.node.grpc.ScanUtil;
import org.apache.hugegraph.store.node.util.HgGrpc;
import org.apache.hugegraph.store.node.util.HgStoreNodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanBatchOneShotResponse {
    private static final Logger log = LoggerFactory.getLogger(ScanBatchOneShotResponse.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanOneShot(ScanStreamBatchReq request, StreamObserver<KvPageRes> responseObserver, HgStoreWrapperEx wrapper) {
        String graph = request.getHeader().getGraph();
        ScanQueryRequest queryRequest = request.getQueryRequest();
        ScanIterator iterator = ScanUtil.getIterator((String)graph, (ScanQueryRequest)queryRequest, (HgStoreWrapperEx)wrapper);
        KvPageRes.Builder resBuilder = KvPageRes.newBuilder();
        Kv.Builder kvBuilder = Kv.newBuilder();
        long limit = queryRequest.getLimit();
        if (limit <= 0L) {
            limit = Integer.MAX_VALUE;
            log.warn("As limit is less than or equals 0, default limit was effective:[ {} ]", (Object)Integer.MAX_VALUE);
        }
        int count = 0;
        try {
            while (iterator.hasNext() && (long)(++count) <= limit) {
                RocksDBSession.BackendColumn col = (RocksDBSession.BackendColumn)iterator.next();
                resBuilder.addData(kvBuilder.setKey(ByteString.copyFrom((byte[])col.name)).setValue(ByteString.copyFrom((byte[])col.value)).setCode(HgStoreNodeUtil.toInt((byte[])iterator.position())));
            }
            responseObserver.onNext((Object)resBuilder.build());
            responseObserver.onCompleted();
        }
        catch (Throwable t) {
            String msg = "Failed to do oneshot batch scan, scanning was interrupted, cause by:";
            responseObserver.onError((Throwable)HgGrpc.toErr((Status.Code)Status.Code.INTERNAL, (String)msg, (Throwable)t));
        }
        finally {
            iterator.close();
        }
    }
}

