/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.analyzer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import org.apache.hugegraph.analyzer.Analyzer;
import org.apache.hugegraph.config.ConfigException;
import org.apache.hugegraph.util.InsertionOrderUtil;
import org.apdplat.word.WordSegmenter;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;

public class WordAnalyzer
implements Analyzer {
    public static final List<String> SUPPORT_MODES = ImmutableList.builder().add((Object)"MaximumMatching").add((Object)"ReverseMaximumMatching").add((Object)"MinimumMatching").add((Object)"ReverseMinimumMatching").add((Object)"BidirectionalMaximumMatching").add((Object)"BidirectionalMinimumMatching").add((Object)"BidirectionalMaximumMinimumMatching").add((Object)"FullSegmentation").add((Object)"MinimalWordCount").add((Object)"MaxNgramScore").add((Object)"PureEnglish").build();
    private SegmentationAlgorithm algorithm;

    public WordAnalyzer(String mode) {
        try {
            this.algorithm = SegmentationAlgorithm.valueOf((String)mode);
        }
        catch (Exception e) {
            throw new ConfigException("Unsupported segment mode '%s' for word analyzer, the available values are %s", (Throwable)e, new Object[]{mode, SUPPORT_MODES});
        }
    }

    @Override
    public Set<String> segment(String text) {
        Set result = InsertionOrderUtil.newSet();
        List words = WordSegmenter.segWithStopWords((String)text, (SegmentationAlgorithm)this.algorithm);
        for (Word word : words) {
            result.add(word.getText());
        }
        return result;
    }
}

