/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.io.OutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicLong;
import javax.crypto.spec.SecretKeySpec;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.codec.Codec;
import org.apache.hadoop.hbase.io.crypto.Cipher;
import org.apache.hadoop.hbase.io.crypto.Encryption;
import org.apache.hadoop.hbase.io.crypto.Encryptor;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.regionserver.wal.CompressionContext;
import org.apache.hadoop.hbase.regionserver.wal.ProtobufLogReader;
import org.apache.hadoop.hbase.regionserver.wal.SecureWALCellCodec;
import org.apache.hadoop.hbase.regionserver.wal.WALCellCodec;
import org.apache.hadoop.hbase.security.EncryptionUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class AbstractProtobufLogWriter {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProtobufLogWriter.class);
    protected CompressionContext compressionContext;
    protected Configuration conf;
    protected Codec.Encoder cellEncoder;
    protected WALCellCodec.ByteStringCompressor compressor;
    protected boolean trailerWritten;
    protected WALProtos.WALTrailer trailer;
    protected int trailerWarnSize;
    protected AtomicLong length = new AtomicLong();

    private WALCellCodec getCodec(Configuration conf, CompressionContext compressionContext) throws IOException {
        return WALCellCodec.create(conf, null, compressionContext);
    }

    private WALProtos.WALHeader buildWALHeader0(Configuration conf, WALProtos.WALHeader.Builder builder) {
        if (!builder.hasWriterClsName()) {
            builder.setWriterClsName(this.getWriterClassName());
        }
        if (!builder.hasCellCodecClsName()) {
            builder.setCellCodecClsName(WALCellCodec.getWALCellCodecClass(conf).getName());
        }
        return builder.build();
    }

    protected WALProtos.WALHeader buildWALHeader(Configuration conf, WALProtos.WALHeader.Builder builder) throws IOException {
        return this.buildWALHeader0(conf, builder);
    }

    protected final WALProtos.WALHeader buildSecureWALHeader(Configuration conf, WALProtos.WALHeader.Builder builder) throws IOException {
        builder.setWriterClsName(this.getWriterClassName());
        if (conf.getBoolean("hbase.regionserver.wal.encryption", false)) {
            EncryptionTest.testKeyProvider(conf);
            EncryptionTest.testCipherProvider(conf);
            String cipherName = conf.get("hbase.crypto.wal.algorithm", "AES");
            Cipher cipher = Encryption.getCipher((Configuration)conf, (String)cipherName);
            if (cipher == null) {
                throw new RuntimeException("Cipher '" + cipherName + "' is not available");
            }
            SecureRandom rng = new SecureRandom();
            byte[] keyBytes = new byte[cipher.getKeyLength()];
            rng.nextBytes(keyBytes);
            SecretKeySpec key = new SecretKeySpec(keyBytes, cipher.getName());
            builder.setEncryptionKey(UnsafeByteOperations.unsafeWrap((byte[])EncryptionUtil.wrapKey((Configuration)conf, (String)conf.get("hbase.crypto.wal.key.name", conf.get("hbase.crypto.master.key.name", User.getCurrent().getShortName())), (Key)key)));
            Encryptor encryptor = cipher.getEncryptor();
            encryptor.setKey((Key)key);
            this.setEncryptor(encryptor);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Initialized secure protobuf WAL: cipher=" + cipher.getName());
            }
        }
        builder.setCellCodecClsName(SecureWALCellCodec.class.getName());
        return this.buildWALHeader0(conf, builder);
    }

    protected void setEncryptor(Encryptor encryptor) {
    }

    protected String getWriterClassName() {
        return this.getClass().getSimpleName();
    }

    private boolean initializeCompressionContext(Configuration conf, Path path) throws IOException {
        boolean doCompress = conf.getBoolean("hbase.regionserver.wal.enablecompression", false);
        if (doCompress) {
            try {
                this.compressionContext = new CompressionContext(LRUDictionary.class, FSUtils.isRecoveredEdits((Path)path), conf.getBoolean("hbase.regionserver.wal.tags.enablecompression", true));
            }
            catch (Exception e) {
                throw new IOException("Failed to initiate CompressionContext", e);
            }
        }
        return doCompress;
    }

    public void init(FileSystem fs, Path path, Configuration conf, boolean overwritable, long blocksize) throws IOException, CommonFSUtils.StreamLacksCapabilityException {
        this.conf = conf;
        boolean doCompress = this.initializeCompressionContext(conf, path);
        this.trailerWarnSize = conf.getInt("hbase.regionserver.waltrailer.warn.size", 0x100000);
        int bufferSize = FSUtils.getDefaultBufferSize((FileSystem)fs);
        short replication = (short)conf.getInt("hbase.regionserver.hlog.replication", (int)FSUtils.getDefaultReplication((FileSystem)fs, (Path)path));
        this.initOutput(fs, path, overwritable, bufferSize, replication, blocksize);
        boolean doTagCompress = doCompress && conf.getBoolean("hbase.regionserver.wal.tags.enablecompression", true);
        this.length.set(this.writeMagicAndWALHeader(ProtobufLogReader.PB_WAL_MAGIC, this.buildWALHeader(conf, WALProtos.WALHeader.newBuilder().setHasCompression(doCompress).setHasTagCompression(doTagCompress))));
        this.initAfterHeader(doCompress);
        this.trailer = WALProtos.WALTrailer.newBuilder().build();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Initialized protobuf WAL=" + path + ", compression=" + doCompress);
        }
    }

    private void initAfterHeader0(boolean doCompress) throws IOException {
        WALCellCodec codec = this.getCodec(this.conf, this.compressionContext);
        this.cellEncoder = codec.getEncoder(this.getOutputStreamForCellEncoder());
        this.compressor = doCompress ? codec.getByteStringCompressor() : WALCellCodec.getNoneCompressor();
    }

    protected void initAfterHeader(boolean doCompress) throws IOException {
        this.initAfterHeader0(doCompress);
    }

    protected final void secureInitAfterHeader(boolean doCompress, Encryptor encryptor) throws IOException {
        if (this.conf.getBoolean("hbase.regionserver.wal.encryption", false) && encryptor != null) {
            WALCellCodec codec = SecureWALCellCodec.getCodec(this.conf, encryptor);
            this.cellEncoder = codec.getEncoder(this.getOutputStreamForCellEncoder());
            this.compressionContext = null;
            this.compressor = WALCellCodec.getNoneCompressor();
        } else {
            this.initAfterHeader0(doCompress);
        }
    }

    void setWALTrailer(WALProtos.WALTrailer walTrailer) {
        this.trailer = walTrailer;
    }

    public long getLength() {
        return this.length.get();
    }

    private WALProtos.WALTrailer buildWALTrailer(WALProtos.WALTrailer.Builder builder) {
        return builder.build();
    }

    protected void writeWALTrailer() {
        try {
            int trailerSize = 0;
            if (this.trailer == null) {
                LOG.warn("WALTrailer is null. Continuing with default.");
                this.trailer = this.buildWALTrailer(WALProtos.WALTrailer.newBuilder());
                trailerSize = this.trailer.getSerializedSize();
            } else {
                trailerSize = this.trailer.getSerializedSize();
                if (trailerSize > this.trailerWarnSize) {
                    LOG.warn("Please investigate WALTrailer usage. Trailer size > maximum size : " + trailerSize + " > " + this.trailerWarnSize);
                }
            }
            this.length.set(this.writeWALTrailerAndMagic(this.trailer, ProtobufLogReader.PB_WAL_COMPLETE_MAGIC));
            this.trailerWritten = true;
        }
        catch (IOException ioe) {
            LOG.warn("Failed to write trailer, non-fatal, continuing...", (Throwable)ioe);
        }
    }

    protected abstract void initOutput(FileSystem var1, Path var2, boolean var3, int var4, short var5, long var6) throws IOException, CommonFSUtils.StreamLacksCapabilityException;

    protected abstract long writeMagicAndWALHeader(byte[] var1, WALProtos.WALHeader var2) throws IOException;

    protected abstract long writeWALTrailerAndMagic(WALProtos.WALTrailer var1, byte[] var2) throws IOException;

    protected abstract OutputStream getOutputStreamForCellEncoder();
}

