/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cache;

import java.util.ArrayList;
import java.util.List;
import org.apache.hc.client5.http.cache.RequestCacheControl;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpMessage;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHeaderValueFormatter;
import org.apache.hc.core5.http.message.BufferedHeader;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.CharArrayBuffer;

@Internal
@Contract(threading=ThreadingBehavior.IMMUTABLE)
class CacheControlHeaderGenerator {
    public static final CacheControlHeaderGenerator INSTANCE = new CacheControlHeaderGenerator();

    CacheControlHeaderGenerator() {
    }

    public List<NameValuePair> convert(RequestCacheControl cacheControl) {
        Args.notNull((Object)cacheControl, (String)"Cache control");
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(10);
        if (cacheControl.getMaxAge() >= 0L) {
            params.add((NameValuePair)new BasicHeader("max-age", (Object)cacheControl.getMaxAge()));
        }
        if (cacheControl.getMaxStale() >= 0L) {
            params.add((NameValuePair)new BasicHeader("max-stale", (Object)cacheControl.getMaxStale()));
        }
        if (cacheControl.getMinFresh() >= 0L) {
            params.add((NameValuePair)new BasicHeader("min-fresh", (Object)cacheControl.getMinFresh()));
        }
        if (cacheControl.isNoCache()) {
            params.add((NameValuePair)new BasicHeader("no-cache", null));
        }
        if (cacheControl.isNoStore()) {
            params.add((NameValuePair)new BasicHeader("no-store", null));
        }
        if (cacheControl.isOnlyIfCached()) {
            params.add((NameValuePair)new BasicHeader("only-if-cached", null));
        }
        if (cacheControl.getStaleIfError() >= 0L) {
            params.add((NameValuePair)new BasicHeader("stale-if-error", (Object)cacheControl.getStaleIfError()));
        }
        return params;
    }

    public Header generate(RequestCacheControl cacheControl) {
        List<NameValuePair> params = this.convert(cacheControl);
        if (!params.isEmpty()) {
            CharArrayBuffer buf = new CharArrayBuffer(1024);
            buf.append("Cache-Control");
            buf.append(": ");
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                BasicHeaderValueFormatter.INSTANCE.formatNameValuePair(buf, params.get(i), false);
            }
            return BufferedHeader.create((CharArrayBuffer)buf);
        }
        return null;
    }

    public void generate(RequestCacheControl cacheControl, HttpMessage message) {
        Header h = this.generate(cacheControl);
        if (h != null) {
            message.addHeader(h);
        }
    }
}

