/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.core.queries.CoreAttributeItem;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.Marshaller;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.SAXFragmentBuilder;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XMLRelationshipMappingNodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.CompositeCollectionMapping;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.InverseReferenceMapping;
import org.eclipse.persistence.internal.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLRecord;
import org.eclipse.persistence.internal.oxm.record.deferred.CompositeCollectionMappingContentHandler;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.mappings.nullpolicy.XMLNullRepresentationType;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class XMLCompositeCollectionMappingNodeValue
extends XMLRelationshipMappingNodeValue
implements ContainerValue {
    private CompositeCollectionMapping xmlCompositeCollectionMapping;
    private int index = -1;
    private boolean isInverseReference;

    public XMLCompositeCollectionMappingNodeValue(CompositeCollectionMapping xmlCompositeCollectionMapping) {
        this.xmlCompositeCollectionMapping = xmlCompositeCollectionMapping;
    }

    public XMLCompositeCollectionMappingNodeValue(CompositeCollectionMapping xmlCompositeCollectionMapping, boolean isInverse) {
        this(xmlCompositeCollectionMapping);
        this.isInverseReference = isInverse;
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        Object iterator;
        if (this.xmlCompositeCollectionMapping.isReadOnly()) {
            return false;
        }
        Object collection = this.xmlCompositeCollectionMapping.getAttributeAccessor().getAttributeValueFromObject(object);
        if (null == collection) {
            AbstractNullPolicy wrapperNP = this.xmlCompositeCollectionMapping.getWrapperNullPolicy();
            if (wrapperNP != null && wrapperNP.getMarshalNullRepresentation() == XMLNullRepresentationType.XSI_NIL) {
                marshalRecord.nilSimple(namespaceResolver);
                return true;
            }
            return false;
        }
        CoreContainerPolicy cp = this.getContainerPolicy();
        int size = marshalRecord.getCycleDetectionStack().size();
        if ((this.isInverseReference || this.xmlCompositeCollectionMapping.getInverseReferenceMapping() != null) && size >= 2) {
            Object owner = marshalRecord.getCycleDetectionStack().get(size - 2);
            try {
                if (cp.contains(owner, collection, session)) {
                    return false;
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (null != (iterator = cp.iteratorFor(collection)) && cp.hasNext(iterator)) {
            XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
            marshalRecord.closeStartGroupingElements(groupingFragment);
            int valueSize = cp.sizeFor(collection);
            if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON() && (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays())) {
                marshalRecord.startCollection();
            }
            do {
                Object objectValue = cp.next(iterator, session);
                this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, ObjectMarshalContext.getInstance());
            } while (cp.hasNext(iterator));
            if (((Marshaller)marshalRecord.getMarshaller()).isApplicationJSON() && (valueSize > 1 || !((Marshaller)marshalRecord.getMarshaller()).isReduceAnyArrays())) {
                marshalRecord.endCollection();
            }
            return true;
        }
        return marshalRecord.emptyCollection(xPathFragment, namespaceResolver, this.xmlCompositeCollectionMapping.getWrapperNullPolicy() != null);
    }

    @Override
    public boolean startElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Attributes atts) {
        try {
            AbstractNullPolicy nullPolicy;
            Descriptor xmlDescriptor = (Descriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
            if (xmlDescriptor == null) {
                Object policy;
                xmlDescriptor = this.findReferenceDescriptor(xPathFragment, unmarshalRecord, atts, this.xmlCompositeCollectionMapping, (UnmarshalKeepAsElementPolicy)this.xmlCompositeCollectionMapping.getKeepAsElementPolicy());
                if (xmlDescriptor == null) {
                    QName leafType;
                    if (unmarshalRecord.getXMLReader().isNullRepresentedByXsiNil(this.xmlCompositeCollectionMapping.getNullPolicy())) {
                        if (unmarshalRecord.isNil()) {
                            return true;
                        }
                    } else if (this.xmlCompositeCollectionMapping.getNullPolicy().valueIsNull(atts)) {
                        this.getContainerPolicy().addInto(null, unmarshalRecord.getContainerInstance(this), unmarshalRecord.getSession());
                        return true;
                    }
                    if (this.xmlCompositeCollectionMapping.getField() != null && (leafType = ((Field)this.xmlCompositeCollectionMapping.getField()).getLastXPathFragment().getLeafElementType()) != null) {
                        XPathFragment frag = new XPathFragment();
                        frag.setNamespaceAware(unmarshalRecord.isNamespaceAware());
                        Object xpath = leafType.getLocalPart();
                        String uri = leafType.getNamespaceURI();
                        if (uri != null && uri.length() > 0) {
                            frag.setNamespaceURI(uri);
                            String prefix = ((NamespaceResolver)((Descriptor)this.xmlCompositeCollectionMapping.getDescriptor()).getNonNullNamespaceResolver()).resolveNamespaceURI(uri);
                            if (prefix != null && prefix.length() > 0) {
                                xpath = prefix + ":" + (String)xpath;
                            }
                        }
                        frag.setXPath((String)xpath);
                        Object xmlContext = ((Unmarshaller)unmarshalRecord.getUnmarshaller()).getContext();
                        xmlDescriptor = ((Context)xmlContext).getDescriptorByGlobalType(frag);
                    }
                }
                if ((policy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy()) != null && (xmlDescriptor == null && policy.isKeepUnknownAsElement() || policy.isKeepAllAsElement())) {
                    if (unmarshalRecord.getTypeQName() != null) {
                        Class theClass = unmarshalRecord.getConversionManager().javaType(unmarshalRecord.getTypeQName());
                        if (theClass == null) {
                            this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                            return true;
                        }
                    } else {
                        this.setupHandlerForKeepAsElementPolicy(unmarshalRecord, xPathFragment, atts);
                        return true;
                    }
                }
            }
            if ((nullPolicy = this.xmlCompositeCollectionMapping.getNullPolicy()).isNullRepresentedByEmptyNode()) {
                Object qnameString = xPathFragment.getLocalName();
                if (xPathFragment.getPrefix() != null) {
                    qnameString = xPathFragment.getPrefix() + ":" + (String)qnameString;
                }
                if (null != xmlDescriptor) {
                    CompositeCollectionMappingContentHandler aHandler = new CompositeCollectionMappingContentHandler(unmarshalRecord, this, this.xmlCompositeCollectionMapping, atts, xPathFragment, xmlDescriptor);
                    aHandler.startElement(xPathFragment.getNamespaceURI(), xPathFragment.getLocalName(), (String)qnameString, atts);
                    XMLReader xmlReader = unmarshalRecord.getXMLReader();
                    xmlReader.setContentHandler(aHandler);
                    xmlReader.setLexicalHandler(aHandler);
                }
            } else if (!unmarshalRecord.getXMLReader().isNullRecord(nullPolicy, atts, unmarshalRecord)) {
                Field xmlFld = (Field)this.xmlCompositeCollectionMapping.getField();
                if (xmlFld.hasLastXPathFragment()) {
                    unmarshalRecord.setLeafElementType(xmlFld.getLastXPathFragment().getLeafElementType());
                }
                this.processChild(xPathFragment, unmarshalRecord, atts, xmlDescriptor, this.xmlCompositeCollectionMapping);
            }
        }
        catch (SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
        return true;
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord) {
        Object collection = unmarshalRecord.getContainerInstance(this);
        this.endElement(xPathFragment, unmarshalRecord, collection);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, UnmarshalRecord unmarshalRecord, Object collection) {
        if (unmarshalRecord.isNil() && unmarshalRecord.getXMLReader().isNullRepresentedByXsiNil(this.xmlCompositeCollectionMapping.getNullPolicy()) && unmarshalRecord.getChildRecord() == null) {
            if (unmarshalRecord.getXMLReader().isInCollection()) {
                unmarshalRecord.addAttributeValue(this, null);
            } else {
                unmarshalRecord.setAttributeValueNull(this);
            }
            unmarshalRecord.resetStringBuffer();
            return;
        }
        if (null == unmarshalRecord.getChildRecord()) {
            SAXFragmentBuilder builder = unmarshalRecord.getFragmentBuilder();
            Object keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
            if (null != keepAsElementPolicy && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && builder.getNodes().size() > 1) {
                Class theClass;
                if (unmarshalRecord.getTypeQName() != null && (theClass = unmarshalRecord.getConversionManager().javaType(unmarshalRecord.getTypeQName())) != null) {
                    this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping, xPathFragment, collection);
                    return;
                }
                if (builder.getNodes().size() > 1) {
                    this.setOrAddAttributeValueForKeepAsElement(builder, this.xmlCompositeCollectionMapping, this.xmlCompositeCollectionMapping, unmarshalRecord, true, collection);
                    return;
                }
            } else {
                this.endElementProcessText(unmarshalRecord, this.xmlCompositeCollectionMapping, xPathFragment, collection);
                return;
            }
            return;
        }
        Object objectValue = unmarshalRecord.getChildRecord().getCurrentObject();
        InverseReferenceMapping inverseReferenceMapping = this.xmlCompositeCollectionMapping.getInverseReferenceMapping();
        if (null != inverseReferenceMapping) {
            if (inverseReferenceMapping.getContainerPolicy() == null) {
                Object currentValue = inverseReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(objectValue);
                if (!this.isInverseReference || currentValue == null && this.isInverseReference) {
                    inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, unmarshalRecord.getCurrentObject());
                }
            } else {
                Object backpointerContainer = inverseReferenceMapping.getAttributeAccessor().getAttributeValueFromObject(objectValue);
                if (backpointerContainer == null) {
                    backpointerContainer = inverseReferenceMapping.getContainerPolicy().containerInstance();
                    inverseReferenceMapping.getAttributeAccessor().setAttributeValueInObject(objectValue, backpointerContainer);
                }
                inverseReferenceMapping.getContainerPolicy().addInto(unmarshalRecord.getCurrentObject(), backpointerContainer, unmarshalRecord.getSession());
            }
        }
        objectValue = this.xmlCompositeCollectionMapping.convertDataValueToObjectValue(objectValue, unmarshalRecord.getSession(), unmarshalRecord.getUnmarshaller());
        unmarshalRecord.addAttributeValue(this, objectValue, collection);
        unmarshalRecord.setChildRecord(null);
    }

    @Override
    public Object getContainerInstance() {
        return this.getContainerPolicy().containerInstance();
    }

    @Override
    public void setContainerInstance(Object object, Object containerInstance) {
        this.xmlCompositeCollectionMapping.setAttributeValueInObject(object, containerInstance);
    }

    @Override
    public CoreContainerPolicy getContainerPolicy() {
        return this.xmlCompositeCollectionMapping.getContainerPolicy();
    }

    @Override
    public boolean isContainerValue() {
        return true;
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object value, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Class<?> objectValueClass;
        Object marshaller = marshalRecord.getMarshaller();
        boolean isNil = false;
        if (value instanceof Root) {
            isNil = ((Root)value).nil;
            value = ((Root)value).getObject();
        }
        if (null == (value = this.xmlCompositeCollectionMapping.convertObjectValueToDataValue(value, session, marshaller))) {
            return this.xmlCompositeCollectionMapping.getNullPolicy().compositeObjectMarshal(xPathFragment, marshalRecord, object, session, namespaceResolver);
        }
        Descriptor descriptor = (Descriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor();
        if (descriptor == null) {
            descriptor = (Descriptor)session.getDescriptor(value.getClass());
        } else if (descriptor.hasInheritance() && (objectValueClass = value.getClass()) != descriptor.getJavaClass()) {
            descriptor = (Descriptor)session.getDescriptor(objectValueClass);
        }
        Object keepAsElementPolicy = this.xmlCompositeCollectionMapping.getKeepAsElementPolicy();
        if (null != keepAsElementPolicy && (keepAsElementPolicy.isKeepUnknownAsElement() || keepAsElementPolicy.isKeepAllAsElement()) && value instanceof Node) {
            marshalRecord.node((Node)value, marshalRecord.getNamespaceResolver());
            return true;
        }
        if (descriptor != null) {
            marshalRecord.beforeContainmentMarshal(value);
            ObjectBuilder objectBuilder = (ObjectBuilder)descriptor.getObjectBuilder();
            CoreAttributeGroup group = marshalRecord.getCurrentAttributeGroup();
            CoreAttributeGroup nestedGroup = XMLRecord.DEFAULT_ATTRIBUTE_GROUP;
            Object item = group.getItem(this.getMapping().getAttributeName());
            if (item != null) {
                if (((CoreAttributeItem)item).getGroups() != null) {
                    nestedGroup = ((CoreAttributeItem)item).getGroup(descriptor.getJavaClass());
                }
                if (nestedGroup == null) {
                    nestedGroup = ((CoreAttributeItem)item).getGroup() == null ? XMLRecord.DEFAULT_ATTRIBUTE_GROUP : ((CoreAttributeItem)item).getGroup();
                }
            }
            marshalRecord.pushAttributeGroup(nestedGroup);
            this.xPathNode.startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, objectBuilder, value);
            if (isNil) {
                marshalRecord.nilSimple(namespaceResolver);
            }
            List extraNamespaces = objectBuilder.addExtraNamespacesToNamespaceResolver(descriptor, marshalRecord, session, true, false);
            this.writeExtraNamespaces(extraNamespaces, marshalRecord, session);
            marshalRecord.addXsiTypeAndClassIndicatorIfRequired(descriptor, (Descriptor)this.xmlCompositeCollectionMapping.getReferenceDescriptor(), (Field)this.xmlCompositeCollectionMapping.getField(), false);
            objectBuilder.buildRow(marshalRecord, value, session, marshaller, xPathFragment);
            marshalRecord.afterContainmentMarshal(object, value);
            marshalRecord.popAttributeGroup();
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            marshalRecord.removeExtraNamespacesFromNamespaceResolver(extraNamespaces, session);
        } else {
            if ("UNKNOWN_OR_TRANSIENT_CLASS".equals(this.xmlCompositeCollectionMapping.getReferenceClassName())) {
                throw XMLMarshalException.descriptorNotFoundInProject(value.getClass().getName());
            }
            this.xPathNode.startElement(marshalRecord, xPathFragment, object, session, namespaceResolver, null, value);
            QName schemaType = ((Field)this.xmlCompositeCollectionMapping.getField()).getSchemaTypeForValue(value, session);
            this.updateNamespaces(schemaType, marshalRecord, (Field)this.xmlCompositeCollectionMapping.getField());
            marshalRecord.characters(schemaType, value, null, false);
            marshalRecord.endElement(xPathFragment, namespaceResolver);
        }
        return true;
    }

    @Override
    public CompositeCollectionMapping getMapping() {
        return this.xmlCompositeCollectionMapping;
    }

    @Override
    protected void setOrAddAttributeValue(UnmarshalRecord unmarshalRecord, Object value, XPathFragment xPathFragment, Object collection) {
        unmarshalRecord.addAttributeValue(this, value, collection);
    }

    @Override
    public boolean getReuseContainer() {
        return this.xmlCompositeCollectionMapping.getReuseContainer();
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public boolean isDefaultEmptyContainer() {
        return this.xmlCompositeCollectionMapping.isDefaultEmptyContainer();
    }

    @Override
    public boolean isWrapperAllowedAsCollectionName() {
        return true;
    }
}

